/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.graph;

import io.github.mattidragon.nodeflow.graph.context.Context;
import io.github.mattidragon.nodeflow.graph.context.ContextType;
import io.github.mattidragon.nodeflow.graph.data.DataType;
import io.github.mattidragon.nodeflow.graph.node.NodeType;
import io.github.mattidragon.nodeflow.graph.node.group.NodeGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.ArrayUtils;

public record GraphEnvironment(List<DataType<?>> allowedDataTypes, List<ContextType<?>> availableContexts, List<NodeGroup> groups) {
    public static final class_9139<class_9129, GraphEnvironment> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.method_56365((class_5321)DataType.REGISTRY.method_46765()).method_56433(class_9135.method_56363()), GraphEnvironment::allowedDataTypes, (class_9139)class_9135.method_56365(ContextType.KEY).method_56433(class_9135.method_56363()), GraphEnvironment::availableContexts, (class_9139)NodeGroup.CODEC.method_56433(class_9135.method_56363()), GraphEnvironment::groups, GraphEnvironment::new);

    public GraphEnvironment(List<DataType<?>> allowedDataTypes, List<ContextType<?>> availableContexts, List<NodeGroup> groups) {
        if (allowedDataTypes.isEmpty()) {
            throw new IllegalArgumentException("At least one data type has to be allowed");
        }
        this.allowedDataTypes = List.copyOf(allowedDataTypes);
        this.availableContexts = List.copyOf(availableContexts);
        this.groups = List.copyOf(groups);
    }

    public boolean isAllowedNodeType(NodeType<?> type) {
        return this.groups.stream().map(NodeGroup::getTypes).flatMap(Collection::stream).anyMatch(type::equals);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<DataType<?>> allowedDataTypes = new ArrayList();
        private final List<ContextType<?>> availableContexts = new ArrayList();
        private final List<NodeGroup> groups = new ArrayList<NodeGroup>();

        private Builder() {
        }

        public Builder addDataTypes(DataType<?> ... types) {
            Collections.addAll(this.allowedDataTypes, types);
            return this;
        }

        public Builder addContextTypes(ContextType<?> ... types) {
            Collections.addAll(this.availableContexts, types);
            return this;
        }

        public Builder addDataTypes(List<DataType<?>> types) {
            this.allowedDataTypes.addAll(types);
            return this;
        }

        public Builder addContextTypes(List<ContextType<?>> types) {
            this.availableContexts.addAll(types);
            return this;
        }

        public Builder addNodeGroups(NodeGroup ... groups) {
            this.groups.addAll(Arrays.asList(groups));
            return this;
        }

        public GraphEnvironment build() {
            return new GraphEnvironment(this.allowedDataTypes, this.availableContexts, this.groups);
        }
    }

    private static class DummyContext
    extends Context {
        private final List<ContextType<?>> list;

        public DummyContext(List<ContextType<?>> list) {
            super(Map.of());
            this.list = list;
        }

        @Override
        public <T> T get(ContextType<T> type) {
            return null;
        }

        @Override
        public boolean contains(ContextType<?> type) {
            if (this.list.contains(type)) {
                return true;
            }
            for (ContextType<?> entry : this.list) {
                if (!ArrayUtils.contains((Object[])entry.parents(), type)) continue;
                return true;
            }
            return false;
        }
    }
}

