/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.graph.context;

import io.github.mattidragon.nodeflow.graph.context.ContextType;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;

public class Context {
    private final Map<ContextType<?>, Object> map;

    protected Context(Map<ContextType<?>, Object> map) {
        this.map = map;
    }

    public static Context empty() {
        return new Context(Map.of());
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T get(ContextType<T> type) {
        if (this.map.containsKey(type)) {
            return (T)this.map.get(type);
        }
        for (Map.Entry<ContextType<?>, Object> entry : this.map.entrySet()) {
            if (!ArrayUtils.contains((Object[])entry.getKey().parents(), type)) continue;
            return (T)entry.getValue();
        }
        throw new NoSuchElementException("Missing graph context: " + String.valueOf(type));
    }

    public boolean contains(ContextType<?> type) {
        if (this.map.containsKey(type)) {
            return true;
        }
        for (Map.Entry<ContextType<?>, Object> entry : this.map.entrySet()) {
            if (!ArrayUtils.contains((Object[])entry.getKey().parents(), type)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private final HashMap<ContextType<?>, Object> map = new HashMap();

        public <T> Builder put(ContextType<T> type, T value) {
            this.map.put(type, value);
            return this;
        }

        public Builder putAll(Context context) {
            this.map.putAll(context.map);
            return this;
        }

        public Context build() {
            return new Context(Map.copyOf(this.map));
        }
    }
}

