/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.graph.node;

import com.mojang.datafixers.util.Either;
import io.github.mattidragon.nodeflow.graph.Connector;
import io.github.mattidragon.nodeflow.graph.Graph;
import io.github.mattidragon.nodeflow.graph.context.Context;
import io.github.mattidragon.nodeflow.graph.context.ContextType;
import io.github.mattidragon.nodeflow.graph.data.DataValue;
import io.github.mattidragon.nodeflow.graph.node.NodeTag;
import io.github.mattidragon.nodeflow.graph.node.NodeType;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public abstract class Node {
    public UUID id = UUID.randomUUID();
    public final NodeType<?> type;
    public final List<ContextType<?>> contexts;
    public int guiX = 0;
    public int guiY = 0;
    public NodeTag tag = NodeTag.WHITE;
    @Nullable
    public String nickname = null;
    protected final Graph graph;

    protected Node(NodeType<?> type, List<ContextType<?>> contexts, Graph graph) {
        this.type = type;
        this.contexts = contexts;
        this.graph = graph;
    }

    public abstract Connector<?>[] getOutputs();

    public abstract Connector<?>[] getInputs();

    public Graph getGraph() {
        return this.graph;
    }

    public final Either<DataValue<?>[], class_2561> process(DataValue<?>[] inputs, Context context) {
        return this.process(inputs, new ContextProvider(context));
    }

    protected abstract Either<DataValue<?>[], class_2561> process(DataValue<?>[] var1, ContextProvider var2);

    public List<class_2561> validate() {
        return List.of();
    }

    public final boolean isFullyConnected() {
        for (Connector<?> input : this.getInputs()) {
            if (input.isOptional() || !this.graph.getConnections(input).isEmpty()) continue;
            return false;
        }
        for (Connector<?> output : this.getOutputs()) {
            if (output.isOptional() || !this.graph.getConnections(output).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void readNbt(class_2487 data) {
        data.method_67491("id", class_4844.field_40825).ifPresent(newId -> {
            this.id = newId;
        });
        this.guiX = data.method_68083("guiX", 0);
        this.guiY = data.method_68083("guiY", 0);
        this.tag = NodeTag.fromString(data.method_68564("tag", ""));
        this.nickname = data.method_68564("nickname", this.nickname);
    }

    public void writeNbt(class_2487 data) {
        data.method_10582("type", NodeType.REGISTRY.method_10221(this.type).toString());
        data.method_67494("id", class_4844.field_40825, (Object)this.id);
        data.method_10569("guiX", this.guiX);
        data.method_10569("guiY", this.guiY);
        data.method_10582("tag", this.tag.asString());
        if (this.nickname != null) {
            data.method_10582("nickname", this.nickname);
        }
    }

    public final class_2561 getName() {
        if (this.nickname != null) {
            return class_2561.method_43470((String)this.nickname).method_27692(class_124.field_1056);
        }
        return this.type.name();
    }

    protected final class ContextProvider {
        private final Context context;

        private ContextProvider(Context context) {
            this.context = context;
        }

        public <T> T get(ContextType<T> type) {
            if (!Node.this.contexts.contains(type)) {
                throw new IllegalStateException("Node tried to use context it doesn't require");
            }
            return this.context.get(type);
        }
    }
}

