/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.graph.node;

import io.github.mattidragon.nodeflow.NodeFlow;
import io.github.mattidragon.nodeflow.graph.Graph;
import io.github.mattidragon.nodeflow.graph.data.DataType;
import io.github.mattidragon.nodeflow.graph.node.Node;
import io.github.mattidragon.nodeflow.graph.node.builtin.NumberNode;
import io.github.mattidragon.nodeflow.graph.node.builtin.SendNumberNode;
import io.github.mattidragon.nodeflow.graph.node.builtin.SwitchNode;
import io.github.mattidragon.nodeflow.graph.node.builtin.TimeNode;
import io.github.mattidragon.nodeflow.graph.node.builtin.base.BinaryOperationNode;
import io.github.mattidragon.nodeflow.graph.node.builtin.base.ConstantNode;
import io.github.mattidragon.nodeflow.graph.node.builtin.base.UnaryOperationNode;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7922;

public record NodeType<T extends Node>(Function<Graph, T> generator) {
    public static final class_5321<class_2378<NodeType<?>>> KEY = class_5321.method_29180((class_2960)NodeFlow.id("node_type"));
    public static final class_7922<NodeType<?>> REGISTRY = (class_7922)FabricRegistryBuilder.createDefaulted(KEY, (class_2960)NodeFlow.id("time")).buildAndRegister();
    public static final NodeType<SendNumberNode> BROADCAST = NodeType.register(new NodeType<SendNumberNode>(SendNumberNode::new), NodeFlow.id("broadcast"));
    public static final NodeType<TimeNode> TIME = NodeType.register(new NodeType<TimeNode>(TimeNode::new), NodeFlow.id("time"));
    public static final NodeType<SwitchNode> SWITCH = NodeType.register(new NodeType<SwitchNode>(SwitchNode::new), NodeFlow.id("switch"));
    public static final NodeType<NumberNode> NUMBER = NodeType.register(new NodeType<NumberNode>(NumberNode::new), NodeFlow.id("number"));
    public static final NodeType<ConstantNode> PI = NodeType.register(ConstantNode.makeType(DataType.NUMBER.makeValue(Math.PI)), NodeFlow.id("pi"));
    public static final NodeType<ConstantNode> E = NodeType.register(ConstantNode.makeType(DataType.NUMBER.makeValue(Math.E)), NodeFlow.id("e"));
    public static final NodeType<ConstantNode> ZERO = NodeType.register(ConstantNode.makeType(DataType.NUMBER.makeValue(0.0)), NodeFlow.id("zero"));
    public static final NodeType<ConstantNode> ONE = NodeType.register(ConstantNode.makeType(DataType.NUMBER.makeValue(1.0)), NodeFlow.id("one"));
    public static final NodeType<ConstantNode> NAN = NodeType.register(ConstantNode.makeType(DataType.NUMBER.makeValue(Double.NaN)), NodeFlow.id("nan"));
    public static final NodeType<ConstantNode> INFINITY = NodeType.register(ConstantNode.makeType(DataType.NUMBER.makeValue(Double.POSITIVE_INFINITY)), NodeFlow.id("infinity"));
    public static final NodeType<ConstantNode> TRUE = NodeType.register(ConstantNode.makeType(DataType.BOOLEAN.makeValue(true)), NodeFlow.id("true"));
    public static final NodeType<ConstantNode> FALSE = NodeType.register(ConstantNode.makeType(DataType.BOOLEAN.makeValue(false)), NodeFlow.id("false"));
    public static final NodeType<UnaryOperationNode<Boolean, Boolean>> NOT = NodeType.register(UnaryOperationNode.makeType(DataType.BOOLEAN, DataType.BOOLEAN, input -> input == false), NodeFlow.id("not"));
    public static final NodeType<BinaryOperationNode<Boolean, Boolean>> AND = NodeType.register(BinaryOperationNode.makeType(DataType.BOOLEAN, DataType.BOOLEAN, Boolean::logicalAnd), NodeFlow.id("and"));
    public static final NodeType<BinaryOperationNode<Boolean, Boolean>> OR = NodeType.register(BinaryOperationNode.makeType(DataType.BOOLEAN, DataType.BOOLEAN, Boolean::logicalOr), NodeFlow.id("or"));
    public static final NodeType<BinaryOperationNode<Boolean, Boolean>> XOR = NodeType.register(BinaryOperationNode.makeType(DataType.BOOLEAN, DataType.BOOLEAN, Boolean::logicalXor), NodeFlow.id("xor"));
    public static final NodeType<BinaryOperationNode<Boolean, Boolean>> NAND = NodeType.register(BinaryOperationNode.makeType(DataType.BOOLEAN, DataType.BOOLEAN, (first, second) -> first == false || second == false), NodeFlow.id("nand"));
    public static final NodeType<BinaryOperationNode<Boolean, Boolean>> NOR = NodeType.register(BinaryOperationNode.makeType(DataType.BOOLEAN, DataType.BOOLEAN, (first, second) -> first == false && second == false), NodeFlow.id("nor"));
    public static final NodeType<BinaryOperationNode<Boolean, Boolean>> BOOL_EQL = NodeType.register(BinaryOperationNode.makeType(DataType.BOOLEAN, DataType.BOOLEAN, Boolean::equals), NodeFlow.id("bool_eql"));
    public static final NodeType<UnaryOperationNode<Double, Double>> NEGATE = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, input -> -input.doubleValue()), NodeFlow.id("negate"));
    public static final NodeType<BinaryOperationNode<Double, Double>> ADD = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Double::sum), NodeFlow.id("add"));
    public static final NodeType<BinaryOperationNode<Double, Double>> SUBTRACT = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, (first, second) -> first - second), NodeFlow.id("subtract"));
    public static final NodeType<BinaryOperationNode<Double, Double>> MULTIPLY = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, (first, second) -> first * second), NodeFlow.id("multiply"));
    public static final NodeType<BinaryOperationNode<Double, Double>> DIVIDE = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, (first, second) -> first / second), NodeFlow.id("divide"));
    public static final NodeType<BinaryOperationNode<Double, Double>> MODULO = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, (first, second) -> first % second), NodeFlow.id("modulo"));
    public static final NodeType<BinaryOperationNode<Double, Double>> MIN = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::min), NodeFlow.id("min"));
    public static final NodeType<BinaryOperationNode<Double, Double>> MAX = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::max), NodeFlow.id("max"));
    public static final NodeType<BinaryOperationNode<Double, Double>> POW = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::pow), NodeFlow.id("pow"));
    public static final NodeType<UnaryOperationNode<Double, Double>> SIN = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::sin), NodeFlow.id("sin"));
    public static final NodeType<UnaryOperationNode<Double, Double>> COS = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::cos), NodeFlow.id("cos"));
    public static final NodeType<UnaryOperationNode<Double, Double>> TAN = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::tan), NodeFlow.id("tan"));
    public static final NodeType<UnaryOperationNode<Double, Double>> SINH = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::sinh), NodeFlow.id("sinh"));
    public static final NodeType<UnaryOperationNode<Double, Double>> COSH = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::cosh), NodeFlow.id("cosh"));
    public static final NodeType<UnaryOperationNode<Double, Double>> TANH = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::tanh), NodeFlow.id("tanh"));
    public static final NodeType<UnaryOperationNode<Double, Double>> ASIN = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::asin), NodeFlow.id("asin"));
    public static final NodeType<UnaryOperationNode<Double, Double>> ACOS = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::acos), NodeFlow.id("acos"));
    public static final NodeType<UnaryOperationNode<Double, Double>> ATAN = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::atan), NodeFlow.id("atan"));
    public static final NodeType<UnaryOperationNode<Double, Double>> LOG10 = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::log10), NodeFlow.id("log10"));
    public static final NodeType<UnaryOperationNode<Double, Double>> LOG = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::log), NodeFlow.id("log"));
    public static final NodeType<UnaryOperationNode<Double, Double>> CBRT = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::cbrt), NodeFlow.id("cbrt"));
    public static final NodeType<UnaryOperationNode<Double, Double>> SQRT = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::sqrt), NodeFlow.id("sqrt"));
    public static final NodeType<UnaryOperationNode<Double, Double>> CEIL = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::ceil), NodeFlow.id("ceil"));
    public static final NodeType<UnaryOperationNode<Double, Double>> FLOOR = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::floor), NodeFlow.id("floor"));
    public static final NodeType<UnaryOperationNode<Double, Double>> ABS = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::abs), NodeFlow.id("abs"));
    public static final NodeType<UnaryOperationNode<Double, Double>> SIGNUM = NodeType.register(UnaryOperationNode.makeType(DataType.NUMBER, DataType.NUMBER, Math::signum), NodeFlow.id("signum"));
    public static final NodeType<BinaryOperationNode<Double, Boolean>> NUM_EQL = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.BOOLEAN, (first, second) -> first.doubleValue() == second.doubleValue()), NodeFlow.id("num_eql"));
    public static final NodeType<BinaryOperationNode<Double, Boolean>> NUM_NEQL = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.BOOLEAN, (first, second) -> first.doubleValue() != second.doubleValue()), NodeFlow.id("num_neql"));
    public static final NodeType<BinaryOperationNode<Double, Boolean>> LESS = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.BOOLEAN, (first, second) -> first < second), NodeFlow.id("less"));
    public static final NodeType<BinaryOperationNode<Double, Boolean>> GREATER = NodeType.register(BinaryOperationNode.makeType(DataType.NUMBER, DataType.BOOLEAN, (first, second) -> first > second), NodeFlow.id("greater"));

    public static void register() {
    }

    public static <T extends Node> NodeType<T> register(NodeType<T> type, class_2960 id) {
        class_2378.method_10230(REGISTRY, (class_2960)id, type);
        return type;
    }

    public class_2561 name() {
        return class_2561.method_43471((String)("node." + REGISTRY.method_10221((Object)this).method_42094()));
    }

    @Override
    public String toString() {
        return REGISTRY.method_10221((Object)this).toString();
    }
}

