/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.graph.node.builtin;

import com.mojang.datafixers.util.Either;
import io.github.mattidragon.nodeflow.graph.Connector;
import io.github.mattidragon.nodeflow.graph.Graph;
import io.github.mattidragon.nodeflow.graph.data.DataType;
import io.github.mattidragon.nodeflow.graph.data.DataValue;
import io.github.mattidragon.nodeflow.graph.node.Node;
import io.github.mattidragon.nodeflow.graph.node.NodeType;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class NumberNode
extends Node {
    private String value = "";

    public NumberNode(Graph graph) {
        super(NodeType.NUMBER, List.of(), graph);
    }

    @Override
    public Connector<?>[] getOutputs() {
        return new Connector[]{DataType.NUMBER.makeRequiredOutput("value", this)};
    }

    @Override
    public Connector<?>[] getInputs() {
        return new Connector[0];
    }

    @Override
    public List<class_2561> validate() {
        try {
            Double.parseDouble(this.value);
            return List.of();
        }
        catch (NumberFormatException e) {
            return List.of(class_2561.method_43469((String)"node.nodeflow.number.invalid", (Object[])new Object[]{this.value}));
        }
    }

    @Override
    protected Either<DataValue<?>[], class_2561> process(DataValue<?>[] inputs, Node.ContextProvider context) {
        return Either.left((Object)new DataValue[]{DataType.NUMBER.makeValue(Double.valueOf(this.value))});
    }

    public boolean hasConfig() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void readNbt(class_2487 data) {
        super.readNbt(data);
        this.value = data.method_68564("value", "");
    }

    @Override
    public void writeNbt(class_2487 data) {
        super.writeNbt(data);
        data.method_10582("value", this.value);
    }
}

