/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.nodeflow.graph.node.builtin.base;

import com.mojang.datafixers.util.Either;
import io.github.mattidragon.nodeflow.graph.Connector;
import io.github.mattidragon.nodeflow.graph.Graph;
import io.github.mattidragon.nodeflow.graph.data.DataType;
import io.github.mattidragon.nodeflow.graph.data.DataValue;
import io.github.mattidragon.nodeflow.graph.node.Node;
import io.github.mattidragon.nodeflow.graph.node.NodeType;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;

public class UnaryOperationNode<T, R>
extends Node {
    private final DataType<T> inputType;
    private final DataType<R> resultType;
    private final Function<T, R> function;

    public UnaryOperationNode(NodeType<UnaryOperationNode<T, R>> type, Graph graph, DataType<T> inputType, DataType<R> resultType, Function<T, R> function) {
        super(type, List.of(), graph);
        this.inputType = inputType;
        this.resultType = resultType;
        this.function = function;
    }

    public static <T, R> NodeType<UnaryOperationNode<T, R>> makeType(DataType<T> inputType, DataType<R> resultType, Function<T, R> function) {
        var type = new Object(){
            NodeType<UnaryOperationNode<T, R>> type;
        };
        type.type = new NodeType<UnaryOperationNode<T, R>>(graph -> new UnaryOperationNode(type.type, (Graph)graph, inputType, resultType, function));
        return type.type;
    }

    @Override
    public Connector<?>[] getOutputs() {
        return new Connector[]{this.resultType.makeRequiredOutput("result", this)};
    }

    @Override
    public Connector<?>[] getInputs() {
        return new Connector[]{this.inputType.makeRequiredInput("input", this)};
    }

    @Override
    protected Either<DataValue<?>[], class_2561> process(DataValue<?>[] inputs, Node.ContextProvider context) {
        return Either.left((Object)new DataValue[]{this.resultType.makeValue(this.function.apply(inputs[0].getAs(this.inputType)))});
    }
}

