/*
 * Decompiled with CFR 0.152.
 */
package net.elderbeans.soulspeedfovfix.mixin;

import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin {
    @Unique
    private static final ResourceLocation SOUL_SPEED_MODIFIER_ID = ResourceLocation.parse((String)"minecraft:enchantment.soul_speed/feet");

    @Inject(method={"getFieldOfViewModifier"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetFieldOfViewModifier(CallbackInfoReturnable<Float> cir) {
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        AttributeInstance speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute == null) {
            return;
        }
        if (speedAttribute.getModifier(SOUL_SPEED_MODIFIER_ID) != null) {
            float newFov = 1.0f;
            if (player.isSprinting()) {
                newFov *= 1.15f;
            }
            cir.setReturnValue((Object)Float.valueOf(newFov));
        }
    }
}

