/*
 * Decompiled with CFR 0.152.
 */
package cats.on.head.item;

import cats.on.head.CatsOnHead;
import cats.on.head.effects.LoveOfTheCat;
import cats.on.head.interfaces.CatEntityVarsInterface;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketItem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_10686;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1451;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7375;
import net.minecraft.class_7924;
import net.minecraft.class_8959;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class CatItem
extends TrinketItem {
    public CatItem() {
        super(new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)CatsOnHead.of("cat_item"))).method_57349(CatsOnHead.FED_FISH_COUNT, (Object)0).method_7889(1));
        CatsOnHead.register((class_1792)this, "cat_item");
    }

    private static int getAmplifierLevel(class_1799 stack) {
        int amplifier = 0;
        if (stack.method_57353().method_57832(CatsOnHead.FED_FISH_COUNT)) {
            amplifier = (Integer)stack.method_58694(CatsOnHead.FED_FISH_COUNT) / 64;
        }
        if (amplifier > 4) {
            amplifier = 4;
        }
        if (amplifier < 0) {
            amplifier = 0;
        }
        return amplifier;
    }

    public void giveStatusEffect(class_1309 player, class_1799 stack) {
        if (!player.method_6059(LoveOfTheCat.LOVE_OF_THE_CAT)) {
            player.method_6092(new class_1293(LoveOfTheCat.LOVE_OF_THE_CAT, -1, CatItem.getAmplifierLevel(stack), false, false, false));
        }
        this.updateStatusEffect(player, stack);
    }

    public void updateStatusEffect(class_1309 player, class_1799 stack) {
        if (player.method_6059(LoveOfTheCat.LOVE_OF_THE_CAT) && player.method_6112(LoveOfTheCat.LOVE_OF_THE_CAT).method_5578() != CatItem.getAmplifierLevel(stack)) {
            player.method_6016(LoveOfTheCat.LOVE_OF_THE_CAT);
            player.method_6092(new class_1293(LoveOfTheCat.LOVE_OF_THE_CAT, -1, CatItem.getAmplifierLevel(stack), false, false, false));
        }
    }

    public class_6880<class_3414> getEquipSound(class_1799 stack, SlotReference slot, class_1309 entity) {
        return class_6880.method_40223((Object)class_3417.field_15051);
    }

    public void onEquip(class_1799 stack, SlotReference slot, class_1309 player) {
        if (slot.inventory().getComponent().isEquipped(CatsOnHead.CAT_ITEM)) {
            this.giveStatusEffect(player, stack);
        }
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 player) {
        player.method_6016(LoveOfTheCat.LOVE_OF_THE_CAT);
    }

    public class_2561 method_7864(class_1799 stack) {
        if (stack.method_58695(CatsOnHead.VARIANT, (Object)class_10686.field_56264) == CatsOnHead.NIKO) {
            return class_2561.method_43470((String)"Niko");
        }
        if (stack.method_58695(CatsOnHead.VARIANT, (Object)class_10686.field_56264) == CatsOnHead.ABIGAIL) {
            return class_2561.method_43470((String)"Abigail");
        }
        if (stack.method_57353().method_57832(CatsOnHead.CUSTOM_NAME)) {
            return class_2561.method_43470((String)((String)stack.method_58694(CatsOnHead.CUSTOM_NAME))).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
        }
        class_2561 text = super.method_7864(stack);
        if (stack.method_57826(CatsOnHead.VARIANT)) {
            class_5250 mText = class_2561.method_43471((String)("variant." + CatsOnHead.fixCatVariantId(((class_5321)stack.method_58694(CatsOnHead.VARIANT)).method_29177().toString())));
            mText.method_10852((class_2561)class_2561.method_43470((String)" "));
            mText.method_10852(text);
            return mText;
        }
        return text;
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        class_5250 text;
        int rgb = class_124.field_1080.method_532();
        if (stack.method_57826(CatsOnHead.OWNER_NAME)) {
            text = class_2561.method_43471((String)"cats_on_head.translatable.owner_name").method_27693(": ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
            text.method_10852((class_2561)class_2561.method_43470((String)((String)stack.method_58694(CatsOnHead.OWNER_NAME))).method_10862(class_2583.field_24360.method_36139(rgb)));
            textConsumer.accept((class_2561)text);
        }
        if (stack.method_57826(CatsOnHead.COLLAR_COLOR)) {
            rgb = Integer.parseInt((String)stack.method_58694(CatsOnHead.COLLAR_COLOR));
            text = class_2561.method_43471((String)"cats_on_head.translatable.collar_color").method_27693(": ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
            text.method_10852((class_2561)class_2561.method_43470((String)CatsOnHead.rgbToHex(rgb)).method_10862(class_2583.field_24360.method_36139(rgb)));
            textConsumer.accept((class_2561)text);
        }
        if (stack.method_57826(CatsOnHead.FED_FISH_COUNT)) {
            int count = (Integer)stack.method_58694(CatsOnHead.FED_FISH_COUNT);
            class_124 color = class_124.field_1080;
            if (count >= 64) {
                color = class_124.field_1060;
            }
            if (count >= 128) {
                color = class_124.field_1075;
            }
            if (count >= 192) {
                color = class_124.field_1064;
            }
            if (count >= 256) {
                color = class_124.field_1054;
            }
            class_5250 text2 = class_2561.method_43471((String)"cats_on_head.translatable.fed_fish_count").method_27693(": ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
            text2.method_10852((class_2561)class_2561.method_43470((String)("" + count)).method_10862(class_2583.field_24360.method_10977(color)));
            textConsumer.accept((class_2561)text2);
        }
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.updateStatusEffect((class_1309)player, stack);
            if (player.method_6047() == stack) {
                if (world.method_8409().method_43057() < 0.02f) {
                    world.method_54762((class_1297)((class_1657)null), entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14741, entity.method_5634());
                }
            } else {
                try {
                    if (world.method_8409().method_43057() < 0.0025f) {
                        world.method_54762((class_1297)((class_1657)null), entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14741, entity.method_5634());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        class_1799 itemStack = context.method_8041();
        class_9323 components = itemStack.method_57353();
        class_2338 blockPos = context.method_8037();
        class_2350 direction = context.method_8038();
        class_2680 blockState = world.method_8320(blockPos);
        class_2586 var8 = world.method_8321(blockPos);
        String ownerUuid = (String)components.method_58694(CatsOnHead.OWNER_UUID);
        if (var8 instanceof class_8959) {
            return class_1269.field_5811;
        }
        if (ownerUuid == null || ownerUuid.equals(context.method_8036().method_5845())) {
            class_2338 blockPos2 = blockState.method_26220((class_1922)world, blockPos).method_1110() ? blockPos : blockPos.method_10093(direction);
            class_1299 entityType = class_1299.field_16281;
            class_1297 entity = entityType.method_5894((class_3218)world, itemStack, (class_1309)context.method_8036(), blockPos2, class_3730.field_16465, true, !Objects.equals(blockPos, blockPos2) && direction == class_2350.field_11036);
            if (entity != null) {
                itemStack.method_7934(1);
                world.method_33596((class_1297)context.method_8036(), (class_6880)class_5712.field_28738, blockPos);
                if (entity instanceof class_1451) {
                    class_1451 cat = (class_1451)entity;
                    cat.method_6174((class_1309)context.method_8036());
                    cat.method_6173(true, true);
                    if (components.method_57832(CatsOnHead.VARIANT)) {
                        ((CatEntityVarsInterface)cat).set_Variant((class_6880<class_7375>)cat.method_56673().method_66874((class_5321)components.method_58694(CatsOnHead.VARIANT)));
                    }
                    cat.method_5971();
                    if (components.method_57832(CatsOnHead.FED_FISH_COUNT)) {
                        ((CatEntityVarsInterface)cat).set_eatedFish((Integer)components.method_58694(CatsOnHead.FED_FISH_COUNT));
                    }
                    if (components.method_57832(CatsOnHead.COLLAR_COLOR_ID)) {
                        cat.method_5841().method_12778(((CatEntityVarsInterface)cat).get_COLLAR_COLOR(), (Object)((Integer)components.method_58694(CatsOnHead.COLLAR_COLOR_ID)));
                    }
                    if (components.method_57832(CatsOnHead.CUSTOM_NAME)) {
                        cat.method_5665((class_2561)class_2561.method_43470((String)((String)components.method_58694(CatsOnHead.CUSTOM_NAME))));
                    }
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_1269 removeFromHead(class_1937 world, class_1657 user) {
        class_1799 itemStack = CatsOnHead.getCatStack(user, 0);
        class_9323 components = itemStack.method_57353();
        class_3965 blockHitResult = CatItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1345);
        String ownerUuid = (String)components.method_58694(CatsOnHead.OWNER_UUID);
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1269.field_5811;
        }
        if (world instanceof class_3218 && (ownerUuid == null || ownerUuid.equals(user.method_5845()))) {
            class_3218 serverWorld = (class_3218)world;
            class_2338 blockPos = blockHitResult.method_17777();
            if (world.method_8505((class_1297)user, blockPos) && user.method_7343(blockPos, blockHitResult.method_17780(), itemStack)) {
                class_1299 entityType = class_1299.field_16281;
                class_1297 entity = entityType.method_5894(serverWorld, itemStack, (class_1309)user, new class_2338((int)user.method_23317(), (int)user.method_23318(), (int)user.method_23321()), class_3730.field_16461, false, false);
                if (entity == null) {
                    return class_1269.field_5811;
                }
                itemStack.method_7934(1);
                user.method_7259(class_3468.field_15372.method_14956((Object)this));
                world.method_43275((class_1297)user, (class_6880)class_5712.field_28738, entity.method_73189());
                if (entity instanceof class_1451) {
                    class_1451 cat = (class_1451)entity;
                    cat.method_6174((class_1309)user);
                    cat.method_6173(true, true);
                    if (components.method_57832(CatsOnHead.VARIANT)) {
                        ((CatEntityVarsInterface)cat).set_Variant((class_6880<class_7375>)cat.method_56673().method_66874((class_5321)components.method_58694(CatsOnHead.VARIANT)));
                    }
                    cat.method_5971();
                    if (components.method_57832(CatsOnHead.FED_FISH_COUNT)) {
                        ((CatEntityVarsInterface)cat).set_eatedFish((Integer)components.method_58694(CatsOnHead.FED_FISH_COUNT));
                    }
                    if (components.method_57832(CatsOnHead.COLLAR_COLOR_ID)) {
                        cat.method_5841().method_12778(((CatEntityVarsInterface)cat).get_COLLAR_COLOR(), (Object)((Integer)components.method_58694(CatsOnHead.COLLAR_COLOR_ID)));
                    }
                    if (components.method_57832(CatsOnHead.CUSTOM_NAME)) {
                        cat.method_5665((class_2561)class_2561.method_43470((String)((String)components.method_58694(CatsOnHead.CUSTOM_NAME))));
                    }
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5814;
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, @Nullable class_1268 hand) {
        class_1799 itemStack = null;
        if (hand != null) {
            itemStack = user.method_5998(hand);
        } else if (CatsOnHead.hasCat(user)) {
            itemStack = CatsOnHead.getCatStack(user, 0);
        }
        class_9323 components = itemStack.method_57353();
        class_3965 blockHitResult = CatItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1345);
        String ownerUuid = (String)components.method_58694(CatsOnHead.OWNER_UUID);
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1269.field_5811;
        }
        if (world instanceof class_3218 && (ownerUuid == null || ownerUuid.equals(user.method_5845()))) {
            class_3218 serverWorld = (class_3218)world;
            class_2338 blockPos = blockHitResult.method_17777();
            if (!(world.method_8320(blockPos).method_26204() instanceof class_2404)) {
                return class_1269.field_5811;
            }
            if (world.method_8505((class_1297)user, blockPos) && user.method_7343(blockPos, blockHitResult.method_17780(), itemStack)) {
                class_1299 entityType = class_1299.field_16281;
                class_1297 entity = entityType.method_5894(serverWorld, itemStack, (class_1309)user, blockPos, class_3730.field_16465, false, false);
                if (entity == null) {
                    return class_1269.field_5811;
                }
                itemStack.method_57008(1, (class_1309)user);
                user.method_7259(class_3468.field_15372.method_14956((Object)this));
                world.method_43275((class_1297)user, (class_6880)class_5712.field_28738, entity.method_73189());
                if (entity instanceof class_1451) {
                    class_1451 cat = (class_1451)entity;
                    cat.method_6174((class_1309)user);
                    cat.method_6173(true, true);
                    if (components.method_57832(CatsOnHead.VARIANT)) {
                        ((CatEntityVarsInterface)cat).set_Variant((class_6880<class_7375>)cat.method_56673().method_66874((class_5321)components.method_58694(CatsOnHead.VARIANT)));
                    }
                    cat.method_5971();
                    if (components.method_57832(CatsOnHead.FED_FISH_COUNT)) {
                        ((CatEntityVarsInterface)cat).set_eatedFish((Integer)components.method_58694(CatsOnHead.FED_FISH_COUNT));
                    }
                    if (components.method_57832(CatsOnHead.COLLAR_COLOR_ID)) {
                        cat.method_5841().method_12778(((CatEntityVarsInterface)cat).get_COLLAR_COLOR(), (Object)((Integer)components.method_58694(CatsOnHead.COLLAR_COLOR_ID)));
                    }
                    if (components.method_57832(CatsOnHead.CUSTOM_NAME)) {
                        cat.method_5665((class_2561)class_2561.method_43470((String)((String)components.method_58694(CatsOnHead.CUSTOM_NAME))));
                    }
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5814;
    }
}

