/*
 * Decompiled with CFR 0.152.
 */
package tfar.unstabletools.crafting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.unstabletools.JSONUtils2;

public class ConversionManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<class_2248, class_2248> conversionMap = new HashMap<class_2248, class_2248>();
    private boolean someRecipesErrored;
    public static final String BLOCK_CONVS = "block_conversions";

    public ConversionManager() {
        super(GSON, BLOCK_CONVS);
    }

    protected void apply(Map<class_2960, JsonElement> objectIn, class_3300 resourceManagerIn, class_3695 profilerIn) {
        this.someRecipesErrored = false;
        this.conversionMap.clear();
        for (Map.Entry<class_2960, JsonElement> entry : objectIn.entrySet()) {
            class_2960 resourcelocation = entry.getKey();
            if (resourcelocation.method_12832().startsWith("_")) continue;
            try {
                Pair<class_2248, class_2248> blockPair = ConversionManager.deserializeConversion(class_3518.method_15295((JsonElement)entry.getValue(), (String)"top element"));
                if (blockPair == null) {
                    LOGGER.info("Skipping loading conversion {} as it is empty", (Object)resourcelocation);
                    continue;
                }
                this.conversionMap.put((class_2248)blockPair.getFirst(), (class_2248)blockPair.getSecond());
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Parsing error loading conversion {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        LOGGER.info("Loaded {} block conversions", (Object)this.conversionMap.size());
    }

    public static Pair<class_2248, class_2248> deserializeConversion(JsonObject json) {
        if (json.isEmpty()) {
            return null;
        }
        class_2248 s1 = JSONUtils2.getBlock(json, "from");
        class_2248 s2 = JSONUtils2.getBlock(json, "to");
        return Pair.of((Object)s1, (Object)s2);
    }

    public Map<class_2248, class_2248> getConversionMap() {
        return this.conversionMap;
    }
}

