/*
 * Decompiled with CFR 0.152.
 */
package com.wampi.aq.datagen;

import com.wampi.aq.block.AQBlocks;
import com.wampi.aq.item.AQItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class AQRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public AQRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AQBlocks.TURTLE_BLOCK.get())).pattern("BBB").pattern("BBB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)AQItems.TURTLE_INGOT.get()).unlockedBy("has_turtle_ingot", AQRecipeProvider.has(AQItems.TURTLE_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AQBlocks.SCUTE_BLOCK.get())).pattern("BBB").pattern("BBB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)Items.TURTLE_SCUTE).unlockedBy("has_scute", AQRecipeProvider.has((ItemLike)Items.TURTLE_SCUTE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AQItems.TURTLE_CHESTPLATE).pattern("B B").pattern("BBB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)Items.TURTLE_SCUTE).unlockedBy("has_scute", AQRecipeProvider.has((ItemLike)Items.TURTLE_SCUTE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AQItems.TURTLE_LEGGINGS).pattern("BBB").pattern("B B").pattern("B B").define(Character.valueOf('B'), (ItemLike)Items.TURTLE_SCUTE).unlockedBy("has_scute", AQRecipeProvider.has((ItemLike)Items.TURTLE_SCUTE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AQItems.TURTLE_BOOTS).pattern("   ").pattern("B B").pattern("B B").define(Character.valueOf('B'), (ItemLike)Items.TURTLE_SCUTE).unlockedBy("has_scute", AQRecipeProvider.has((ItemLike)Items.TURTLE_SCUTE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AQItems.TURTLE_MASTER_CRAFTING_UPGRADE).pattern("PNP").pattern("NHN").pattern("PNP").define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_SHARD).define(Character.valueOf('N'), (ItemLike)Items.NAUTILUS_SHELL).define(Character.valueOf('H'), (ItemLike)Items.HEART_OF_THE_SEA).unlockedBy("has_heart_of_the_sea", AQRecipeProvider.has((ItemLike)Items.HEART_OF_THE_SEA)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)AQItems.TURTLE_INGOT.get()), (int)1).requires((ItemLike)Items.PRISMARINE_SHARD).requires((ItemLike)Items.PRISMARINE_CRYSTALS).requires((ItemLike)Items.GOLD_INGOT).requires((ItemLike)Items.DIAMOND).unlockedBy("has_turtle_chestplate", AQRecipeProvider.has(AQItems.TURTLE_CHESTPLATE)).save(recipeOutput, "aq:turtle_ingot_2");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_MASTER_CRAFTING_UPGRADE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.TURTLE_HELMET}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_INGOT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)AQItems.TURTLE_MASTER_HELMET.get())).unlocks("has_template", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_MASTER_CRAFTING_UPGRADE.get()))).unlocks("has_addition", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_INGOT.get()))).unlocks("has_base", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_HELMET.get()))).save(recipeOutput, "aq:turtle_master_helmet_via_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_MASTER_CRAFTING_UPGRADE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_CHESTPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_INGOT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)AQItems.TURTLE_MASTER_CHESTPLATE.get())).unlocks("has_template", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_MASTER_CRAFTING_UPGRADE.get()))).unlocks("has_addition", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_INGOT.get()))).unlocks("has_base", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_CHESTPLATE.get()))).save(recipeOutput, "aq:turtle_master_chestplate_via_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_MASTER_CRAFTING_UPGRADE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_LEGGINGS.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_INGOT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)AQItems.TURTLE_MASTER_LEGGINGS.get())).unlocks("has_template", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_MASTER_CRAFTING_UPGRADE.get()))).unlocks("has_addition", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_INGOT.get()))).unlocks("has_base", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_LEGGINGS.get()))).save(recipeOutput, "aq:turtle_master_leggings_via_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_MASTER_CRAFTING_UPGRADE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_BOOTS.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AQItems.TURTLE_INGOT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)AQItems.TURTLE_MASTER_BOOTS.get())).unlocks("has_template", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_MASTER_CRAFTING_UPGRADE.get()))).unlocks("has_addition", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_INGOT.get()))).unlocks("has_base", AQRecipeProvider.has((ItemLike)((ItemLike)AQItems.TURTLE_BOOTS.get()))).save(recipeOutput, "aq:turtle_master_boots_via_smithing");
    }

    protected static void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        AQRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        AQRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> pCookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, factory).group(pGroup).unlockedBy(AQRecipeProvider.getHasName((ItemLike)itemlike), AQRecipeProvider.has((ItemLike)itemlike)).save(recipeOutput, "aq:" + AQRecipeProvider.getItemName((ItemLike)pResult) + pRecipeName + "_" + AQRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }
}

