/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.chromosome;

import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.platform.Services;
import com.hexagram2021.chromosomelib.registry.CLEntityTypeTags;
import com.hexagram2021.chromosomelib.registry.RegistryRelations;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public final class BuiltInChromosomes {
    private BuiltInChromosomes() {
    }

    public static void init(Consumer<Runnable> enqueue) {
        Axolotl.init();
        Bee.init();
        Cat.init();
        Chicken.init();
        Cow.init();
        Donkey.init();
        Fox.init();
        Frog.init();
        Goat.init();
        Horse.init();
        Human.init();
        Mule.init();
        Ocelot.init();
        Panda.init();
        Parrot.init();
        Pig.init();
        PolarBear.init();
        Rabbit.init();
        Sheep.init();
        Turtle.init();
        enqueue.accept(Axolotl::registerRelations);
        enqueue.accept(Bee::registerRelations);
        enqueue.accept(Cat::registerRelations);
        enqueue.accept(Chicken::registerRelations);
        enqueue.accept(Cow::registerRelations);
        enqueue.accept(Donkey::registerRelations);
        enqueue.accept(Fox::registerRelations);
        enqueue.accept(Frog::registerRelations);
        enqueue.accept(Goat::registerRelations);
        enqueue.accept(Horse::registerRelations);
        enqueue.accept(Human::registerRelations);
        enqueue.accept(Mule::registerRelations);
        enqueue.accept(Ocelot::registerRelations);
        enqueue.accept(Panda::registerRelations);
        enqueue.accept(Parrot::registerRelations);
        enqueue.accept(Pig::registerRelations);
        enqueue.accept(PolarBear::registerRelations);
        enqueue.accept(Rabbit::registerRelations);
        enqueue.accept(Sheep::registerRelations);
        enqueue.accept(Turtle::registerRelations);
    }

    private static Holder<Chromosome> register(String name, int index) {
        return Services.PLATFORM.registerChromosome(new ResourceLocation("chromosomelib", name.toLowerCase(Locale.ROOT)), () -> new Chromosome(index));
    }

    public static final class Axolotl {
        public static final Holder<Chromosome> AXOLOTL_1 = BuiltInChromosomes.register("axolotl_1", 1);
        public static final Holder<Chromosome> AXOLOTL_2 = BuiltInChromosomes.register("axolotl_2", 2);
        public static final Holder<Chromosome> AXOLOTL_3 = BuiltInChromosomes.register("axolotl_3", 3);
        public static final Holder<Chromosome> AXOLOTL_4 = BuiltInChromosomes.register("axolotl_4", 4);
        public static final Holder<Chromosome> AXOLOTL_5 = BuiltInChromosomes.register("axolotl_5", 5);
        public static final Holder<Chromosome> AXOLOTL_6 = BuiltInChromosomes.register("axolotl_6", 6);
        public static final Holder<Chromosome> AXOLOTL_7 = BuiltInChromosomes.register("axolotl_7", 7);
        public static final Holder<Chromosome> AXOLOTL_8 = BuiltInChromosomes.register("axolotl_8", 8);
        public static final Holder<Chromosome> AXOLOTL_9 = BuiltInChromosomes.register("axolotl_9", 9);
        public static final Holder<Chromosome> AXOLOTL_10 = BuiltInChromosomes.register("axolotl_10", 10);
        public static final Holder<Chromosome> AXOLOTL_11 = BuiltInChromosomes.register("axolotl_11", 11);
        public static final Holder<Chromosome> AXOLOTL_12 = BuiltInChromosomes.register("axolotl_12", 12);
        public static final Holder<Chromosome> AXOLOTL_13 = BuiltInChromosomes.register("axolotl_13", 13);
        public static final Holder<Chromosome> AXOLOTL_XY = BuiltInChromosomes.register("axolotl_xy", 14);

        private Axolotl() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147039_, AXOLOTL_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(AXOLOTL_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Bee {
        public static final Holder<Chromosome> BEE_1 = BuiltInChromosomes.register("bee_1", 1);
        public static final Holder<Chromosome> BEE_2 = BuiltInChromosomes.register("bee_2", 2);
        public static final Holder<Chromosome> BEE_3 = BuiltInChromosomes.register("bee_3", 3);
        public static final Holder<Chromosome> BEE_4 = BuiltInChromosomes.register("bee_4", 4);
        public static final Holder<Chromosome> BEE_5 = BuiltInChromosomes.register("bee_5", 5);
        public static final Holder<Chromosome> BEE_6 = BuiltInChromosomes.register("bee_6", 6);
        public static final Holder<Chromosome> BEE_7 = BuiltInChromosomes.register("bee_7", 7);
        public static final Holder<Chromosome> BEE_8 = BuiltInChromosomes.register("bee_8", 8);
        public static final Holder<Chromosome> BEE_9 = BuiltInChromosomes.register("bee_9", 9);
        public static final Holder<Chromosome> BEE_10 = BuiltInChromosomes.register("bee_10", 10);
        public static final Holder<Chromosome> BEE_11 = BuiltInChromosomes.register("bee_11", 11);
        public static final Holder<Chromosome> BEE_12 = BuiltInChromosomes.register("bee_12", 12);
        public static final Holder<Chromosome> BEE_13 = BuiltInChromosomes.register("bee_13", 13);
        public static final Holder<Chromosome> BEE_14 = BuiltInChromosomes.register("bee_14", 14);
        public static final Holder<Chromosome> BEE_15 = BuiltInChromosomes.register("bee_15", 15);
        public static final Holder<Chromosome> BEE_16 = BuiltInChromosomes.register("bee_16", 16);

        private Bee() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20550_, BEE_16);
        }
    }

    public static final class Cat {
        public static final Holder<Chromosome> CAT_1 = BuiltInChromosomes.register("cat_1", 1);
        public static final Holder<Chromosome> CAT_2 = BuiltInChromosomes.register("cat_2", 2);
        public static final Holder<Chromosome> CAT_3 = BuiltInChromosomes.register("cat_3", 3);
        public static final Holder<Chromosome> CAT_4 = BuiltInChromosomes.register("cat_4", 4);
        public static final Holder<Chromosome> CAT_5 = BuiltInChromosomes.register("cat_5", 5);
        public static final Holder<Chromosome> CAT_6 = BuiltInChromosomes.register("cat_6", 6);
        public static final Holder<Chromosome> CAT_7 = BuiltInChromosomes.register("cat_7", 7);
        public static final Holder<Chromosome> CAT_8 = BuiltInChromosomes.register("cat_8", 8);
        public static final Holder<Chromosome> CAT_9 = BuiltInChromosomes.register("cat_9", 9);
        public static final Holder<Chromosome> CAT_10 = BuiltInChromosomes.register("cat_10", 10);
        public static final Holder<Chromosome> CAT_11 = BuiltInChromosomes.register("cat_11", 11);
        public static final Holder<Chromosome> CAT_12 = BuiltInChromosomes.register("cat_12", 12);
        public static final Holder<Chromosome> CAT_13 = BuiltInChromosomes.register("cat_13", 13);
        public static final Holder<Chromosome> CAT_14 = BuiltInChromosomes.register("cat_14", 14);
        public static final Holder<Chromosome> CAT_15 = BuiltInChromosomes.register("cat_15", 15);
        public static final Holder<Chromosome> CAT_16 = BuiltInChromosomes.register("cat_16", 16);
        public static final Holder<Chromosome> CAT_17 = BuiltInChromosomes.register("cat_17", 17);
        public static final Holder<Chromosome> CAT_18 = BuiltInChromosomes.register("cat_18", 18);
        public static final Holder<Chromosome> CAT_XY = BuiltInChromosomes.register("cat_xy", 19);

        private Cat() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20553_, CAT_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(CAT_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Chicken {
        public static final Holder<Chromosome> CHICKEN_1 = BuiltInChromosomes.register("chicken_1", 1);
        public static final Holder<Chromosome> CHICKEN_2 = BuiltInChromosomes.register("chicken_2", 2);
        public static final Holder<Chromosome> CHICKEN_3 = BuiltInChromosomes.register("chicken_3", 3);
        public static final Holder<Chromosome> CHICKEN_4 = BuiltInChromosomes.register("chicken_4", 4);
        public static final Holder<Chromosome> CHICKEN_5 = BuiltInChromosomes.register("chicken_5", 5);
        public static final Holder<Chromosome> CHICKEN_6 = BuiltInChromosomes.register("chicken_6", 6);
        public static final Holder<Chromosome> CHICKEN_7 = BuiltInChromosomes.register("chicken_7", 7);
        public static final Holder<Chromosome> CHICKEN_8 = BuiltInChromosomes.register("chicken_8", 8);
        public static final Holder<Chromosome> CHICKEN_9 = BuiltInChromosomes.register("chicken_9", 9);
        public static final Holder<Chromosome> CHICKEN_10 = BuiltInChromosomes.register("chicken_10", 10);
        public static final Holder<Chromosome> CHICKEN_11 = BuiltInChromosomes.register("chicken_11", 11);
        public static final Holder<Chromosome> CHICKEN_12 = BuiltInChromosomes.register("chicken_12", 12);
        public static final Holder<Chromosome> CHICKEN_13 = BuiltInChromosomes.register("chicken_13", 13);
        public static final Holder<Chromosome> CHICKEN_14 = BuiltInChromosomes.register("chicken_14", 14);
        public static final Holder<Chromosome> CHICKEN_15 = BuiltInChromosomes.register("chicken_15", 15);
        public static final Holder<Chromosome> CHICKEN_16 = BuiltInChromosomes.register("chicken_16", 16);
        public static final Holder<Chromosome> CHICKEN_17 = BuiltInChromosomes.register("chicken_17", 17);
        public static final Holder<Chromosome> CHICKEN_18 = BuiltInChromosomes.register("chicken_18", 18);
        public static final Holder<Chromosome> CHICKEN_19 = BuiltInChromosomes.register("chicken_19", 19);
        public static final Holder<Chromosome> CHICKEN_20 = BuiltInChromosomes.register("chicken_20", 20);
        public static final Holder<Chromosome> CHICKEN_21 = BuiltInChromosomes.register("chicken_21", 21);
        public static final Holder<Chromosome> CHICKEN_22 = BuiltInChromosomes.register("chicken_22", 22);
        public static final Holder<Chromosome> CHICKEN_23 = BuiltInChromosomes.register("chicken_23", 23);
        public static final Holder<Chromosome> CHICKEN_24 = BuiltInChromosomes.register("chicken_24", 24);
        public static final Holder<Chromosome> CHICKEN_25 = BuiltInChromosomes.register("chicken_25", 25);
        public static final Holder<Chromosome> CHICKEN_26 = BuiltInChromosomes.register("chicken_26", 26);
        public static final Holder<Chromosome> CHICKEN_27 = BuiltInChromosomes.register("chicken_27", 27);
        public static final Holder<Chromosome> CHICKEN_28 = BuiltInChromosomes.register("chicken_28", 28);
        public static final Holder<Chromosome> CHICKEN_29 = BuiltInChromosomes.register("chicken_29", 29);
        public static final Holder<Chromosome> CHICKEN_30 = BuiltInChromosomes.register("chicken_30", 30);
        public static final Holder<Chromosome> CHICKEN_31 = BuiltInChromosomes.register("chicken_31", 31);
        public static final Holder<Chromosome> CHICKEN_32 = BuiltInChromosomes.register("chicken_32", 32);
        public static final Holder<Chromosome> CHICKEN_33 = BuiltInChromosomes.register("chicken_33", 33);
        public static final Holder<Chromosome> CHICKEN_34 = BuiltInChromosomes.register("chicken_34", 34);
        public static final Holder<Chromosome> CHICKEN_35 = BuiltInChromosomes.register("chicken_35", 35);
        public static final Holder<Chromosome> CHICKEN_36 = BuiltInChromosomes.register("chicken_36", 36);
        public static final Holder<Chromosome> CHICKEN_37 = BuiltInChromosomes.register("chicken_37", 37);
        public static final Holder<Chromosome> CHICKEN_38 = BuiltInChromosomes.register("chicken_38", 38);
        public static final Holder<Chromosome> CHICKEN_ZW = BuiltInChromosomes.register("chicken_zw", 39);

        private Chicken() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_28);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_29);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_30);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_31);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_32);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_33);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_34);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_35);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_36);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_37);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_38);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20555_, CHICKEN_ZW);
            RegistryRelations.registerNecessaryChromosomeTypes(CHICKEN_ZW, ChromosomeType.LEFT);
        }
    }

    public static final class Cow {
        public static final Holder<Chromosome> COW_1 = BuiltInChromosomes.register("cow_1", 1);
        public static final Holder<Chromosome> COW_2 = BuiltInChromosomes.register("cow_2", 2);
        public static final Holder<Chromosome> COW_3 = BuiltInChromosomes.register("cow_3", 3);
        public static final Holder<Chromosome> COW_4 = BuiltInChromosomes.register("cow_4", 4);
        public static final Holder<Chromosome> COW_5 = BuiltInChromosomes.register("cow_5", 5);
        public static final Holder<Chromosome> COW_6 = BuiltInChromosomes.register("cow_6", 6);
        public static final Holder<Chromosome> COW_7 = BuiltInChromosomes.register("cow_7", 7);
        public static final Holder<Chromosome> COW_8 = BuiltInChromosomes.register("cow_8", 8);
        public static final Holder<Chromosome> COW_9 = BuiltInChromosomes.register("cow_9", 9);
        public static final Holder<Chromosome> COW_10 = BuiltInChromosomes.register("cow_10", 10);
        public static final Holder<Chromosome> COW_11 = BuiltInChromosomes.register("cow_11", 11);
        public static final Holder<Chromosome> COW_12 = BuiltInChromosomes.register("cow_12", 12);
        public static final Holder<Chromosome> COW_13 = BuiltInChromosomes.register("cow_13", 13);
        public static final Holder<Chromosome> COW_14 = BuiltInChromosomes.register("cow_14", 14);
        public static final Holder<Chromosome> COW_15 = BuiltInChromosomes.register("cow_15", 15);
        public static final Holder<Chromosome> COW_16 = BuiltInChromosomes.register("cow_16", 16);
        public static final Holder<Chromosome> COW_17 = BuiltInChromosomes.register("cow_17", 17);
        public static final Holder<Chromosome> COW_18 = BuiltInChromosomes.register("cow_18", 18);
        public static final Holder<Chromosome> COW_19 = BuiltInChromosomes.register("cow_19", 19);
        public static final Holder<Chromosome> COW_20 = BuiltInChromosomes.register("cow_20", 20);
        public static final Holder<Chromosome> COW_21 = BuiltInChromosomes.register("cow_21", 21);
        public static final Holder<Chromosome> COW_22 = BuiltInChromosomes.register("cow_22", 22);
        public static final Holder<Chromosome> COW_23 = BuiltInChromosomes.register("cow_23", 23);
        public static final Holder<Chromosome> COW_24 = BuiltInChromosomes.register("cow_24", 24);
        public static final Holder<Chromosome> COW_25 = BuiltInChromosomes.register("cow_25", 25);
        public static final Holder<Chromosome> COW_26 = BuiltInChromosomes.register("cow_26", 26);
        public static final Holder<Chromosome> COW_27 = BuiltInChromosomes.register("cow_27", 27);
        public static final Holder<Chromosome> COW_28 = BuiltInChromosomes.register("cow_28", 28);
        public static final Holder<Chromosome> COW_29 = BuiltInChromosomes.register("cow_29", 29);
        public static final Holder<Chromosome> COW_XY = BuiltInChromosomes.register("cow_xy", 30);

        private Cow() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_28);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_29);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20557_, COW_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(COW_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Donkey {
        public static final Holder<Chromosome> DONKEY_1 = BuiltInChromosomes.register("donkey_1", 1);
        public static final Holder<Chromosome> DONKEY_2 = BuiltInChromosomes.register("donkey_2", 2);
        public static final Holder<Chromosome> DONKEY_3 = BuiltInChromosomes.register("donkey_3", 3);
        public static final Holder<Chromosome> DONKEY_4 = BuiltInChromosomes.register("donkey_4", 4);
        public static final Holder<Chromosome> DONKEY_5 = BuiltInChromosomes.register("donkey_5", 5);
        public static final Holder<Chromosome> DONKEY_6 = BuiltInChromosomes.register("donkey_6", 6);
        public static final Holder<Chromosome> DONKEY_7 = BuiltInChromosomes.register("donkey_7", 7);
        public static final Holder<Chromosome> DONKEY_8 = BuiltInChromosomes.register("donkey_8", 8);
        public static final Holder<Chromosome> DONKEY_9 = BuiltInChromosomes.register("donkey_9", 9);
        public static final Holder<Chromosome> DONKEY_10 = BuiltInChromosomes.register("donkey_10", 10);
        public static final Holder<Chromosome> DONKEY_11 = BuiltInChromosomes.register("donkey_11", 11);
        public static final Holder<Chromosome> DONKEY_12 = BuiltInChromosomes.register("donkey_12", 12);
        public static final Holder<Chromosome> DONKEY_13 = BuiltInChromosomes.register("donkey_13", 13);
        public static final Holder<Chromosome> DONKEY_14 = BuiltInChromosomes.register("donkey_14", 14);
        public static final Holder<Chromosome> DONKEY_15 = BuiltInChromosomes.register("donkey_15", 15);
        public static final Holder<Chromosome> DONKEY_16 = BuiltInChromosomes.register("donkey_16", 16);
        public static final Holder<Chromosome> DONKEY_17 = BuiltInChromosomes.register("donkey_17", 17);
        public static final Holder<Chromosome> DONKEY_18 = BuiltInChromosomes.register("donkey_18", 18);
        public static final Holder<Chromosome> DONKEY_19 = BuiltInChromosomes.register("donkey_19", 19);
        public static final Holder<Chromosome> DONKEY_20 = BuiltInChromosomes.register("donkey_20", 20);
        public static final Holder<Chromosome> DONKEY_21 = BuiltInChromosomes.register("donkey_21", 21);
        public static final Holder<Chromosome> DONKEY_22 = BuiltInChromosomes.register("donkey_22", 22);
        public static final Holder<Chromosome> DONKEY_23 = BuiltInChromosomes.register("donkey_23", 23);
        public static final Holder<Chromosome> DONKEY_24 = BuiltInChromosomes.register("donkey_24", 24);
        public static final Holder<Chromosome> DONKEY_25 = BuiltInChromosomes.register("donkey_25", 25);
        public static final Holder<Chromosome> DONKEY_26 = BuiltInChromosomes.register("donkey_26", 26);
        public static final Holder<Chromosome> DONKEY_27 = BuiltInChromosomes.register("donkey_27", 27);
        public static final Holder<Chromosome> DONKEY_28 = BuiltInChromosomes.register("donkey_28", 28);
        public static final Holder<Chromosome> DONKEY_29 = BuiltInChromosomes.register("donkey_29", 29);
        public static final Holder<Chromosome> DONKEY_30 = BuiltInChromosomes.register("donkey_30", 30);
        public static final Holder<Chromosome> DONKEY_XY = BuiltInChromosomes.register("donkey_xy", 31);

        private Donkey() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_28);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_29);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_30);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20560_, DONKEY_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(DONKEY_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Fox {
        public static final Holder<Chromosome> FOX_1 = BuiltInChromosomes.register("fox_1", 1);
        public static final Holder<Chromosome> FOX_2 = BuiltInChromosomes.register("fox_2", 2);
        public static final Holder<Chromosome> FOX_3 = BuiltInChromosomes.register("fox_3", 3);
        public static final Holder<Chromosome> FOX_4 = BuiltInChromosomes.register("fox_4", 4);
        public static final Holder<Chromosome> FOX_5 = BuiltInChromosomes.register("fox_5", 5);
        public static final Holder<Chromosome> FOX_6 = BuiltInChromosomes.register("fox_6", 6);
        public static final Holder<Chromosome> FOX_7 = BuiltInChromosomes.register("fox_7", 7);
        public static final Holder<Chromosome> FOX_8 = BuiltInChromosomes.register("fox_8", 8);
        public static final Holder<Chromosome> FOX_9 = BuiltInChromosomes.register("fox_9", 9);
        public static final Holder<Chromosome> FOX_10 = BuiltInChromosomes.register("fox_10", 10);
        public static final Holder<Chromosome> FOX_11 = BuiltInChromosomes.register("fox_11", 11);
        public static final Holder<Chromosome> FOX_12 = BuiltInChromosomes.register("fox_12", 12);
        public static final Holder<Chromosome> FOX_13 = BuiltInChromosomes.register("fox_13", 13);
        public static final Holder<Chromosome> FOX_14 = BuiltInChromosomes.register("fox_14", 14);
        public static final Holder<Chromosome> FOX_15 = BuiltInChromosomes.register("fox_15", 15);
        public static final Holder<Chromosome> FOX_16 = BuiltInChromosomes.register("fox_16", 16);
        public static final Holder<Chromosome> FOX_XY = BuiltInChromosomes.register("fox_xy", 17);

        private Fox() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20452_, FOX_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(FOX_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Frog {
        public static final Holder<Chromosome> FROG_1 = BuiltInChromosomes.register("frog_1", 1);
        public static final Holder<Chromosome> FROG_2 = BuiltInChromosomes.register("frog_2", 2);
        public static final Holder<Chromosome> FROG_3 = BuiltInChromosomes.register("frog_3", 3);
        public static final Holder<Chromosome> FROG_4 = BuiltInChromosomes.register("frog_4", 4);
        public static final Holder<Chromosome> FROG_5 = BuiltInChromosomes.register("frog_5", 5);
        public static final Holder<Chromosome> FROG_6 = BuiltInChromosomes.register("frog_6", 6);
        public static final Holder<Chromosome> FROG_7 = BuiltInChromosomes.register("frog_7", 7);
        public static final Holder<Chromosome> FROG_8 = BuiltInChromosomes.register("frog_8", 8);
        public static final Holder<Chromosome> FROG_9 = BuiltInChromosomes.register("frog_9", 9);
        public static final Holder<Chromosome> FROG_10 = BuiltInChromosomes.register("frog_10", 10);
        public static final Holder<Chromosome> FROG_11 = BuiltInChromosomes.register("frog_11", 11);
        public static final Holder<Chromosome> FROG_12 = BuiltInChromosomes.register("frog_12", 12);
        public static final Holder<Chromosome> FROG_XY = BuiltInChromosomes.register("frog_xy", 13);

        private Frog() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_217012_, FROG_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(FROG_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Goat {
        public static final Holder<Chromosome> GOAT_1 = BuiltInChromosomes.register("goat_1", 1);
        public static final Holder<Chromosome> GOAT_2 = BuiltInChromosomes.register("goat_2", 2);
        public static final Holder<Chromosome> GOAT_3 = BuiltInChromosomes.register("goat_3", 3);
        public static final Holder<Chromosome> GOAT_4 = BuiltInChromosomes.register("goat_4", 4);
        public static final Holder<Chromosome> GOAT_5 = BuiltInChromosomes.register("goat_5", 5);
        public static final Holder<Chromosome> GOAT_6 = BuiltInChromosomes.register("goat_6", 6);
        public static final Holder<Chromosome> GOAT_7 = BuiltInChromosomes.register("goat_7", 7);
        public static final Holder<Chromosome> GOAT_8 = BuiltInChromosomes.register("goat_8", 8);
        public static final Holder<Chromosome> GOAT_9 = BuiltInChromosomes.register("goat_9", 9);
        public static final Holder<Chromosome> GOAT_10 = BuiltInChromosomes.register("goat_10", 10);
        public static final Holder<Chromosome> GOAT_11 = BuiltInChromosomes.register("goat_11", 11);
        public static final Holder<Chromosome> GOAT_12 = BuiltInChromosomes.register("goat_12", 12);
        public static final Holder<Chromosome> GOAT_13 = BuiltInChromosomes.register("goat_13", 13);
        public static final Holder<Chromosome> GOAT_14 = BuiltInChromosomes.register("goat_14", 14);
        public static final Holder<Chromosome> GOAT_15 = BuiltInChromosomes.register("goat_15", 15);
        public static final Holder<Chromosome> GOAT_16 = BuiltInChromosomes.register("goat_16", 16);
        public static final Holder<Chromosome> GOAT_17 = BuiltInChromosomes.register("goat_17", 17);
        public static final Holder<Chromosome> GOAT_18 = BuiltInChromosomes.register("goat_18", 18);
        public static final Holder<Chromosome> GOAT_19 = BuiltInChromosomes.register("goat_19", 19);
        public static final Holder<Chromosome> GOAT_20 = BuiltInChromosomes.register("goat_20", 20);
        public static final Holder<Chromosome> GOAT_21 = BuiltInChromosomes.register("goat_21", 21);
        public static final Holder<Chromosome> GOAT_22 = BuiltInChromosomes.register("goat_22", 22);
        public static final Holder<Chromosome> GOAT_23 = BuiltInChromosomes.register("goat_23", 23);
        public static final Holder<Chromosome> GOAT_24 = BuiltInChromosomes.register("goat_24", 24);
        public static final Holder<Chromosome> GOAT_25 = BuiltInChromosomes.register("goat_25", 25);
        public static final Holder<Chromosome> GOAT_26 = BuiltInChromosomes.register("goat_26", 26);
        public static final Holder<Chromosome> GOAT_27 = BuiltInChromosomes.register("goat_27", 27);
        public static final Holder<Chromosome> GOAT_28 = BuiltInChromosomes.register("goat_28", 28);
        public static final Holder<Chromosome> GOAT_29 = BuiltInChromosomes.register("goat_29", 29);
        public static final Holder<Chromosome> GOAT_XY = BuiltInChromosomes.register("goat_xy", 30);

        private Goat() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_28);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_29);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_147035_, GOAT_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(GOAT_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Horse {
        public static final Holder<Chromosome> HORSE_1 = BuiltInChromosomes.register("horse_1", 1);
        public static final Holder<Chromosome> HORSE_2 = BuiltInChromosomes.register("horse_2", 2);
        public static final Holder<Chromosome> HORSE_3 = BuiltInChromosomes.register("horse_3", 3);
        public static final Holder<Chromosome> HORSE_4 = BuiltInChromosomes.register("horse_4", 4);
        public static final Holder<Chromosome> HORSE_5 = BuiltInChromosomes.register("horse_5", 5);
        public static final Holder<Chromosome> HORSE_6 = BuiltInChromosomes.register("horse_6", 6);
        public static final Holder<Chromosome> HORSE_7 = BuiltInChromosomes.register("horse_7", 7);
        public static final Holder<Chromosome> HORSE_8 = BuiltInChromosomes.register("horse_8", 8);
        public static final Holder<Chromosome> HORSE_9 = BuiltInChromosomes.register("horse_9", 9);
        public static final Holder<Chromosome> HORSE_10 = BuiltInChromosomes.register("horse_10", 10);
        public static final Holder<Chromosome> HORSE_11 = BuiltInChromosomes.register("horse_11", 11);
        public static final Holder<Chromosome> HORSE_12 = BuiltInChromosomes.register("horse_12", 12);
        public static final Holder<Chromosome> HORSE_13 = BuiltInChromosomes.register("horse_13", 13);
        public static final Holder<Chromosome> HORSE_14 = BuiltInChromosomes.register("horse_14", 14);
        public static final Holder<Chromosome> HORSE_15 = BuiltInChromosomes.register("horse_15", 15);
        public static final Holder<Chromosome> HORSE_16 = BuiltInChromosomes.register("horse_16", 16);
        public static final Holder<Chromosome> HORSE_17 = BuiltInChromosomes.register("horse_17", 17);
        public static final Holder<Chromosome> HORSE_18 = BuiltInChromosomes.register("horse_18", 18);
        public static final Holder<Chromosome> HORSE_19 = BuiltInChromosomes.register("horse_19", 19);
        public static final Holder<Chromosome> HORSE_20 = BuiltInChromosomes.register("horse_20", 20);
        public static final Holder<Chromosome> HORSE_21 = BuiltInChromosomes.register("horse_21", 21);
        public static final Holder<Chromosome> HORSE_22 = BuiltInChromosomes.register("horse_22", 22);
        public static final Holder<Chromosome> HORSE_23 = BuiltInChromosomes.register("horse_23", 23);
        public static final Holder<Chromosome> HORSE_24 = BuiltInChromosomes.register("horse_24", 24);
        public static final Holder<Chromosome> HORSE_25 = BuiltInChromosomes.register("horse_25", 25);
        public static final Holder<Chromosome> HORSE_26 = BuiltInChromosomes.register("horse_26", 26);
        public static final Holder<Chromosome> HORSE_27 = BuiltInChromosomes.register("horse_27", 27);
        public static final Holder<Chromosome> HORSE_28 = BuiltInChromosomes.register("horse_28", 28);
        public static final Holder<Chromosome> HORSE_29 = BuiltInChromosomes.register("horse_29", 29);
        public static final Holder<Chromosome> HORSE_30 = BuiltInChromosomes.register("horse_30", 30);
        public static final Holder<Chromosome> HORSE_31 = BuiltInChromosomes.register("horse_31", 31);
        public static final Holder<Chromosome> HORSE_XY = BuiltInChromosomes.register("horse_xy", 32);

        private Horse() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_28);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_29);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_30);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_31);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20457_, HORSE_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(HORSE_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Human {
        public static final Holder<Chromosome> HUMAN_1 = BuiltInChromosomes.register("human_1", 1);
        public static final Holder<Chromosome> HUMAN_2 = BuiltInChromosomes.register("human_2", 2);
        public static final Holder<Chromosome> HUMAN_3 = BuiltInChromosomes.register("human_3", 3);
        public static final Holder<Chromosome> HUMAN_4 = BuiltInChromosomes.register("human_4", 4);
        public static final Holder<Chromosome> HUMAN_5 = BuiltInChromosomes.register("human_5", 5);
        public static final Holder<Chromosome> HUMAN_6 = BuiltInChromosomes.register("human_6", 6);
        public static final Holder<Chromosome> HUMAN_7 = BuiltInChromosomes.register("human_7", 7);
        public static final Holder<Chromosome> HUMAN_8 = BuiltInChromosomes.register("human_8", 8);
        public static final Holder<Chromosome> HUMAN_9 = BuiltInChromosomes.register("human_9", 9);
        public static final Holder<Chromosome> HUMAN_10 = BuiltInChromosomes.register("human_10", 10);
        public static final Holder<Chromosome> HUMAN_11 = BuiltInChromosomes.register("human_11", 11);
        public static final Holder<Chromosome> HUMAN_12 = BuiltInChromosomes.register("human_12", 12);
        public static final Holder<Chromosome> HUMAN_13 = BuiltInChromosomes.register("human_13", 13);
        public static final Holder<Chromosome> HUMAN_14 = BuiltInChromosomes.register("human_14", 14);
        public static final Holder<Chromosome> HUMAN_15 = BuiltInChromosomes.register("human_15", 15);
        public static final Holder<Chromosome> HUMAN_16 = BuiltInChromosomes.register("human_16", 16);
        public static final Holder<Chromosome> HUMAN_17 = BuiltInChromosomes.register("human_17", 17);
        public static final Holder<Chromosome> HUMAN_18 = BuiltInChromosomes.register("human_18", 18);
        public static final Holder<Chromosome> HUMAN_19 = BuiltInChromosomes.register("human_19", 19);
        public static final Holder<Chromosome> HUMAN_20 = BuiltInChromosomes.register("human_20", 20);
        public static final Holder<Chromosome> HUMAN_21 = BuiltInChromosomes.register("human_21", 21);
        public static final Holder<Chromosome> HUMAN_22 = BuiltInChromosomes.register("human_22", 22);
        public static final Holder<Chromosome> HUMAN_XY = BuiltInChromosomes.register("human_xy", 27);

        private Human() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_1);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_2);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_3);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_4);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_5);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_6);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_7);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_8);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_9);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_10);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_11);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_12);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_13);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_14);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_15);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_16);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_17);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_18);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_19);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_20);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_21);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_22);
            RegistryRelations.registerEntityTypeTag2Chromosome(CLEntityTypeTags.HUMANS, HUMAN_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(HUMAN_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Mule {
        private Mule() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_28);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_29);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_30);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Donkey.DONKEY_XY);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_1, 32);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_2, 33);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_3, 34);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_4, 35);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_5, 36);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_6, 37);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_7, 38);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_8, 39);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_9, 40);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_10, 41);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_11, 42);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_12, 43);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_13, 44);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_14, 45);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_15, 46);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_16, 47);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_17, 48);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_18, 49);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_19, 50);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_20, 51);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_21, 52);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_22, 53);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_23, 54);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_24, 55);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_25, 56);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_26, 57);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_27, 58);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_28, 59);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_29, 60);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_30, 61);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_31, 62);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20503_, Horse.HORSE_XY, 63);
        }
    }

    public static final class Ocelot {
        public static final Holder<Chromosome> OCELOT_1 = BuiltInChromosomes.register("ocelot_1", 1);
        public static final Holder<Chromosome> OCELOT_2 = BuiltInChromosomes.register("ocelot_2", 2);
        public static final Holder<Chromosome> OCELOT_3 = BuiltInChromosomes.register("ocelot_3", 3);
        public static final Holder<Chromosome> OCELOT_4 = BuiltInChromosomes.register("ocelot_4", 4);
        public static final Holder<Chromosome> OCELOT_5 = BuiltInChromosomes.register("ocelot_5", 5);
        public static final Holder<Chromosome> OCELOT_6 = BuiltInChromosomes.register("ocelot_6", 6);
        public static final Holder<Chromosome> OCELOT_7 = BuiltInChromosomes.register("ocelot_7", 7);
        public static final Holder<Chromosome> OCELOT_8 = BuiltInChromosomes.register("ocelot_8", 8);
        public static final Holder<Chromosome> OCELOT_9 = BuiltInChromosomes.register("ocelot_9", 9);
        public static final Holder<Chromosome> OCELOT_10 = BuiltInChromosomes.register("ocelot_10", 10);
        public static final Holder<Chromosome> OCELOT_11 = BuiltInChromosomes.register("ocelot_11", 11);
        public static final Holder<Chromosome> OCELOT_12 = BuiltInChromosomes.register("ocelot_12", 12);
        public static final Holder<Chromosome> OCELOT_13 = BuiltInChromosomes.register("ocelot_13", 13);
        public static final Holder<Chromosome> OCELOT_14 = BuiltInChromosomes.register("ocelot_14", 14);
        public static final Holder<Chromosome> OCELOT_15 = BuiltInChromosomes.register("ocelot_15", 15);
        public static final Holder<Chromosome> OCELOT_16 = BuiltInChromosomes.register("ocelot_16", 16);
        public static final Holder<Chromosome> OCELOT_17 = BuiltInChromosomes.register("ocelot_17", 17);
        public static final Holder<Chromosome> OCELOT_XY = BuiltInChromosomes.register("ocelot_xy", 18);

        private Ocelot() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20505_, OCELOT_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(OCELOT_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Panda {
        public static final Holder<Chromosome> PANDA_1 = BuiltInChromosomes.register("panda_1", 1);
        public static final Holder<Chromosome> PANDA_2 = BuiltInChromosomes.register("panda_2", 2);
        public static final Holder<Chromosome> PANDA_3 = BuiltInChromosomes.register("panda_3", 3);
        public static final Holder<Chromosome> PANDA_4 = BuiltInChromosomes.register("panda_4", 4);
        public static final Holder<Chromosome> PANDA_5 = BuiltInChromosomes.register("panda_5", 5);
        public static final Holder<Chromosome> PANDA_6 = BuiltInChromosomes.register("panda_6", 6);
        public static final Holder<Chromosome> PANDA_7 = BuiltInChromosomes.register("panda_7", 7);
        public static final Holder<Chromosome> PANDA_8 = BuiltInChromosomes.register("panda_8", 8);
        public static final Holder<Chromosome> PANDA_9 = BuiltInChromosomes.register("panda_9", 9);
        public static final Holder<Chromosome> PANDA_10 = BuiltInChromosomes.register("panda_10", 10);
        public static final Holder<Chromosome> PANDA_11 = BuiltInChromosomes.register("panda_11", 11);
        public static final Holder<Chromosome> PANDA_12 = BuiltInChromosomes.register("panda_12", 12);
        public static final Holder<Chromosome> PANDA_13 = BuiltInChromosomes.register("panda_13", 13);
        public static final Holder<Chromosome> PANDA_14 = BuiltInChromosomes.register("panda_14", 14);
        public static final Holder<Chromosome> PANDA_15 = BuiltInChromosomes.register("panda_15", 15);
        public static final Holder<Chromosome> PANDA_16 = BuiltInChromosomes.register("panda_16", 16);
        public static final Holder<Chromosome> PANDA_17 = BuiltInChromosomes.register("panda_17", 17);
        public static final Holder<Chromosome> PANDA_18 = BuiltInChromosomes.register("panda_18", 18);
        public static final Holder<Chromosome> PANDA_19 = BuiltInChromosomes.register("panda_19", 19);
        public static final Holder<Chromosome> PANDA_20 = BuiltInChromosomes.register("panda_20", 20);
        public static final Holder<Chromosome> PANDA_XY = BuiltInChromosomes.register("panda_xy", 21);

        private Panda() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20507_, PANDA_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(PANDA_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Parrot {
        public static final Holder<Chromosome> PARROT_1 = BuiltInChromosomes.register("parrot_1", 1);
        public static final Holder<Chromosome> PARROT_2 = BuiltInChromosomes.register("parrot_2", 2);
        public static final Holder<Chromosome> PARROT_3 = BuiltInChromosomes.register("parrot_3", 3);
        public static final Holder<Chromosome> PARROT_4 = BuiltInChromosomes.register("parrot_4", 4);
        public static final Holder<Chromosome> PARROT_5 = BuiltInChromosomes.register("parrot_5", 5);
        public static final Holder<Chromosome> PARROT_6 = BuiltInChromosomes.register("parrot_6", 6);
        public static final Holder<Chromosome> PARROT_7 = BuiltInChromosomes.register("parrot_7", 7);
        public static final Holder<Chromosome> PARROT_8 = BuiltInChromosomes.register("parrot_8", 8);
        public static final Holder<Chromosome> PARROT_9 = BuiltInChromosomes.register("parrot_9", 9);
        public static final Holder<Chromosome> PARROT_10 = BuiltInChromosomes.register("parrot_10", 10);
        public static final Holder<Chromosome> PARROT_11 = BuiltInChromosomes.register("parrot_11", 11);
        public static final Holder<Chromosome> PARROT_12 = BuiltInChromosomes.register("parrot_12", 12);
        public static final Holder<Chromosome> PARROT_13 = BuiltInChromosomes.register("parrot_13", 13);
        public static final Holder<Chromosome> PARROT_14 = BuiltInChromosomes.register("parrot_14", 14);
        public static final Holder<Chromosome> PARROT_15 = BuiltInChromosomes.register("parrot_15", 15);
        public static final Holder<Chromosome> PARROT_16 = BuiltInChromosomes.register("parrot_16", 16);
        public static final Holder<Chromosome> PARROT_17 = BuiltInChromosomes.register("parrot_17", 17);
        public static final Holder<Chromosome> PARROT_18 = BuiltInChromosomes.register("parrot_18", 18);
        public static final Holder<Chromosome> PARROT_19 = BuiltInChromosomes.register("parrot_19", 19);
        public static final Holder<Chromosome> PARROT_20 = BuiltInChromosomes.register("parrot_20", 20);
        public static final Holder<Chromosome> PARROT_21 = BuiltInChromosomes.register("parrot_21", 21);
        public static final Holder<Chromosome> PARROT_22 = BuiltInChromosomes.register("parrot_22", 22);
        public static final Holder<Chromosome> PARROT_23 = BuiltInChromosomes.register("parrot_23", 23);
        public static final Holder<Chromosome> PARROT_24 = BuiltInChromosomes.register("parrot_24", 24);
        public static final Holder<Chromosome> PARROT_25 = BuiltInChromosomes.register("parrot_25", 25);
        public static final Holder<Chromosome> PARROT_26 = BuiltInChromosomes.register("parrot_26", 26);
        public static final Holder<Chromosome> PARROT_27 = BuiltInChromosomes.register("parrot_27", 27);
        public static final Holder<Chromosome> PARROT_28 = BuiltInChromosomes.register("parrot_28", 28);
        public static final Holder<Chromosome> PARROT_29 = BuiltInChromosomes.register("parrot_29", 29);
        public static final Holder<Chromosome> PARROT_30 = BuiltInChromosomes.register("parrot_30", 30);
        public static final Holder<Chromosome> PARROT_ZW = BuiltInChromosomes.register("parrot_zw", 31);

        private Parrot() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_28);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_29);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_30);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20508_, PARROT_ZW);
            RegistryRelations.registerNecessaryChromosomeTypes(PARROT_ZW, ChromosomeType.LEFT);
        }
    }

    public static final class Pig {
        public static final Holder<Chromosome> PIG_1 = BuiltInChromosomes.register("pig_1", 1);
        public static final Holder<Chromosome> PIG_2 = BuiltInChromosomes.register("pig_2", 2);
        public static final Holder<Chromosome> PIG_3 = BuiltInChromosomes.register("pig_3", 3);
        public static final Holder<Chromosome> PIG_4 = BuiltInChromosomes.register("pig_4", 4);
        public static final Holder<Chromosome> PIG_5 = BuiltInChromosomes.register("pig_5", 5);
        public static final Holder<Chromosome> PIG_6 = BuiltInChromosomes.register("pig_6", 6);
        public static final Holder<Chromosome> PIG_7 = BuiltInChromosomes.register("pig_7", 7);
        public static final Holder<Chromosome> PIG_8 = BuiltInChromosomes.register("pig_8", 8);
        public static final Holder<Chromosome> PIG_9 = BuiltInChromosomes.register("pig_9", 9);
        public static final Holder<Chromosome> PIG_10 = BuiltInChromosomes.register("pig_10", 10);
        public static final Holder<Chromosome> PIG_11 = BuiltInChromosomes.register("pig_11", 11);
        public static final Holder<Chromosome> PIG_12 = BuiltInChromosomes.register("pig_12", 12);
        public static final Holder<Chromosome> PIG_13 = BuiltInChromosomes.register("pig_13", 13);
        public static final Holder<Chromosome> PIG_14 = BuiltInChromosomes.register("pig_14", 14);
        public static final Holder<Chromosome> PIG_15 = BuiltInChromosomes.register("pig_15", 15);
        public static final Holder<Chromosome> PIG_16 = BuiltInChromosomes.register("pig_16", 16);
        public static final Holder<Chromosome> PIG_17 = BuiltInChromosomes.register("pig_17", 17);
        public static final Holder<Chromosome> PIG_18 = BuiltInChromosomes.register("pig_18", 18);
        public static final Holder<Chromosome> PIG_XY = BuiltInChromosomes.register("pig_xy", 19);

        private Pig() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20510_, PIG_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(PIG_XY, ChromosomeType.LEFT);
        }
    }

    public static final class PolarBear {
        public static final Holder<Chromosome> POLAR_BEAR_1 = BuiltInChromosomes.register("polar_bear_1", 1);
        public static final Holder<Chromosome> POLAR_BEAR_2 = BuiltInChromosomes.register("polar_bear_2", 2);
        public static final Holder<Chromosome> POLAR_BEAR_3 = BuiltInChromosomes.register("polar_bear_3", 3);
        public static final Holder<Chromosome> POLAR_BEAR_4 = BuiltInChromosomes.register("polar_bear_4", 4);
        public static final Holder<Chromosome> POLAR_BEAR_5 = BuiltInChromosomes.register("polar_bear_5", 5);
        public static final Holder<Chromosome> POLAR_BEAR_6 = BuiltInChromosomes.register("polar_bear_6", 6);
        public static final Holder<Chromosome> POLAR_BEAR_7 = BuiltInChromosomes.register("polar_bear_7", 7);
        public static final Holder<Chromosome> POLAR_BEAR_8 = BuiltInChromosomes.register("polar_bear_8", 8);
        public static final Holder<Chromosome> POLAR_BEAR_9 = BuiltInChromosomes.register("polar_bear_9", 9);
        public static final Holder<Chromosome> POLAR_BEAR_10 = BuiltInChromosomes.register("polar_bear_10", 10);
        public static final Holder<Chromosome> POLAR_BEAR_11 = BuiltInChromosomes.register("polar_bear_11", 11);
        public static final Holder<Chromosome> POLAR_BEAR_12 = BuiltInChromosomes.register("polar_bear_12", 12);
        public static final Holder<Chromosome> POLAR_BEAR_13 = BuiltInChromosomes.register("polar_bear_13", 13);
        public static final Holder<Chromosome> POLAR_BEAR_14 = BuiltInChromosomes.register("polar_bear_14", 14);
        public static final Holder<Chromosome> POLAR_BEAR_15 = BuiltInChromosomes.register("polar_bear_15", 15);
        public static final Holder<Chromosome> POLAR_BEAR_16 = BuiltInChromosomes.register("polar_bear_16", 16);
        public static final Holder<Chromosome> POLAR_BEAR_17 = BuiltInChromosomes.register("polar_bear_17", 17);
        public static final Holder<Chromosome> POLAR_BEAR_18 = BuiltInChromosomes.register("polar_bear_18", 18);
        public static final Holder<Chromosome> POLAR_BEAR_19 = BuiltInChromosomes.register("polar_bear_19", 19);
        public static final Holder<Chromosome> POLAR_BEAR_20 = BuiltInChromosomes.register("polar_bear_20", 20);
        public static final Holder<Chromosome> POLAR_BEAR_21 = BuiltInChromosomes.register("polar_bear_21", 21);
        public static final Holder<Chromosome> POLAR_BEAR_22 = BuiltInChromosomes.register("polar_bear_22", 22);
        public static final Holder<Chromosome> POLAR_BEAR_23 = BuiltInChromosomes.register("polar_bear_23", 23);
        public static final Holder<Chromosome> POLAR_BEAR_24 = BuiltInChromosomes.register("polar_bear_24", 24);
        public static final Holder<Chromosome> POLAR_BEAR_25 = BuiltInChromosomes.register("polar_bear_25", 25);
        public static final Holder<Chromosome> POLAR_BEAR_26 = BuiltInChromosomes.register("polar_bear_26", 26);
        public static final Holder<Chromosome> POLAR_BEAR_27 = BuiltInChromosomes.register("polar_bear_27", 27);
        public static final Holder<Chromosome> POLAR_BEAR_28 = BuiltInChromosomes.register("polar_bear_28", 28);
        public static final Holder<Chromosome> POLAR_BEAR_29 = BuiltInChromosomes.register("polar_bear_29", 29);
        public static final Holder<Chromosome> POLAR_BEAR_30 = BuiltInChromosomes.register("polar_bear_30", 30);
        public static final Holder<Chromosome> POLAR_BEAR_31 = BuiltInChromosomes.register("polar_bear_31", 31);
        public static final Holder<Chromosome> POLAR_BEAR_32 = BuiltInChromosomes.register("polar_bear_32", 32);
        public static final Holder<Chromosome> POLAR_BEAR_33 = BuiltInChromosomes.register("polar_bear_33", 33);
        public static final Holder<Chromosome> POLAR_BEAR_34 = BuiltInChromosomes.register("polar_bear_34", 34);
        public static final Holder<Chromosome> POLAR_BEAR_35 = BuiltInChromosomes.register("polar_bear_35", 35);
        public static final Holder<Chromosome> POLAR_BEAR_36 = BuiltInChromosomes.register("polar_bear_36", 36);
        public static final Holder<Chromosome> POLAR_BEAR_XY = BuiltInChromosomes.register("polar_bear_xy", 37);

        private PolarBear() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_28);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_29);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_30);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_31);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_32);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_33);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_34);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_35);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_36);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20514_, POLAR_BEAR_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(POLAR_BEAR_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Rabbit {
        public static final Holder<Chromosome> RABBIT_1 = BuiltInChromosomes.register("rabbit_1", 1);
        public static final Holder<Chromosome> RABBIT_2 = BuiltInChromosomes.register("rabbit_2", 2);
        public static final Holder<Chromosome> RABBIT_3 = BuiltInChromosomes.register("rabbit_3", 3);
        public static final Holder<Chromosome> RABBIT_4 = BuiltInChromosomes.register("rabbit_4", 4);
        public static final Holder<Chromosome> RABBIT_5 = BuiltInChromosomes.register("rabbit_5", 5);
        public static final Holder<Chromosome> RABBIT_6 = BuiltInChromosomes.register("rabbit_6", 6);
        public static final Holder<Chromosome> RABBIT_7 = BuiltInChromosomes.register("rabbit_7", 7);
        public static final Holder<Chromosome> RABBIT_8 = BuiltInChromosomes.register("rabbit_8", 8);
        public static final Holder<Chromosome> RABBIT_9 = BuiltInChromosomes.register("rabbit_9", 9);
        public static final Holder<Chromosome> RABBIT_10 = BuiltInChromosomes.register("rabbit_10", 10);
        public static final Holder<Chromosome> RABBIT_11 = BuiltInChromosomes.register("rabbit_11", 11);
        public static final Holder<Chromosome> RABBIT_12 = BuiltInChromosomes.register("rabbit_12", 12);
        public static final Holder<Chromosome> RABBIT_13 = BuiltInChromosomes.register("rabbit_13", 13);
        public static final Holder<Chromosome> RABBIT_14 = BuiltInChromosomes.register("rabbit_14", 14);
        public static final Holder<Chromosome> RABBIT_15 = BuiltInChromosomes.register("rabbit_15", 15);
        public static final Holder<Chromosome> RABBIT_16 = BuiltInChromosomes.register("rabbit_16", 16);
        public static final Holder<Chromosome> RABBIT_17 = BuiltInChromosomes.register("rabbit_17", 17);
        public static final Holder<Chromosome> RABBIT_18 = BuiltInChromosomes.register("rabbit_18", 18);
        public static final Holder<Chromosome> RABBIT_19 = BuiltInChromosomes.register("rabbit_19", 19);
        public static final Holder<Chromosome> RABBIT_20 = BuiltInChromosomes.register("rabbit_20", 20);
        public static final Holder<Chromosome> RABBIT_21 = BuiltInChromosomes.register("rabbit_21", 21);
        public static final Holder<Chromosome> RABBIT_22 = BuiltInChromosomes.register("rabbit_22", 22);
        public static final Holder<Chromosome> RABBIT_23 = BuiltInChromosomes.register("rabbit_23", 23);
        public static final Holder<Chromosome> RABBIT_XY = BuiltInChromosomes.register("rabbit_xy", 24);

        private Rabbit() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20517_, RABBIT_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(RABBIT_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Sheep {
        public static final Holder<Chromosome> SHEEP_1 = BuiltInChromosomes.register("sheep_1", 1);
        public static final Holder<Chromosome> SHEEP_2 = BuiltInChromosomes.register("sheep_2", 2);
        public static final Holder<Chromosome> SHEEP_3 = BuiltInChromosomes.register("sheep_3", 3);
        public static final Holder<Chromosome> SHEEP_4 = BuiltInChromosomes.register("sheep_4", 4);
        public static final Holder<Chromosome> SHEEP_5 = BuiltInChromosomes.register("sheep_5", 5);
        public static final Holder<Chromosome> SHEEP_6 = BuiltInChromosomes.register("sheep_6", 6);
        public static final Holder<Chromosome> SHEEP_7 = BuiltInChromosomes.register("sheep_7", 7);
        public static final Holder<Chromosome> SHEEP_8 = BuiltInChromosomes.register("sheep_8", 8);
        public static final Holder<Chromosome> SHEEP_9 = BuiltInChromosomes.register("sheep_9", 9);
        public static final Holder<Chromosome> SHEEP_10 = BuiltInChromosomes.register("sheep_10", 10);
        public static final Holder<Chromosome> SHEEP_11 = BuiltInChromosomes.register("sheep_11", 11);
        public static final Holder<Chromosome> SHEEP_12 = BuiltInChromosomes.register("sheep_12", 12);
        public static final Holder<Chromosome> SHEEP_13 = BuiltInChromosomes.register("sheep_13", 13);
        public static final Holder<Chromosome> SHEEP_14 = BuiltInChromosomes.register("sheep_14", 14);
        public static final Holder<Chromosome> SHEEP_15 = BuiltInChromosomes.register("sheep_15", 15);
        public static final Holder<Chromosome> SHEEP_16 = BuiltInChromosomes.register("sheep_16", 16);
        public static final Holder<Chromosome> SHEEP_17 = BuiltInChromosomes.register("sheep_17", 17);
        public static final Holder<Chromosome> SHEEP_18 = BuiltInChromosomes.register("sheep_18", 18);
        public static final Holder<Chromosome> SHEEP_19 = BuiltInChromosomes.register("sheep_19", 19);
        public static final Holder<Chromosome> SHEEP_20 = BuiltInChromosomes.register("sheep_20", 20);
        public static final Holder<Chromosome> SHEEP_21 = BuiltInChromosomes.register("sheep_21", 21);
        public static final Holder<Chromosome> SHEEP_22 = BuiltInChromosomes.register("sheep_22", 22);
        public static final Holder<Chromosome> SHEEP_23 = BuiltInChromosomes.register("sheep_23", 23);
        public static final Holder<Chromosome> SHEEP_24 = BuiltInChromosomes.register("sheep_24", 24);
        public static final Holder<Chromosome> SHEEP_25 = BuiltInChromosomes.register("sheep_25", 25);
        public static final Holder<Chromosome> SHEEP_26 = BuiltInChromosomes.register("sheep_26", 26);
        public static final Holder<Chromosome> SHEEP_XY = BuiltInChromosomes.register("sheep_xy", 27);

        private Sheep() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20520_, SHEEP_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(SHEEP_XY, ChromosomeType.LEFT);
        }
    }

    public static final class Turtle {
        public static final Holder<Chromosome> TURTLE_1 = BuiltInChromosomes.register("turtle_1", 1);
        public static final Holder<Chromosome> TURTLE_2 = BuiltInChromosomes.register("turtle_2", 2);
        public static final Holder<Chromosome> TURTLE_3 = BuiltInChromosomes.register("turtle_3", 3);
        public static final Holder<Chromosome> TURTLE_4 = BuiltInChromosomes.register("turtle_4", 4);
        public static final Holder<Chromosome> TURTLE_5 = BuiltInChromosomes.register("turtle_5", 5);
        public static final Holder<Chromosome> TURTLE_6 = BuiltInChromosomes.register("turtle_6", 6);
        public static final Holder<Chromosome> TURTLE_7 = BuiltInChromosomes.register("turtle_7", 7);
        public static final Holder<Chromosome> TURTLE_8 = BuiltInChromosomes.register("turtle_8", 8);
        public static final Holder<Chromosome> TURTLE_9 = BuiltInChromosomes.register("turtle_9", 9);
        public static final Holder<Chromosome> TURTLE_10 = BuiltInChromosomes.register("turtle_10", 10);
        public static final Holder<Chromosome> TURTLE_11 = BuiltInChromosomes.register("turtle_11", 11);
        public static final Holder<Chromosome> TURTLE_12 = BuiltInChromosomes.register("turtle_12", 12);
        public static final Holder<Chromosome> TURTLE_13 = BuiltInChromosomes.register("turtle_13", 13);
        public static final Holder<Chromosome> TURTLE_14 = BuiltInChromosomes.register("turtle_14", 14);
        public static final Holder<Chromosome> TURTLE_15 = BuiltInChromosomes.register("turtle_15", 15);
        public static final Holder<Chromosome> TURTLE_16 = BuiltInChromosomes.register("turtle_16", 16);
        public static final Holder<Chromosome> TURTLE_17 = BuiltInChromosomes.register("turtle_17", 17);
        public static final Holder<Chromosome> TURTLE_18 = BuiltInChromosomes.register("turtle_18", 18);
        public static final Holder<Chromosome> TURTLE_19 = BuiltInChromosomes.register("turtle_19", 19);
        public static final Holder<Chromosome> TURTLE_20 = BuiltInChromosomes.register("turtle_20", 20);
        public static final Holder<Chromosome> TURTLE_21 = BuiltInChromosomes.register("turtle_21", 21);
        public static final Holder<Chromosome> TURTLE_22 = BuiltInChromosomes.register("turtle_22", 22);
        public static final Holder<Chromosome> TURTLE_23 = BuiltInChromosomes.register("turtle_23", 23);
        public static final Holder<Chromosome> TURTLE_24 = BuiltInChromosomes.register("turtle_24", 24);
        public static final Holder<Chromosome> TURTLE_25 = BuiltInChromosomes.register("turtle_25", 25);
        public static final Holder<Chromosome> TURTLE_26 = BuiltInChromosomes.register("turtle_26", 26);
        public static final Holder<Chromosome> TURTLE_27 = BuiltInChromosomes.register("turtle_27", 27);
        public static final Holder<Chromosome> TURTLE_XY = BuiltInChromosomes.register("turtle_xy", 28);

        private Turtle() {
        }

        public static void init() {
        }

        public static void registerRelations() {
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_1);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_2);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_3);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_4);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_5);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_6);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_7);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_8);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_9);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_10);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_11);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_12);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_13);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_14);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_15);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_16);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_17);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_18);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_19);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_20);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_21);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_22);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_23);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_24);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_25);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_26);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_27);
            RegistryRelations.registerEntityType2Chromosome(EntityType.f_20490_, TURTLE_XY);
            RegistryRelations.registerNecessaryChromosomeTypes(TURTLE_XY, ChromosomeType.LEFT);
        }
    }
}

