/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.command;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.entity.IChromosomeCarrier;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocusInstance;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.CLRegistries;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ChromosomeLibCommand {
    private static final String ENTITY_ARGUMENT = "entity";
    private static final String CHROMOSOME_INDEX_ARGUMENT = "chromosome_index";
    private static final String GENE_LOCUS_INDEX_ARGUMENT = "gene_locus_index";
    private static final String GENE_1_ARGUMENT = "gene_1";
    private static final String GENE_2_ARGUMENT = "gene_2";
    private static final Registry<Chromosome> chromosomeRegistry = Objects.requireNonNull((Registry)BuiltInRegistries.f_257047_.m_7745_(CLRegistries.CHROMOSOMES.m_135782_()));
    private static final Registry<Gene> geneRegistry = Objects.requireNonNull((Registry)BuiltInRegistries.f_257047_.m_7745_(CLRegistries.GENES.m_135782_()));
    private static final SuggestionProvider<CommandSourceStack> GENE_SUGGESTIONS = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("chromosomelib", "genes"), (context, builder) -> SharedSuggestionProvider.m_82957_(geneRegistry.m_203611_().flatMap(holder -> holder.m_203543_().stream().map(ResourceKey::m_135782_)), (SuggestionsBuilder)builder));
    public static final Dynamic2CommandExceptionType GENE_LOCUS_INDEX_MISMATCHED = new Dynamic2CommandExceptionType((expected, found) -> Component.m_237113_((String)"Gene Locus index mismatched. Expected %d, found %d.".formatted((int)((Integer)expected), (Integer)found)));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chromosomelib").requires(stack -> stack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"show").executes(ctx -> ChromosomeLibCommand.show(((CommandSourceStack)ctx.getSource()).m_230896_(), ((CommandSourceStack)ctx.getSource()).m_81373_()))).then(Commands.m_82129_((String)ENTITY_ARGUMENT, (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> ChromosomeLibCommand.show(((CommandSourceStack)ctx.getSource()).m_230896_(), EntityArgument.m_91452_((CommandContext)ctx, (String)ENTITY_ARGUMENT)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reassign").executes(ctx -> ChromosomeLibCommand.reassign(((CommandSourceStack)ctx.getSource()).m_81373_()))).then(Commands.m_82129_((String)ENTITY_ARGUMENT, (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> ChromosomeLibCommand.reassign(EntityArgument.m_91452_((CommandContext)ctx, (String)ENTITY_ARGUMENT)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)ENTITY_ARGUMENT, (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)CHROMOSOME_INDEX_ARGUMENT, (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)GENE_LOCUS_INDEX_ARGUMENT, (ArgumentType)IntegerArgumentType.integer((int)0)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)GENE_1_ARGUMENT, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(GENE_SUGGESTIONS).executes(ctx -> ChromosomeLibCommand.set(EntityArgument.m_91452_((CommandContext)ctx, (String)ENTITY_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CHROMOSOME_INDEX_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)GENE_LOCUS_INDEX_ARGUMENT), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)GENE_1_ARGUMENT), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)GENE_1_ARGUMENT)))).then(Commands.m_82129_((String)GENE_2_ARGUMENT, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(GENE_SUGGESTIONS).executes(ctx -> ChromosomeLibCommand.set(EntityArgument.m_91452_((CommandContext)ctx, (String)ENTITY_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CHROMOSOME_INDEX_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)GENE_LOCUS_INDEX_ARGUMENT), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)GENE_1_ARGUMENT), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)GENE_2_ARGUMENT)))))))));
    }

    private static String chromosome2Loc(Holder<Chromosome> holder) {
        return (String)holder.m_203439_().map(key -> key.m_135782_().toString(), value -> {
            ResourceLocation key = chromosomeRegistry.m_7981_(value);
            if (key == null) {
                return "";
            }
            return key.toString();
        });
    }

    private static String gene2Loc(Holder<Gene> holder) {
        return (String)holder.m_203439_().map(key -> key.m_135782_().toString(), value -> {
            ResourceLocation key = geneRegistry.m_7981_(value);
            if (key == null) {
                return "";
            }
            return key.toString();
        });
    }

    private static int show(@Nullable ServerPlayer player, @Nullable Entity entity) {
        Map toShow = AbstractRegisterEntry.newHolderTreeMap();
        if (player != null && entity instanceof IChromosomeCarrier) {
            IChromosomeCarrier carrier = (IChromosomeCarrier)entity;
            ToIntFunction<Holder<Gene>> activeGenes = carrier.chromosomelib$getActiveGenes();
            carrier.chromosomelib$getChromosomes().forEach(chromosomeInstance -> {
                Object2IntMap chromosomeGenes = toShow.computeIfAbsent(chromosomeInstance.chromosome(), ignored -> AbstractRegisterEntry.newHolderObject2IntTreeMap());
                chromosomeInstance.geneLocusInstances().forEach((index, geneLocusInstance) -> chromosomeGenes.put(geneLocusInstance.gene(), activeGenes.applyAsInt(geneLocusInstance.gene())));
            });
            StringBuilder builder = new StringBuilder();
            toShow.keySet().stream().sorted(Comparator.comparing(ChromosomeLibCommand::chromosome2Loc)).forEach(chromosome -> {
                Object2IntMap chromosomeGenes = (Object2IntMap)toShow.get(chromosome);
                if (!chromosomeGenes.isEmpty()) {
                    builder.append(ChromosomeLibCommand.chromosome2Loc((Holder<Chromosome>)chromosome)).append(":\n");
                    chromosomeGenes.keySet().forEach(gene -> builder.append("  - ").append(ChromosomeLibCommand.gene2Loc((Holder<Gene>)gene)).append(": ").append(activeGenes.applyAsInt((Holder<Gene>)gene)).append('\n'));
                }
            });
            player.m_213846_((Component)Component.m_237113_((String)builder.toString()));
        }
        return 1;
    }

    private static int reassign(@Nullable Entity entity) {
        if (entity instanceof IChromosomeCarrier) {
            IChromosomeCarrier carrier = (IChromosomeCarrier)entity;
            carrier.chromosomelib$resetTraits();
            carrier.chromosomelib$assignTraits();
        }
        return 1;
    }

    private static int set(@Nullable Entity entity, int chromosomeIndex, int geneLocusIndex, ResourceLocation geneId1, ResourceLocation geneId2) throws CommandSyntaxException {
        Holder.Reference gene1 = geneRegistry.m_246971_(ResourceKey.m_135785_(CLRegistries.GENES, (ResourceLocation)geneId1));
        Holder.Reference gene2 = geneRegistry.m_246971_(ResourceKey.m_135785_(CLRegistries.GENES, (ResourceLocation)geneId2));
        if (entity instanceof IChromosomeCarrier) {
            IChromosomeCarrier carrier = (IChromosomeCarrier)entity;
            AtomicInteger cnt = new AtomicInteger(0);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ChromosomeInstance chromosomeInstance : carrier.chromosomelib$getChromosomes()) {
                int index = Chromosome.index(chromosomeInstance.chromosome(), entity.m_6095_());
                if (index == chromosomeIndex) {
                    Set geneLocusInstances = Sets.newIdentityHashSet();
                    Int2ObjectMap<GeneLocusInstance> original = chromosomeInstance.geneLocusInstances();
                    IntIterator intIterator = original.keySet().iterator();
                    while (intIterator.hasNext()) {
                        int locusIndex = (Integer)intIterator.next();
                        if (locusIndex == geneLocusIndex) {
                            int currentCnt = cnt.get();
                            if ((currentCnt & 1) == 0) {
                                ChromosomeLibCommand.checkGeneLocusIndex((Holder<Gene>)gene1, chromosomeInstance.type(), geneLocusIndex);
                                geneLocusInstances.add(new GeneLocusInstance((Holder<Gene>)gene1));
                            } else {
                                ChromosomeLibCommand.checkGeneLocusIndex((Holder<Gene>)gene2, chromosomeInstance.type(), geneLocusIndex);
                                geneLocusInstances.add(new GeneLocusInstance((Holder<Gene>)gene2));
                            }
                            cnt.set(currentCnt + 1);
                            continue;
                        }
                        geneLocusInstances.add((GeneLocusInstance)original.get(locusIndex));
                    }
                    builder.add((Object)ChromosomeInstance.of(chromosomeInstance.chromosome(), chromosomeInstance.type(), geneLocusInstances));
                    continue;
                }
                builder.add((Object)chromosomeInstance);
            }
            carrier.chromosomelib$setChromosomes((Collection<ChromosomeInstance>)builder.build());
        }
        return 1;
    }

    private static void checkGeneLocusIndex(Holder<Gene> gene, ChromosomeType type, int index) throws CommandSyntaxException {
        int found = ((GeneLocus)Objects.requireNonNull(((Gene)gene.m_203334_()).geneLocus).m_203334_()).index(type);
        if (found != index) {
            throw GENE_LOCUS_INDEX_MISMATCHED.create((Object)index, (Object)found);
        }
    }

    private ChromosomeLibCommand() {
    }
}

