/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.gene;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import org.jetbrains.annotations.ApiStatus;

public class Gene {
    private static ImmutableGraph<Holder<Gene>> disableRelationship = GraphBuilder.directed().immutable().build();
    public static final Comparator<Holder<Gene>> COMPARATOR = Comparator.comparingInt(holder -> ((Gene)holder.m_203334_()).topologicalOrder).thenComparing(holder -> ((Gene)holder.m_203334_()).code());
    @Nullable
    @ApiStatus.Internal
    public Holder<GeneLocus> geneLocus = null;
    @ApiStatus.Internal
    public int topologicalOrder = -1;
    private final String code;

    public Gene(String code) {
        this.code = code;
    }

    public String code() {
        return this.code;
    }

    @Deprecated
    public static boolean isConnected(Holder<Gene> gene1, Holder<Gene> gene2) {
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(gene1);
        while (!queue.isEmpty()) {
            Holder gene = (Holder)queue.poll();
            for (Holder neighbor : disableRelationship.successors((Object)gene)) {
                if (neighbor == gene2) {
                    return true;
                }
                queue.add(neighbor);
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public static void doDisable(Object2IntMap<Holder<Gene>> map) {
        ArrayDeque queue = Queues.newArrayDeque();
        queue.addAll(map.keySet());
        Set visited = Sets.newIdentityHashSet();
        while (!queue.isEmpty()) {
            Holder gene = (Holder)queue.poll();
            for (Holder neighbor : disableRelationship.successors((Object)gene)) {
                if (visited.contains(neighbor)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
                map.removeInt((Object)neighbor);
            }
        }
    }

    @ApiStatus.Internal
    public static void setDisableRelationship(ImmutableGraph<Holder<Gene>> disableRelationship) {
        Gene.disableRelationship = disableRelationship;
    }
}

