/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.gene_locus;

import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.CLRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.util.RandomSource;

public record GeneLocusInstance(Holder<Gene> gene) {
    public static final Codec<GeneLocusInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryFixedCodec.m_206740_(CLRegistries.GENES).fieldOf("gene").forGetter(GeneLocusInstance::gene)).apply((Applicative)instance, GeneLocusInstance::new));
    public static final Codec<List<GeneLocusInstance>> LIST_CODEC = CODEC.listOf();

    public Holder<GeneLocus> geneLocus() {
        return Objects.requireNonNull(((Gene)this.gene.m_203334_()).geneLocus);
    }

    public int index(ChromosomeType type) {
        return ((GeneLocus)this.geneLocus().m_203334_()).index(type);
    }

    public void express(Object2IntMap<Holder<Gene>> set) {
        Object object;
        Holder<Gene> holder = this.gene;
        if (holder instanceof AbstractRegisterEntry) {
            AbstractRegisterEntry registerEntry = (AbstractRegisterEntry)holder;
            object = registerEntry.asHolder();
        } else {
            object = this.gene;
        }
        Holder<Gene> gene = object;
        set.computeInt(gene, (ignored, value) -> value == null ? 1 : value + 1);
    }

    public GeneLocusInstance copy() {
        return new GeneLocusInstance(this.gene);
    }

    public GeneLocusInstance mutate(RandomSource random) {
        List<Holder> toMutate = Objects.requireNonNull(((GeneLocus)this.geneLocus().m_203334_()).genes).m_203614_().filter(gene -> gene != this.gene).toList();
        return new GeneLocusInstance((Holder<Gene>)toMutate.get(random.m_188503_(toMutate.size())));
    }
}

