/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocusInstance;
import com.hexagram2021.chromosomelib.common.util.exception.UnpairedChromosomeException;
import com.hexagram2021.chromosomelib.platform.Services;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;

public final class Breeders {
    public static void crossOver(Collection<ChromosomeInstance> chromosomes, RandomSource random) {
        IdentityHashMap temporary = Maps.newIdentityHashMap();
        chromosomes.forEach(chromosomeInstance -> {
            Holder<Chromosome> chromosome = chromosomeInstance.chromosome();
            ChromosomeInstance oldInstance = temporary.put(chromosome, chromosomeInstance);
            boolean swap = false;
            if (oldInstance != null) {
                int offset = ((Chromosome)chromosome.m_203334_()).homoSegmentStartDiff() * (chromosomeInstance.type().ordinal() - oldInstance.type().ordinal());
                for (Int2ObjectMap.Entry entry : chromosomeInstance.geneLocusInstances().int2ObjectEntrySet()) {
                    GeneLocusInstance current = (GeneLocusInstance)entry.getValue();
                    int otherIndex = entry.getIntKey() + offset;
                    GeneLocusInstance other = (GeneLocusInstance)oldInstance.geneLocusInstances().get(otherIndex);
                    Holder<GeneLocus> geneLocus = current.geneLocus();
                    if (other != null && other.geneLocus() == geneLocus) {
                        if (random.m_188500_() <= ((GeneLocus)geneLocus.m_203334_()).possibilityOfCrossingOver) {
                            boolean bl = swap = !swap;
                        }
                        if (!swap) continue;
                        entry.setValue((Object)other);
                        oldInstance.geneLocusInstances().put(otherIndex, (Object)current);
                        continue;
                    }
                    swap = false;
                }
            }
        });
    }

    public static void mutate(Collection<ChromosomeInstance> chromosomes, RandomSource random) {
        chromosomes.forEach(chromosomeInstance -> {
            for (Int2ObjectMap.Entry entry : chromosomeInstance.geneLocusInstances().int2ObjectEntrySet()) {
                GeneLocusInstance geneLocusInstance = (GeneLocusInstance)entry.getValue();
                if (!(random.m_188500_() <= ((GeneLocus)geneLocusInstance.geneLocus().m_203334_()).possibilityOfMutation)) continue;
                entry.setValue((Object)geneLocusInstance.mutate(random));
            }
        });
    }

    public static Collection<ChromosomeInstance> breed(EntityType<?> parentAType, EntityType<?> parentBType, Collection<ChromosomeInstance> parentA, Collection<ChromosomeInstance> parentB, RandomSource random) {
        int i;
        ObjectArrayList shuffled;
        Collection chromosomeInstances;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Holder failed = null;
        ListMultimap temporary = Multimaps.newListMultimap(AbstractRegisterEntry.newHolderTreeMap(), Lists::newArrayList);
        parentA.forEach(arg_0 -> Breeders.lambda$breed$2((Multimap)temporary, arg_0));
        for (Holder chromosome : temporary.keySet()) {
            chromosomeInstances = temporary.get((Object)chromosome);
            if (chromosomeInstances.size() % 2 == 1) {
                failed = chromosome;
                break;
            }
            shuffled = new ObjectArrayList(chromosomeInstances);
            Util.m_214673_((ObjectArrayList)shuffled, (RandomSource)random);
            for (i = 0; i < shuffled.size(); i += 2) {
                builder.add((Object)((ChromosomeInstance)shuffled.get(i)).copy());
            }
        }
        if (failed != null) {
            if (!Services.PLATFORM.solveUnpairedChromosomesToBreed(parentAType, parentA, random, (ImmutableCollection.Builder<ChromosomeInstance>)builder)) {
                throw new UnpairedChromosomeException(parentAType, "breed", (Holder<Chromosome>)failed, temporary.get((Object)failed));
            }
            failed = null;
        }
        temporary.clear();
        parentB.forEach(arg_0 -> Breeders.lambda$breed$3((Multimap)temporary, arg_0));
        for (Holder chromosome : temporary.keySet()) {
            chromosomeInstances = temporary.get((Object)chromosome);
            if (chromosomeInstances.size() % 2 == 1) {
                failed = chromosome;
                break;
            }
            shuffled = new ObjectArrayList(chromosomeInstances);
            Util.m_214673_((ObjectArrayList)shuffled, (RandomSource)random);
            for (i = 0; i < shuffled.size(); i += 2) {
                builder.add((Object)((ChromosomeInstance)shuffled.get(i)).copy());
            }
        }
        if (failed != null && !Services.PLATFORM.solveUnpairedChromosomesToBreed(parentBType, parentB, random, (ImmutableCollection.Builder<ChromosomeInstance>)builder)) {
            throw new UnpairedChromosomeException(parentBType, "breed", (Holder<Chromosome>)failed, temporary.get((Object)failed));
        }
        return builder.build();
    }

    private Breeders() {
    }

    private static /* synthetic */ void lambda$breed$3(Multimap temporary, ChromosomeInstance chromosomeInstance) {
        temporary.put(chromosomeInstance.chromosome(), (Object)chromosomeInstance);
    }

    private static /* synthetic */ void lambda$breed$2(Multimap temporary, ChromosomeInstance chromosomeInstance) {
        temporary.put(chromosomeInstance.chromosome(), (Object)chromosomeInstance);
    }
}

