/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.mixin;

import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.entity.IChromosomeCarrier;
import com.hexagram2021.chromosomelib.common.entity.type.IChromosomeLibEntityType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.trait.Trait;
import com.hexagram2021.chromosomelib.common.trait.TraitHandler;
import com.hexagram2021.chromosomelib.common.trait.TraitType;
import com.hexagram2021.chromosomelib.common.util.Mappers;
import com.hexagram2021.chromosomelib.platform.Services;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.compress.utils.Lists;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements IChromosomeCarrier {
    @Unique
    private List<ChromosomeInstance> chromosomelib$chromosomes;
    @Unique
    private Object2IntMap<Holder<Gene>> chromosomelib$activeGenes;
    @Unique
    private Map<Holder<TraitType>, Holder<Trait>> chromosomelib$activeTraits;
    @Unique
    private boolean chromosomelib$isTraitsSolved;

    @Shadow
    public abstract RandomSource getRandom();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void chromosomelib$initChromosomes(CallbackInfo ci) {
        this.chromosomelib$chromosomes = Lists.newArrayList();
        this.chromosomelib$activeGenes = AbstractRegisterEntry.newHolderObject2IntTreeMap();
        this.chromosomelib$activeTraits = AbstractRegisterEntry.newHolderTreeMap();
        this.chromosomelib$isTraitsSolved = false;
        this.chromosomelib$setChromosomes(this.chromosomelib$buildDefaultChromosomes((IChromosomeLibEntityType)((LivingEntity)this).m_6095_(), IWeightedGeneList.Context.of(this.getRandom())));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void chromosomelib$saveChromosomes(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128379_("ChromosomeLibIsTraitsSolved", this.chromosomelib$isTraitsSolved);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void chromosomelib$loadChromosomes(CompoundTag nbt, CallbackInfo ci) {
        this.chromosomelib$isTraitsSolved = nbt.m_128471_("ChromosomeLibIsTraitsSolved");
    }

    @Override
    public List<ChromosomeInstance> chromosomelib$getChromosomes() {
        return this.chromosomelib$chromosomes;
    }

    @Override
    public void chromosomelib$setChromosomes(Collection<ChromosomeInstance> chromosomes) {
        this.chromosomelib$chromosomes.clear();
        this.chromosomelib$chromosomes.addAll(chromosomes);
        this.chromosomelib$activeGenes.clear();
        this.chromosomelib$activeGenes.putAll(Mappers.convertChromosomeInstancesToExpressingGenes(this.chromosomelib$chromosomes));
        Gene.doDisable(this.chromosomelib$activeGenes);
        this.chromosomelib$assignTraits();
    }

    @Override
    public ToIntFunction<Holder<Gene>> chromosomelib$getActiveGenes() {
        return this.chromosomelib$activeGenes;
    }

    @Override
    public Collection<Holder<Trait>> chromosomelib$getActiveTraits() {
        return this.chromosomelib$activeTraits.values();
    }

    @Override
    public void chromosomelib$assignTraits() {
        LivingEntity current = (LivingEntity)this;
        this.chromosomelib$activeTraits.clear();
        ((IChromosomeLibEntityType)current.m_6095_()).chromosomelib$getTraitTypes().forEach(traitType -> this.chromosomelib$activeTraits.put((Holder<TraitType>)traitType, TraitHandler.getHandler((Holder<TraitType>)traitType).handle((ToIntFunction<Holder<Gene>>)this.chromosomelib$activeGenes)));
        if (!current.m_9236_().f_46443_ && !this.chromosomelib$isTraitsSolved) {
            Services.PLATFORM.solveAfterAssigningTrait(current, this.chromosomelib$activeTraits, this.chromosomelib$activeTraits.values()::contains);
            this.chromosomelib$isTraitsSolved = true;
        }
    }

    @Override
    public void chromosomelib$resetTraits() {
        this.chromosomelib$isTraitsSolved = false;
    }

    @Override
    public boolean chromosomelib$isTraitsSolved() {
        return this.chromosomelib$isTraitsSolved;
    }
}

