/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.registry;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public abstract class AbstractRegisterEntry<T>
implements Holder<T>,
Supplier<T> {
    protected final ResourceKey<T> key;
    private static Comparator<ResourceKey<?>> resourceKeyComparator = (a, b) -> {
        int regDiff = a.m_211136_().compareTo(b.m_211136_());
        if (regDiff == 0) {
            return a.m_135782_().compareTo(b.m_135782_());
        }
        return regDiff;
    };

    protected AbstractRegisterEntry(ResourceKey<T> key) {
        this.key = key;
    }

    public boolean m_203373_(ResourceLocation id) {
        return id.equals((Object)this.key.m_135782_());
    }

    public boolean m_203565_(ResourceKey<T> key) {
        return this.key.equals(key);
    }

    public boolean m_203425_(Predicate<ResourceKey<T>> filter) {
        return filter.test(this.key);
    }

    public abstract boolean m_203656_(TagKey<T> var1);

    public abstract Stream<TagKey<T>> m_203616_();

    public abstract boolean m_203633_();

    public Either<ResourceKey<T>, T> m_203439_() {
        return Either.left(this.key);
    }

    public Optional<ResourceKey<T>> m_203543_() {
        return Optional.of(this.key);
    }

    public Holder.Kind m_203376_() {
        return Holder.Kind.REFERENCE;
    }

    public abstract boolean m_203401_(HolderOwner<T> var1);

    public abstract T m_203334_();

    @Override
    public T get() {
        return this.m_203334_();
    }

    public boolean equals(Object obj) {
        Holder h;
        if (this == obj) {
            return true;
        }
        if (obj instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)obj;
            return reference.m_205785_() == this.key;
        }
        return obj instanceof Holder && this.key.equals((h = (Holder)obj).m_203543_().orElse(null));
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "RegisterEntry{" + String.valueOf(this.key) + "}";
    }

    public abstract Holder<T> asHolder();

    public Optional<T> asOptional() {
        return this.m_203633_() ? Optional.of(this.m_203334_()) : Optional.empty();
    }

    public ResourceLocation id() {
        return this.key.m_135782_();
    }

    public ResourceKey<T> key() {
        return this.key;
    }

    public static boolean equals(Holder<?> a, Holder<?> b) {
        if (a == b) {
            return true;
        }
        if (a instanceof AbstractRegisterEntry) {
            AbstractRegisterEntry registerEntryA = (AbstractRegisterEntry)a;
            if (b instanceof AbstractRegisterEntry) {
                AbstractRegisterEntry registerEntryB = (AbstractRegisterEntry)b;
                return registerEntryA.key() == registerEntryB.key();
            }
            return registerEntryA.asHolder() == b;
        }
        if (b instanceof AbstractRegisterEntry) {
            AbstractRegisterEntry registerEntryB = (AbstractRegisterEntry)b;
            return registerEntryB.asHolder() == a;
        }
        return false;
    }

    public static int hashCode(Holder<?> holder) {
        if (holder instanceof AbstractRegisterEntry) {
            AbstractRegisterEntry registerEntry = (AbstractRegisterEntry)holder;
            return registerEntry.key().hashCode();
        }
        return holder.hashCode();
    }

    public static <T> int compare(Holder<T> a, Holder<T> b) {
        if (a instanceof AbstractRegisterEntry) {
            AbstractRegisterEntry registerEntryA = (AbstractRegisterEntry)a;
            if (b instanceof AbstractRegisterEntry) {
                AbstractRegisterEntry registerEntryB = (AbstractRegisterEntry)b;
                return resourceKeyComparator.compare(registerEntryA.key(), registerEntryB.key());
            }
            if (b instanceof Holder.Reference) {
                Holder.Reference referenceB = (Holder.Reference)b;
                return resourceKeyComparator.compare(registerEntryA.key(), referenceB.m_205785_());
            }
            return 1;
        }
        if (a instanceof Holder.Reference) {
            Holder.Reference referenceA = (Holder.Reference)a;
            if (b instanceof AbstractRegisterEntry) {
                AbstractRegisterEntry registerEntryB = (AbstractRegisterEntry)b;
                return resourceKeyComparator.compare(referenceA.m_205785_(), registerEntryB.key());
            }
            if (b instanceof Holder.Reference) {
                Holder.Reference referenceB = (Holder.Reference)b;
                return resourceKeyComparator.compare(referenceA.m_205785_(), referenceB.m_205785_());
            }
            return 1;
        }
        if (b instanceof AbstractRegisterEntry || b instanceof Holder.Reference) {
            return -1;
        }
        return Integer.compare(a.hashCode(), b.hashCode());
    }

    public static <T, V> Map<Holder<T>, V> newHolderTreeMap() {
        return new TreeMap(AbstractRegisterEntry::compare);
    }

    public static <T> Set<Holder<T>> newHolderTreeSet() {
        return new TreeSet<Holder<T>>(AbstractRegisterEntry::compare);
    }

    public static <T> Object2IntMap<Holder<T>> newHolderObject2IntTreeMap() {
        return new Object2IntRBTreeMap(AbstractRegisterEntry::compare);
    }
}

