/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import com.hexagram2021.chromosomelib.registry.SimpleWeightedGeneList;
import com.hexagram2021.chromosomelib.registry.StableWeightedGeneList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;

public class BiomeSpecificWeightedGeneList
implements IWeightedGeneList {
    protected final IWeightedGeneList commonList;
    protected final Map<Holder<Biome>, IWeightedGeneList> biomeSpecificLists;

    protected BiomeSpecificWeightedGeneList(IWeightedGeneList commonList, Map<Holder<Biome>, IWeightedGeneList> biomeSpecificLists) {
        this.commonList = commonList;
        this.biomeSpecificLists = biomeSpecificLists;
    }

    @Override
    public Holder<Gene> getRandomGene(IWeightedGeneList.Context context) {
        IWeightedGeneList biomeSpecificList = this.get(context.biome());
        int commonTotalWeight = this.commonList.totalWeight(context);
        int index = context.random().m_188503_(commonTotalWeight + biomeSpecificList.totalWeight(context));
        if (index < commonTotalWeight) {
            return this.commonList.getRandomGene(context);
        }
        return biomeSpecificList.getRandomGene(context);
    }

    @Override
    public int totalWeight(IWeightedGeneList.Context context) {
        return this.commonList.totalWeight(context) + this.get(context.biome()).totalWeight(context);
    }

    @Override
    public Stream<Holder<Gene>> allGenes() {
        return Stream.concat(this.commonList.allGenes(), this.biomeSpecificLists.values().stream().flatMap(IWeightedGeneList::allGenes)).distinct();
    }

    private IWeightedGeneList get(@Nullable Holder<Biome> biome) {
        return biome == null ? IWeightedGeneList.EMPTY : this.biomeSpecificLists.getOrDefault(biome, IWeightedGeneList.EMPTY);
    }

    public static Builder simpleBuilder() {
        return new Builder(SimpleWeightedGeneList::new);
    }

    public static Builder stableBuilder(double possibilityOfStable) {
        return new Builder(entries -> new StableWeightedGeneList(possibilityOfStable, (ImmutableList<IWeightedGeneList.Entry>)entries));
    }

    public static class Builder
    extends IWeightedGeneList.Builder {
        protected final Map<Holder<Biome>, ImmutableList.Builder<IWeightedGeneList.Entry>> biomeSpecificShadowed = new Object2ObjectOpenHashMap();
        private final IWeightedGeneList.WeightedGeneListFactory factory;

        public Builder(IWeightedGeneList.WeightedGeneListFactory factory) {
            this.factory = factory;
        }

        public Builder add(Holder<Biome> biome, Holder<Gene> gene, int weight) {
            this.biomeSpecificShadowed.computeIfAbsent(biome, ignored -> ImmutableList.builder()).add((Object)IWeightedGeneList.Entry.of(gene, weight));
            return this;
        }

        public Builder add(Holder<Biome> biome, IWeightedGeneList.Entry ... elements) {
            this.biomeSpecificShadowed.computeIfAbsent(biome, ignored -> ImmutableList.builder()).add((Object[])elements);
            return this;
        }

        public Builder addAll(Holder<Biome> biome, Iterable<IWeightedGeneList.Entry> elements) {
            this.biomeSpecificShadowed.computeIfAbsent(biome, ignored -> ImmutableList.builder()).addAll(elements);
            return this;
        }

        public Builder addAll(Holder<Biome> biome, Iterator<IWeightedGeneList.Entry> elements) {
            this.biomeSpecificShadowed.computeIfAbsent(biome, ignored -> ImmutableList.builder()).addAll(elements);
            return this;
        }

        public Builder add(HolderSet<Biome> biomes, Holder<Gene> gene, int weight) {
            biomes.forEach(biome -> this.biomeSpecificShadowed.computeIfAbsent((Holder<Biome>)biome, ignored -> ImmutableList.builder()).add((Object)IWeightedGeneList.Entry.of(gene, weight)));
            return this;
        }

        public Builder add(HolderSet<Biome> biomes, IWeightedGeneList.Entry ... elements) {
            biomes.forEach(biome -> this.biomeSpecificShadowed.computeIfAbsent((Holder<Biome>)biome, ignored -> ImmutableList.builder()).add((Object[])elements));
            return this;
        }

        public Builder addAll(HolderSet<Biome> biomes, Iterable<IWeightedGeneList.Entry> elements) {
            biomes.forEach(biome -> this.biomeSpecificShadowed.computeIfAbsent((Holder<Biome>)biome, ignored -> ImmutableList.builder()).addAll(elements));
            return this;
        }

        public Builder addAll(HolderSet<Biome> biomes, Iterator<IWeightedGeneList.Entry> elements) {
            biomes.forEach(biome -> this.biomeSpecificShadowed.computeIfAbsent((Holder<Biome>)biome, ignored -> ImmutableList.builder()).addAll(elements));
            return this;
        }

        @Override
        BiomeSpecificWeightedGeneList build() {
            ImmutableMap.Builder biomeSpecificShadowedBuilder = ImmutableMap.builder();
            this.biomeSpecificShadowed.forEach((biome, builder) -> biomeSpecificShadowedBuilder.put(biome, (Object)this.factory.create((ImmutableList<IWeightedGeneList.Entry>)builder.build())));
            return new BiomeSpecificWeightedGeneList(this.factory.create((ImmutableList<IWeightedGeneList.Entry>)this.shadowed.build()), (Map<Holder<Biome>, IWeightedGeneList>)biomeSpecificShadowedBuilder.build());
        }
    }
}

