/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.registry;

import com.google.common.collect.ImmutableList;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocusInstance;
import com.hexagram2021.chromosomelib.registry.SimpleWeightedGeneList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Contract;

public interface IWeightedGeneList {
    public static final SimpleWeightedGeneList EMPTY = new SimpleWeightedGeneList((ImmutableList<Entry>)ImmutableList.of());

    public Holder<Gene> getRandomGene(Context var1);

    @Contract(pure=true)
    public int totalWeight(Context var1);

    public Stream<Holder<Gene>> allGenes();

    public static int upperBound(IntList a, int value) {
        int l = 0;
        int r = a.size();
        while (l < r) {
            int mid = l + r >> 1;
            if (a.getInt(mid) <= value) {
                l = mid + 1;
                continue;
            }
            r = mid;
        }
        return l;
    }

    public static interface WeightedGeneListFactory {
        public IWeightedGeneList create(ImmutableList<Entry> var1);
    }

    public static abstract class Builder {
        protected final ImmutableList.Builder<Entry> shadowed = ImmutableList.builder();

        public Builder add(Holder<Gene> gene, int weight) {
            this.shadowed.add((Object)Entry.of(gene, weight));
            return this;
        }

        public Builder add(Entry ... elements) {
            this.shadowed.add((Object[])elements);
            return this;
        }

        public Builder addAll(Iterable<Entry> elements) {
            this.shadowed.addAll(elements);
            return this;
        }

        public Builder addAll(Iterator<Entry> elements) {
            this.shadowed.addAll(elements);
            return this;
        }

        abstract IWeightedGeneList build();
    }

    public record Entry(Holder<Gene> gene, int weight) {
        public static Entry of(Holder<Gene> gene, int weight) {
            if (gene == null) {
                throw new IllegalArgumentException("Gene is null.");
            }
            if (weight <= 0) {
                throw new IllegalArgumentException("Weight must be greater than 0, found " + weight + ".");
            }
            return new Entry(gene, weight);
        }
    }

    public static class Context {
        @Nullable
        private final LevelReader level;
        private final BlockPos blockPos;
        private final RandomSource random;
        @Nullable
        private final Holder<GeneLocus> locus;
        @Nullable
        private final ChromosomeType type;
        @Nullable
        private final ChromosomeInstance last;

        private Context(@Nullable LevelReader level, BlockPos blockPos, RandomSource random) {
            this.level = level;
            this.blockPos = blockPos;
            this.random = random;
            this.locus = null;
            this.type = null;
            this.last = null;
        }

        private Context(@Nullable LevelReader level, BlockPos blockPos, RandomSource random, @Nullable Holder<GeneLocus> locus, @Nullable ChromosomeType type, @Nullable ChromosomeInstance last) {
            this.level = level;
            this.blockPos = blockPos;
            this.random = random;
            this.locus = locus;
            this.type = type;
            this.last = last;
        }

        public static Context of(RandomSource random) {
            return new Context(null, BlockPos.f_121853_, random);
        }

        public static Context of(ServerLevelAccessor serverLevel, BlockPos blockPos) {
            return new Context((LevelReader)serverLevel, blockPos, RandomSource.m_216327_());
        }

        public static Context of(ServerLevelAccessor serverLevel, BlockPos blockPos, RandomSource random) {
            return new Context((LevelReader)serverLevel, blockPos, random);
        }

        public RandomSource random() {
            return this.random;
        }

        @Nullable
        public Holder<Gene> last() {
            if (this.locus == null || this.type == null || this.last == null) {
                return null;
            }
            GeneLocusInstance instance = (GeneLocusInstance)this.last.geneLocusInstances().get(((GeneLocus)this.locus.m_203334_()).index(this.type));
            if (instance == null) {
                return null;
            }
            return instance.gene();
        }

        @Nullable
        public Holder<Biome> biome() {
            if (this.level == null) {
                return null;
            }
            return this.level.m_204166_(this.blockPos);
        }

        @Nullable
        public BlockEntity blockEntity() {
            if (this.level == null) {
                return null;
            }
            return this.level.m_7702_(this.blockPos);
        }

        @Nullable
        public BlockState blockState() {
            if (this.level == null) {
                return null;
            }
            return this.level.m_8055_(this.blockPos);
        }

        @Nullable
        public BlockState below() {
            if (this.level == null) {
                return null;
            }
            return this.level.m_8055_(this.blockPos.m_7495_());
        }

        @Nullable
        public FluidState fluidState() {
            if (this.level == null) {
                return null;
            }
            return this.level.m_6425_(this.blockPos);
        }

        public Context withLast(@Nullable ChromosomeInstance last) {
            return new Context(this.level, this.blockPos, this.random, this.locus, this.type, last);
        }

        public Context withLocusAndType(@Nullable Holder<GeneLocus> locus, @Nullable ChromosomeType type) {
            return new Context(this.level, this.blockPos, this.random, locus, type, this.last);
        }
    }
}

