/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.entity.type.IChromosomeLibEntityType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.trait.Trait;
import com.hexagram2021.chromosomelib.common.trait.TraitType;
import com.hexagram2021.chromosomelib.common.util.CLLogger;
import com.hexagram2021.chromosomelib.common.util.exception.GeneFrequencyNotPresentException;
import com.hexagram2021.chromosomelib.common.util.exception.InvalidGeneFromGeneLocusException;
import com.hexagram2021.chromosomelib.common.util.exception.RegistryConcurrentModificationException;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.CLRegistries;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;

public final class RegistryRelations {
    private static boolean isFrozen = false;
    private static final Map<EntityType<?>, ImmutableList.Builder<Holder<Chromosome>>> entityType2ChromosomeMap = Maps.newIdentityHashMap();
    private static final Map<Holder<Chromosome>, ImmutableList.Builder<Holder<GeneLocus>>> chromosome2GeneLocusMap = Maps.newIdentityHashMap();
    private static final Map<Holder<GeneLocus>, ImmutableList.Builder<Holder<Gene>>> geneLocus2GeneMap = Maps.newIdentityHashMap();
    private static final Map<EntityType<?>, ImmutableList.Builder<Holder<TraitType>>> entityType2TraitTypeMap = Maps.newIdentityHashMap();
    private static final Map<TagKey<EntityType<?>>, ImmutableList.Builder<Holder<Chromosome>>> entityTypeTag2ChromosomeMap = Maps.newHashMap();
    private static final Map<TagKey<EntityType<?>>, ImmutableList.Builder<Holder<TraitType>>> entityTypeTag2TraitTypeMap = Maps.newHashMap();
    private static final ImmutableGraph.Builder<Holder<Gene>> disableRelations = GraphBuilder.directed().immutable();
    private static final ImmutableMap.Builder<Holder<GeneLocus>, IWeightedGeneList> geneFrequency = ImmutableMap.builder();
    private static final Object2IntMap<RemapKey> chromosomeIndexRemapper = new Object2IntOpenHashMap();
    private static final Object2IntMap<RemapTagKey> taggedChromosomeIndexRemapper = new Object2IntOpenHashMap();
    private static final ImmutableMap.Builder<Holder<Chromosome>, ChromosomeType> necessaryChromosomeTypes = ImmutableMap.builder();
    private static int countEntityType2Chromosome = 0;
    private static int countChromosome2GeneLocus = 0;
    private static int countGeneLocus2Gene = 0;
    private static int countEntityType2Trait = 0;

    private RegistryRelations() {
    }

    public static void registerEntityType2Chromosome(EntityType<?> entityType, Holder<Chromosome> chromosome) {
        try {
            RegistryRelations.getBuilder(entityType2ChromosomeMap, entityType).add(chromosome);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityType2ChromosomeMap", "Map", e);
        }
        ++countEntityType2Chromosome;
    }

    public static void registerEntityType2Chromosome(EntityType<?> entityType, Holder<Chromosome> chromosome, int remappedIndex) {
        try {
            RegistryRelations.getBuilder(entityType2ChromosomeMap, entityType).add(chromosome);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityType2ChromosomeMap", "Map", e);
        }
        try {
            chromosomeIndexRemapper.put((Object)new RemapKey(entityType, chromosome), remappedIndex);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "chromosomeIndexRemapper", "Object2IntMap", e);
        }
        ++countEntityType2Chromosome;
    }

    public static void registerChromosome2GeneLocus(Holder<Chromosome> chromosome, Holder<GeneLocus> geneLocus) {
        try {
            RegistryRelations.getBuilder(chromosome2GeneLocusMap, chromosome).add(geneLocus);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "chromosome2GeneLocusMap", "Map", e);
        }
        ++countChromosome2GeneLocus;
    }

    public static void registerGeneLocus2Gene(Holder<GeneLocus> geneLocus, Holder<Gene> gene) {
        try {
            RegistryRelations.getBuilder(geneLocus2GeneMap, geneLocus).add(gene);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "geneLocus2GeneMap", "Map", e);
        }
        ++countGeneLocus2Gene;
    }

    public static void registerEntityType2TraitType(EntityType<?> entityType, Holder<TraitType> traitType) {
        try {
            RegistryRelations.getBuilder(entityType2TraitTypeMap, entityType).add(traitType);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityType2TraitMap", "Map", e);
        }
        ++countEntityType2Trait;
    }

    public static void registerEntityTypeTag2Chromosome(TagKey<EntityType<?>> entityTypeTag, Holder<Chromosome> chromosome) {
        try {
            RegistryRelations.getBuilder(entityTypeTag2ChromosomeMap, entityTypeTag).add(chromosome);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityTypeTag2ChromosomeMap", "Map", e);
        }
    }

    public static void registerEntityTypeTag2Chromosome(TagKey<EntityType<?>> entityTypeTag, Holder<Chromosome> chromosome, int remappedIndex) {
        try {
            RegistryRelations.getBuilder(entityTypeTag2ChromosomeMap, entityTypeTag).add(chromosome);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityTypeTag2ChromosomeMap", "Map", e);
        }
        try {
            taggedChromosomeIndexRemapper.put((Object)new RemapTagKey(entityTypeTag, chromosome), remappedIndex);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "taggedChromosomeIndexRemapper", "Object2IntMap", e);
        }
    }

    public static void registerEntityTypeTag2TraitType(TagKey<EntityType<?>> entityTypeTag, Holder<TraitType> traitType) {
        try {
            RegistryRelations.getBuilder(entityTypeTag2TraitTypeMap, entityTypeTag).add(traitType);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityTypeTag2TraitMap", "Map", e);
        }
    }

    private static <T, R> ImmutableList.Builder<Holder<R>> getBuilder(Map<T, ImmutableList.Builder<Holder<R>>> map, T key) {
        if (isFrozen) {
            throw new IllegalStateException("Relations registry is already frozen!");
        }
        return map.computeIfAbsent(key, k -> new ImmutableList.Builder());
    }

    public static void registerDisableRelation(Holder<Gene> dominant, Holder<Gene> recessive) {
        AbstractRegisterEntry registerEntry;
        if (isFrozen) {
            throw new IllegalStateException("Relations registry is already frozen!");
        }
        if (dominant instanceof AbstractRegisterEntry) {
            registerEntry = (AbstractRegisterEntry)dominant;
            dominant = registerEntry.asHolder();
        }
        if (recessive instanceof AbstractRegisterEntry) {
            registerEntry = (AbstractRegisterEntry)recessive;
            recessive = registerEntry.asHolder();
        }
        disableRelations.putEdge(dominant, recessive);
    }

    public static void registerGeneFrequency(Holder<GeneLocus> geneLocus, IWeightedGeneList.Builder entries) {
        if (isFrozen) {
            throw new IllegalStateException("Relations registry is already frozen!");
        }
        geneFrequency.put(geneLocus, (Object)entries.build());
    }

    public static void registerNecessaryChromosomeTypes(Holder<Chromosome> chromosome, ChromosomeType chromosomeType) {
        if (isFrozen) {
            throw new IllegalStateException("Relations registry is already frozen!");
        }
        try {
            necessaryChromosomeTypes.put(chromosome, (Object)chromosomeType);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "necessaryChromosomeTypes", "Map", e);
        }
    }

    @ApiStatus.Internal
    public static void freezeAndBuild() {
        if (isFrozen) {
            return;
        }
        DefaultedRegistry entityTypeRegistry = BuiltInRegistries.f_256780_;
        Registry geneRegistry = Objects.requireNonNull((Registry)BuiltInRegistries.f_257047_.m_7745_(CLRegistries.GENES.m_135782_()));
        Registry geneLocusRegistry = Objects.requireNonNull((Registry)BuiltInRegistries.f_257047_.m_7745_(CLRegistries.GENE_LOCI.m_135782_()));
        Registry traitRegistry = Objects.requireNonNull((Registry)BuiltInRegistries.f_257047_.m_7745_(CLRegistries.TRAITS.m_135782_()));
        RegistryRelations.buildEntityType2ChromosomeRelations(entityTypeRegistry);
        RegistryRelations.buildChromosome2GeneLocusRelations();
        RegistryRelations.buildGeneLocus2GeneRelations();
        RegistryRelations.buildEntityType2TraitRelations(entityTypeRegistry);
        RegistryRelations.checkGeneFrequencyLists((Registry<GeneLocus>)geneLocusRegistry);
        Chromosome.setNecessaryChromosomeTypes((Map<Holder<Chromosome>, ChromosomeType>)necessaryChromosomeTypes.build());
        RegistryRelations.buildTraitType2TraitsReversedRelations((Registry<Trait>)traitRegistry);
        RegistryRelations.buildGeneTopologicalOrder((Registry<Gene>)geneRegistry);
        isFrozen = true;
        CLLogger.info("Register successfully. Relations registry is frozen.");
    }

    private static void checkGeneFrequencyLists(Registry<GeneLocus> geneLocusRegistry) {
        Set baseline = geneLocusRegistry.m_203611_().collect(Collectors.toCollection(AbstractRegisterEntry::newHolderTreeSet));
        ImmutableMap geneFrequencyLists = geneFrequency.build();
        geneFrequencyLists.forEach((geneLocus, list) -> {
            Set set = Objects.requireNonNull(((GeneLocus)geneLocus.m_203334_()).genes).m_203614_().collect(Collectors.toCollection(AbstractRegisterEntry::newHolderTreeSet));
            list.allGenes().forEach(gene -> {
                if (!set.remove(gene)) {
                    throw new InvalidGeneFromGeneLocusException((Holder<Gene>)gene, (Holder<GeneLocus>)geneLocus);
                }
            });
            if (!set.isEmpty()) {
                throw new GeneFrequencyNotPresentException(set, (Holder<GeneLocus>)geneLocus);
            }
            baseline.remove(geneLocus);
        });
        baseline.forEach(geneLocus -> {
            GeneLocus value = (GeneLocus)geneLocus.m_203334_();
            if (value.genes != null && value.genes.m_203632_() != 0) {
                throw new GeneFrequencyNotPresentException(value.genes.m_203614_().collect(Collectors.toCollection(Sets::newIdentityHashSet)), (Holder<GeneLocus>)geneLocus);
            }
        });
        GeneLocus.setGeneFrequency((Map<Holder<GeneLocus>, IWeightedGeneList>)geneFrequencyLists);
    }

    private static void buildEntityType2TraitRelations(Registry<EntityType<?>> entityTypeRegistry) {
        CLLogger.info("Extracting {} EntityType tags for EntityType to Trait Type relations...", entityTypeTag2TraitTypeMap.size());
        entityTypeTag2TraitTypeMap.forEach((tag, builder) -> {
            ImmutableList traitTypes = builder.build();
            BuiltInRegistries.f_256780_.m_203431_(tag).ifPresent(entries -> entries.forEach(holder -> holder.m_203543_().ifPresent(entityTypeKey -> {
                EntityType entityType = (EntityType)entityTypeRegistry.m_6246_(entityTypeKey);
                if (entityType != null) {
                    RegistryRelations.getBuilder(entityType2TraitTypeMap, entityType).addAll((Iterable)traitTypes);
                    countEntityType2Trait += traitTypes.size();
                }
            })));
        });
        entityTypeTag2TraitTypeMap.clear();
        entityType2TraitTypeMap.forEach((entityType, builder) -> {
            ImmutableList traitTypes = builder.build();
            if (entityType instanceof IChromosomeLibEntityType) {
                IChromosomeLibEntityType clEntityType = (IChromosomeLibEntityType)entityType;
                clEntityType.chromosomelib$setTraitTypes((HolderSet<TraitType>)HolderSet.m_205800_((List)traitTypes));
            }
        });
        CLLogger.info("Registered {} EntityType to TraitType relations from {} EntityTypes.", countEntityType2Trait, entityType2TraitTypeMap.size());
    }

    private static void buildGeneLocus2GeneRelations() {
        geneLocus2GeneMap.forEach((geneLocusHolder, builder) -> {
            GeneLocus geneLocus = (GeneLocus)geneLocusHolder.m_203334_();
            ImmutableList genes = builder.build();
            geneLocus.genes = HolderSet.m_205800_((List)genes);
            genes.forEach(geneHolder -> {
                ((Gene)geneHolder.m_203334_()).geneLocus = Holder.m_205709_((Object)geneLocus);
            });
        });
        CLLogger.info("Registered {} GeneLocus to Gene relations from {} GeneLoci.", countGeneLocus2Gene, geneLocus2GeneMap.size());
    }

    private static void buildChromosome2GeneLocusRelations() {
        chromosome2GeneLocusMap.forEach((chromosomeHolder, builder) -> {
            Chromosome chromosome = (Chromosome)chromosomeHolder.m_203334_();
            ImmutableList geneLoci = builder.build();
            Int2ObjectOpenHashMap leftGeneLocusMap = new Int2ObjectOpenHashMap();
            Int2ObjectOpenHashMap rightGeneLocusMap = new Int2ObjectOpenHashMap();
            for (Holder geneLocusHolder : geneLoci) {
                Holder old;
                GeneLocus geneLocus = (GeneLocus)geneLocusHolder.m_203334_();
                int leftIndex = geneLocus.index(ChromosomeType.LEFT);
                int rightIndex = geneLocus.index(ChromosomeType.RIGHT);
                if (leftIndex >= 0 && (old = (Holder)leftGeneLocusMap.put(leftIndex, (Object)geneLocusHolder)) != null) {
                    throw new IllegalStateException("GeneLocus conflict at left side, index " + leftIndex + "for chromosome " + String.valueOf(chromosomeHolder) + ". Registered " + String.valueOf(old.m_203543_().orElse(null)) + " and " + String.valueOf(geneLocusHolder.m_203543_().orElse(null)) + ".");
                }
                if (rightIndex < 0 || (old = (Holder)rightGeneLocusMap.put(rightIndex, (Object)geneLocusHolder)) == null) continue;
                throw new IllegalStateException("GeneLocus conflict at right side, index " + rightIndex + "for chromosome " + String.valueOf(chromosomeHolder) + ". Registered " + String.valueOf(old.m_203543_().orElse(null)) + " and " + String.valueOf(geneLocusHolder.m_203543_().orElse(null)) + ".");
            }
            chromosome.maintain((Int2ObjectMap<Holder<GeneLocus>>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)leftGeneLocusMap), (Int2ObjectMap<Holder<GeneLocus>>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)rightGeneLocusMap));
        });
        CLLogger.info("Registered {} Chromosome to GeneLocus relations from {} Chromosomes.", countChromosome2GeneLocus, chromosome2GeneLocusMap.size());
    }

    private static void buildEntityType2ChromosomeRelations(Registry<EntityType<?>> entityTypeRegistry) {
        CLLogger.info("Extracting {} EntityType tags for Chromosome index remapper...", taggedChromosomeIndexRemapper.size());
        taggedChromosomeIndexRemapper.forEach((remapTagKey, remappedIndex) -> BuiltInRegistries.f_256780_.m_203431_(remapTagKey.entityTypeTag()).ifPresent(entries -> entries.forEach(holder -> holder.m_203543_().ifPresent(entityTypeKey -> {
            EntityType entityType = (EntityType)entityTypeRegistry.m_6246_(entityTypeKey);
            if (entityType != null) {
                chromosomeIndexRemapper.put((Object)new RemapKey(entityType, remapTagKey.chromosome()), remappedIndex.intValue());
            }
        }))));
        taggedChromosomeIndexRemapper.clear();
        CLLogger.info("Extracting {} EntityType tags for EntityType to Chromosome relations...", entityTypeTag2ChromosomeMap.size());
        entityTypeTag2ChromosomeMap.forEach((tag, builder) -> {
            ImmutableList chromosomes = builder.build();
            BuiltInRegistries.f_256780_.m_203431_(tag).ifPresent(entries -> entries.forEach(holder -> holder.m_203543_().ifPresent(entityTypeKey -> {
                EntityType entityType = (EntityType)entityTypeRegistry.m_6246_(entityTypeKey);
                if (entityType != null) {
                    RegistryRelations.getBuilder(entityType2ChromosomeMap, entityType).addAll((Iterable)chromosomes);
                    countEntityType2Chromosome += chromosomes.size();
                }
            })));
        });
        entityTypeTag2ChromosomeMap.clear();
        entityType2ChromosomeMap.forEach((entityType, builder) -> {
            ImmutableList chromosomes = builder.build();
            Int2ObjectOpenHashMap chromosomeMap = new Int2ObjectOpenHashMap();
            for (Holder chromosomeHolder : chromosomes) {
                Holder old;
                Chromosome chromosome = (Chromosome)chromosomeHolder.m_203334_();
                int index = chromosomeIndexRemapper.getInt((Object)new RemapKey((EntityType<?>)entityType, (Holder<Chromosome>)chromosomeHolder));
                if (index < 0) {
                    index = chromosome.index();
                }
                if ((old = (Holder)chromosomeMap.put(index, (Object)chromosomeHolder)) == null) continue;
                throw new IllegalStateException("Chromosome conflict at index " + chromosome.index() + " for entity type " + String.valueOf(entityType) + ". Registered " + String.valueOf(old.m_203543_().orElse(null)) + " and " + String.valueOf(chromosomeHolder.m_203543_().orElse(null)) + ".");
            }
            if (entityType instanceof IChromosomeLibEntityType) {
                IChromosomeLibEntityType clEntityType = (IChromosomeLibEntityType)entityType;
                clEntityType.chromosomelib$setChromosomes((Int2ObjectMap<Holder<Chromosome>>)chromosomeMap);
            }
        });
        CLLogger.info("Registered {} EntityType to Chromosome relations from {} EntityTypes.", countEntityType2Chromosome, entityType2ChromosomeMap.size());
    }

    private static void buildTraitType2TraitsReversedRelations(Registry<Trait> traitRegistry) {
        ListMultimap traitType2TraitsMap = Multimaps.newListMultimap((Map)Maps.newIdentityHashMap(), Lists::newArrayList);
        traitRegistry.m_203611_().forEach(traitHolder -> traitType2TraitsMap.put(((Trait)traitHolder.m_203334_()).getType(), traitHolder));
        for (Holder traitTypeHolder : traitType2TraitsMap.keySet()) {
            ((TraitType)traitTypeHolder.m_203334_()).setValues((HolderSet<Trait>)HolderSet.m_205800_((List)traitType2TraitsMap.get((Object)traitTypeHolder)));
        }
    }

    private static void buildGeneTopologicalOrder(Registry<Gene> geneRegistry) {
        geneRegistry.m_206115_().forEach(arg_0 -> disableRelations.addNode(arg_0));
        ImmutableGraph geneGraph = disableRelations.build();
        Object2IntRBTreeMap degrees = new Object2IntRBTreeMap(Comparator.comparingInt(Object::hashCode));
        ArrayDeque queue = Queues.newArrayDeque();
        for (Holder gene : geneGraph.nodes()) {
            int degree;
            if (gene instanceof AbstractRegisterEntry) {
                AbstractRegisterEntry registerEntry = (AbstractRegisterEntry)gene;
                gene = registerEntry.asHolder();
            }
            if ((degree = geneGraph.inDegree((Object)gene)) == 0) {
                queue.add(gene);
                ((Gene)gene.m_203334_()).topologicalOrder = 0;
            }
            degrees.put(gene, degree);
        }
        while (!queue.isEmpty()) {
            Holder gene = (Holder)queue.poll();
            for (Holder neighbor : geneGraph.successors((Object)gene)) {
                int degree = degrees.getInt((Object)neighbor) - 1;
                degrees.put((Object)neighbor, degree);
                if (degree != 0) continue;
                queue.add(neighbor);
                ((Gene)neighbor.m_203334_()).topologicalOrder = ((Gene)gene.m_203334_()).topologicalOrder + 1;
            }
        }
        ArrayList cyclicGenes = Lists.newArrayList();
        for (Holder gene : geneGraph.nodes()) {
            if (degrees.getInt((Object)gene) == 0) continue;
            cyclicGenes.add(gene);
        }
        if (!cyclicGenes.isEmpty()) {
            throw new IllegalStateException("Cyclic gene relations detected: " + String.valueOf(cyclicGenes));
        }
        Gene.setDisableRelationship((ImmutableGraph<Holder<Gene>>)geneGraph);
    }

    static {
        chromosomeIndexRemapper.defaultReturnValue(-1);
    }

    private record RemapKey(EntityType<?> entityType, Holder<Chromosome> chromosome) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RemapKey) {
                RemapKey other = (RemapKey)obj;
                return this.entityType == other.entityType && AbstractRegisterEntry.equals(this.chromosome, other.chromosome);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entityType.hashCode() + AbstractRegisterEntry.hashCode(this.chromosome);
        }
    }

    private record RemapTagKey(TagKey<EntityType<?>> entityTypeTag, Holder<Chromosome> chromosome) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RemapTagKey) {
                RemapTagKey other = (RemapTagKey)obj;
                return this.entityTypeTag.equals(other.entityTypeTag) && AbstractRegisterEntry.equals(this.chromosome, other.chromosome);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entityTypeTag.hashCode() + AbstractRegisterEntry.hashCode(this.chromosome);
        }
    }
}

