package com.hexagram2021.chromosomelib.common;

import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.entity.IChromosomeCarrier;
import com.hexagram2021.chromosomelib.common.util.Breeders;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import java.util.Collection;

public final class CLCommonEvents {
	/**
	 * Called when two entities is breeding.
	 */
	@SuppressWarnings("java:S1854")
	public static boolean onEntityBreed(class_1309 parentA, class_1309 parentB, @Nullable class_1309 child) {
		if(child == null) {
			return false;
		}

		IChromosomeCarrier carrierA = (IChromosomeCarrier) parentA;
		IChromosomeCarrier carrierB = (IChromosomeCarrier) parentB;
		IChromosomeCarrier carrierChild = (IChromosomeCarrier) child;

		Breeders.crossOver(carrierA.chromosomelib$getChromosomes(), parentA.method_6051());
		Breeders.crossOver(carrierB.chromosomelib$getChromosomes(), parentB.method_6051());
		Collection<ChromosomeInstance> childChromosomes = Breeders.breed(
				parentA.method_5864(), parentB.method_5864(),
				carrierA.chromosomelib$getChromosomes(), carrierB.chromosomelib$getChromosomes(),
				child.method_6051()
		);
		Breeders.mutate(childChromosomes, child.method_6051());
		carrierChild.chromosomelib$resetTraits();
		carrierChild.chromosomelib$setChromosomes(childChromosomes);

		return true;
	}

	private CLCommonEvents() {
	}
}
