package com.hexagram2021.chromosomelib.common.gene_locus;

import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.CLRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6899;

public record GeneLocusInstance(class_6880<Gene> gene) {
	public static final Codec<GeneLocusInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group(
			class_6899.method_40400(CLRegistries.GENES).fieldOf("gene").forGetter(GeneLocusInstance::gene)
	).apply(instance, GeneLocusInstance::new));
	public static final Codec<List<GeneLocusInstance>> LIST_CODEC = CODEC.listOf();

	public class_6880<GeneLocus> geneLocus() {
		return Objects.requireNonNull(this.gene.comp_349().geneLocus);
	}

	public int index(ChromosomeType type) {
		return this.geneLocus().comp_349().index(type);
	}

	public void express(Object2IntMap<class_6880<Gene>> set) {
		class_6880<Gene> gene = this.gene instanceof AbstractRegisterEntry<Gene> registerEntry ? registerEntry.asHolder() : this.gene;
		set.computeInt(gene, (ignored, value) -> value == null ? 1 : value + 1);
	}

	public GeneLocusInstance copy() {
		return new GeneLocusInstance(this.gene);
	}

	public GeneLocusInstance mutate(class_5819 random) {
		List<class_6880<Gene>> toMutate = Objects.requireNonNull(this.geneLocus().comp_349().genes).method_40239()
				.filter(gene -> gene != this.gene).toList();
		return new GeneLocusInstance(toMutate.get(random.method_43048(toMutate.size())));
	}
}
