package com.hexagram2021.chromosomelib.common.trait;

import net.minecraft.class_2960;
import net.minecraft.class_6885;
import org.jetbrains.annotations.ApiStatus;

/**
 * Abstract trait type.
 */
public abstract class AbstractTraitType implements TraitType {
	/**
	 * The name of this trait type.
	 */
	private final class_2960 name;
	/**
	 * All traits bound to this trait type.
	 */
	private class_6885<Trait> values = class_6885.method_40246();

	/**
	 * Constructor.
	 * @param name	the name of this trait type
	 */
	protected AbstractTraitType(class_2960 name) {
		this.name = name;
	}

	/**
	 * @return the name of this trait type
	 */
	@Override
	public String toString() {
		return this.name.toString();
	}

	/**
	 * All traits bound to this trait type.
	 * @return a collection of traits
	 */
	@Override
	public class_6885<Trait> values() {
		return this.values;
	}

	/**
	 * Set all traits bound to this trait type.
	 * @param values	a collection of traits
	 */
	@ApiStatus.Internal
	@Override
	public void setValues(class_6885<Trait> values) {
		this.values = values;
	}
}
