package com.hexagram2021.chromosomelib.common.trait;

import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import org.jetbrains.annotations.Contract;

import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.class_6880;

public interface TraitHandler {
	Map<class_6880<TraitType>, TraitHandler> HANDLERS = AbstractRegisterEntry.newHolderTreeMap();

	static void registerHandler(class_6880<TraitType> type, TraitHandler handler) {
		HANDLERS.put(type, handler);
	}

	static TraitHandler getHandler(class_6880<TraitType> type) {
		return HANDLERS.get(type);
	}

	/**
	 *
	 * @param activeGeneWeight	returns a weight of the given gene.
	 *                          <p>For diploids, 0 is for inactive gene, 1 or 2 means the count of the given gene.
	 *                          <p>Notice that autosomal, completely recessive genes will always return 0 or 2. For incompletely dominant genes, you can code different logics based on whether the return value is 1 or 2
	 * @return a trait of given trait type, determined by active genes
	 */
	@Contract(pure = true)
	class_6880<Trait> handle(ToIntFunction<class_6880<Gene>> activeGeneWeight);
}
