package com.hexagram2021.chromosomelib.common.trait;

import org.jetbrains.annotations.ApiStatus;

import java.util.Comparator;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

/**
 * Trait type.
 */
public interface TraitType {
	/**
	 * Comparator for trait types.
	 */
	Comparator<TraitType> COMPARATOR = Comparator.comparing(TraitType::toString);

	/**
	 * Default trait.
	 * @return a trait bound to this type
	 */
	class_6880<Trait> example();

	/**
	 * All traits bound to this type.
	 * @return a collection of traits
	 */
	class_6885<Trait> values();

	/**
	 * Set the traits bound to this type.
	 * @param values	a collection of traits
	 */
	@ApiStatus.Internal
	void setValues(class_6885<Trait> values);

	/**
	 * The string representation of this trait type. It is recommended to use the registry name of this trait type.
	 * @return name of this trait type.
	 */
	@Override
	String toString();
}
