package com.hexagram2021.chromosomelib.event;

import com.hexagram2021.chromosomelib.common.trait.Trait;
import com.hexagram2021.chromosomelib.common.trait.TraitType;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_6880;

/**
 * Called after assigning traits to a living entity.
 */
public interface AfterAssigningTraitSolver {
	/**
	 * @param livingEntity	the living entity
	 * @param map			the trait map
	 * @param hasTrait		whether the living entity has the trait
	 */
	void solveAfterAssigningTrait(class_1309 livingEntity, Map<class_6880<TraitType>, class_6880<Trait>> map, Predicate<class_6880<Trait>> hasTrait);
}
