package com.hexagram2021.chromosomelib.event;

import com.google.common.collect.ImmutableCollection;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import java.util.Collection;
import net.minecraft.class_1299;
import net.minecraft.class_5819;

public interface UnpairedChromosomesToBreedSolver {
	/**
	 * @param entityType			the entity type with unpaired chromosomes
	 * @param chromosomeInstances	the chromosome instances of this entity
	 * @param random				random source
	 * @param builder				chromosomes builder, do NOT modify it until you decide to return {@code true}
	 * @return {@code true} if we just solved this situation. {@code false} otherwise. If false, the builder should NOT be modified.
	 */
	boolean solveUnpairedChromosomesToBreed(class_1299<?> entityType, Collection<ChromosomeInstance> chromosomeInstances, class_5819 random, ImmutableCollection.Builder<ChromosomeInstance> builder);
}
