package com.hexagram2021.chromosomelib.fabric;

import com.google.common.collect.ImmutableCollection;
import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.trait.Trait;
import com.hexagram2021.chromosomelib.common.trait.TraitType;
import com.hexagram2021.chromosomelib.fabric.event.CLFabricEvents;
import com.hexagram2021.chromosomelib.fabric.registry.FabricRegisterEntry;
import com.hexagram2021.chromosomelib.platform.services.IPlatformHelper;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.CLRegistries;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

@ApiStatus.Internal
public class FabricPlatformHelper implements IPlatformHelper {
	@Override
	public AbstractRegisterEntry<Chromosome> registerChromosome(class_2960 id, Supplier<Chromosome> chromosome) {
		class_5321<Chromosome> key = class_5321.method_29179(CLRegistries.CHROMOSOMES, id);
		return new FabricRegisterEntry<>(class_2378.method_47984(ChromosomeLibFabric.CHROMOSOMES, key, chromosome.get()), key);
	}

	@Override
	public AbstractRegisterEntry<GeneLocus> registerGeneLocus(class_2960 id, Supplier<GeneLocus> geneLocus) {
		class_5321<GeneLocus> key = class_5321.method_29179(CLRegistries.GENE_LOCI, id);
		return new FabricRegisterEntry<>(class_2378.method_47984(ChromosomeLibFabric.GENE_LOCI, key, geneLocus.get()), key);
	}

	@Override
	public AbstractRegisterEntry<Gene> registerGene(class_2960 id, Supplier<Gene> gene) {
		class_5321<Gene> key = class_5321.method_29179(CLRegistries.GENES, id);
		return new FabricRegisterEntry<>(class_2378.method_47984(ChromosomeLibFabric.GENES, key, gene.get()), key);
	}

	@Override
	public AbstractRegisterEntry<Trait> registerTrait(class_2960 id, Supplier<Trait> trait) {
		class_5321<Trait> key = class_5321.method_29179(CLRegistries.TRAITS, id);
		return new FabricRegisterEntry<>(class_2378.method_47984(ChromosomeLibFabric.TRAITS, key, trait.get()), key);
	}

	@Override
	public AbstractRegisterEntry<TraitType> registerTraitType(class_2960 id, Supplier<TraitType> traitType) {
		class_5321<TraitType> key = class_5321.method_29179(CLRegistries.TRAIT_TYPES, id);
		return new FabricRegisterEntry<>(class_2378.method_47984(ChromosomeLibFabric.TRAIT_TYPES, key, traitType.get()), key);
	}

	@Override
	public boolean solveUnpairedChromosomesToBreed(class_1299<?> entityType, Collection<ChromosomeInstance> chromosomeInstances, class_5819 random, ImmutableCollection.Builder<ChromosomeInstance> builder) {
		return CLFabricEvents.UNPAIRED_CHROMOSOMES_TO_BREED_SOLVER.invoker().solveUnpairedChromosomesToBreed(entityType, chromosomeInstances, random, builder);
	}

	@Override
	public void solveAfterAssigningTrait(class_1309 livingEntity, Map<class_6880<TraitType>, class_6880<Trait>> map, Predicate<class_6880<Trait>> hasTrait) {
		CLFabricEvents.AFTER_ASSIGNING_TRAIT_SOLVER.invoker().solveAfterAssigningTrait(livingEntity, map, hasTrait);
	}
}
