package com.hexagram2021.chromosomelib.fabric.mixin;

import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.entity.type.IChromosomeLibEntityType;
import com.hexagram2021.chromosomelib.common.trait.TraitType;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import net.minecraft.class_1299;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SuppressWarnings({"java:S100", "java:S116", "NotNullFieldNotInitialized"})
@Mixin(class_1299.class)
public class EntityTypeMixin implements IChromosomeLibEntityType {
	@Unique
	private Int2ObjectMap<class_6880<Chromosome>> chromosomelib$chromosomes;
	@Unique
	private Object2IntMap<class_6880<Chromosome>> chromosomelib$invertChromosomes;
	@Unique
	private class_6885<TraitType> chromosomelib$traitTypes;

	@Inject(method = "<init>", at = @At(value = "TAIL"))
	private void chromosomelib$initChromosomes(CallbackInfo ci) {
		this.chromosomelib$chromosomes = Int2ObjectMaps.emptyMap();
		this.chromosomelib$invertChromosomes = Object2IntMaps.emptyMap();
		this.chromosomelib$traitTypes = class_6885.method_40246();
	}

	@Override
	public Int2ObjectMap<class_6880<Chromosome>> chromosomelib$getChromosomes() {
		return this.chromosomelib$chromosomes;
	}

	@Override
	public int chromosomelib$getChromosomeIndex(class_6880<Chromosome> chromosome) {
		return this.chromosomelib$invertChromosomes.getInt(chromosome);
	}

	@Override
	public void chromosomelib$setChromosomes(Int2ObjectMap<class_6880<Chromosome>> chromosomes) {
		this.chromosomelib$chromosomes = chromosomes;
		this.chromosomelib$invertChromosomes = AbstractRegisterEntry.newHolderObject2IntTreeMap();
		chromosomes.forEach((index, chromosome) -> this.chromosomelib$invertChromosomes.put(chromosome, index.intValue()));
	}

	@Override
	public class_6885<TraitType> chromosomelib$getTraitTypes() {
		return this.chromosomelib$traitTypes;
	}

	@Override
	public void chromosomelib$setTraitTypes(class_6885<TraitType> traits) {
		this.chromosomelib$traitTypes = traits;
	}
}
