package com.hexagram2021.chromosomelib.mixin;

import com.hexagram2021.chromosomelib.ChromosomeLib;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.entity.IChromosomeCarrier;
import com.hexagram2021.chromosomelib.common.util.CLLogger;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("java:S100")
@Mixin(class_1297.class)
public class EntityMixin {
	@Inject(method = "load", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift = At.Shift.AFTER))
	private void chromosomelib$loadChromosomes(class_2487 nbt, CallbackInfo ci) {
		if(this instanceof IChromosomeCarrier carrier && nbt.method_10573(ChromosomeLib.CHROMOSOMES_TAG, class_2520.field_33259)) {
			class_6903<class_2520> ops = class_6903.method_46632(class_2509.field_11560, ((class_1297)(Object)this).method_37908().method_30349());
			carrier.chromosomelib$setChromosomes(
					ChromosomeInstance.LIST_CODEC
							.parse(ops, nbt.method_10554(ChromosomeLib.CHROMOSOMES_TAG, class_2520.field_33260))
							.getOrThrow(false, CLLogger::error)
			);
		}
	}

	@Inject(method = "saveWithoutId", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift = At.Shift.AFTER))
	private void chromosomelib$saveChromosomes(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
		if(this instanceof IChromosomeCarrier carrier) {
			class_6903<class_2520> ops = class_6903.method_46632(class_2509.field_11560, ((class_1297)(Object)this).method_37908().method_30349());
			nbt.method_10566(ChromosomeLib.CHROMOSOMES_TAG, ChromosomeInstance.LIST_CODEC.encodeStart(ops, carrier.chromosomelib$getChromosomes()).getOrThrow(false, CLLogger::error));
		}
	}
}
