package com.hexagram2021.chromosomelib.mixin;

import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.entity.IChromosomeCarrier;
import com.hexagram2021.chromosomelib.common.entity.type.IChromosomeLibEntityType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.trait.Trait;
import com.hexagram2021.chromosomelib.common.trait.TraitHandler;
import com.hexagram2021.chromosomelib.common.trait.TraitType;
import com.hexagram2021.chromosomelib.common.util.Mappers;
import com.hexagram2021.chromosomelib.platform.Services;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.apache.commons.compress.utils.Lists;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

@SuppressWarnings({"java:S100", "java:S116", "NotNullFieldNotInitialized"})
@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements IChromosomeCarrier {
	@Shadow
	public abstract class_5819 getRandom();

	@Unique
	private List<ChromosomeInstance> chromosomelib$chromosomes;
	@Unique
	private Object2IntMap<class_6880<Gene>> chromosomelib$activeGenes;
	@Unique
	private Map<class_6880<TraitType>, class_6880<Trait>> chromosomelib$activeTraits;

	@Unique
	private boolean chromosomelib$isTraitsSolved;

	@Inject(method = "<init>", at = @At(value = "TAIL"))
	private void chromosomelib$initChromosomes(CallbackInfo ci) {
		this.chromosomelib$chromosomes = Lists.newArrayList();
		this.chromosomelib$activeGenes = AbstractRegisterEntry.newHolderObject2IntTreeMap();
		this.chromosomelib$activeTraits = AbstractRegisterEntry.newHolderTreeMap();
		this.chromosomelib$isTraitsSolved = false;
		this.chromosomelib$setChromosomes(this.chromosomelib$buildDefaultChromosomes(
				(IChromosomeLibEntityType)((class_1309)(Object)this).method_5864(),
				IWeightedGeneList.Context.of(this.getRandom())
		));
	}

	@Inject(method = "addAdditionalSaveData", at = @At(value = "HEAD"))
	private void chromosomelib$saveChromosomes(class_2487 nbt, CallbackInfo ci) {
		nbt.method_10556("ChromosomeLibIsTraitsSolved", this.chromosomelib$isTraitsSolved);
	}

	@Inject(method = "readAdditionalSaveData", at = @At(value = "HEAD"))
	private void chromosomelib$loadChromosomes(class_2487 nbt, CallbackInfo ci) {
		this.chromosomelib$isTraitsSolved = nbt.method_10577("ChromosomeLibIsTraitsSolved");
	}

	@Override
	public List<ChromosomeInstance> chromosomelib$getChromosomes() {
		return this.chromosomelib$chromosomes;
	}

	@Override
	public void chromosomelib$setChromosomes(Collection<ChromosomeInstance> chromosomes) {
		// setting the collection
		this.chromosomelib$chromosomes.clear();
		this.chromosomelib$chromosomes.addAll(chromosomes);

		//maintaining active genes and traits
		this.chromosomelib$activeGenes.clear();
		this.chromosomelib$activeGenes.putAll(Mappers.convertChromosomeInstancesToExpressingGenes(this.chromosomelib$chromosomes));
		Gene.doDisable(this.chromosomelib$activeGenes);

		this.chromosomelib$assignTraits();
	}

	@Override
	public ToIntFunction<class_6880<Gene>> chromosomelib$getActiveGenes() {
		return this.chromosomelib$activeGenes;
	}

	@Override
	public Collection<class_6880<Trait>> chromosomelib$getActiveTraits() {
		return this.chromosomelib$activeTraits.values();
	}

	@Override
	public void chromosomelib$assignTraits() {
		class_1309 current = (class_1309)(Object)this;
		this.chromosomelib$activeTraits.clear();
		((IChromosomeLibEntityType)(current).method_5864()).chromosomelib$getTraitTypes()
				.forEach(traitType -> this.chromosomelib$activeTraits.put(traitType, TraitHandler.getHandler(traitType).handle(this.chromosomelib$activeGenes)));
		if(!current.method_37908().field_9236 && !this.chromosomelib$isTraitsSolved) {
			Services.PLATFORM.solveAfterAssigningTrait(current, this.chromosomelib$activeTraits, this.chromosomelib$activeTraits.values()::contains);
			this.chromosomelib$isTraitsSolved = true;
		}
	}

	@Override
	public void chromosomelib$resetTraits() {
		this.chromosomelib$isTraitsSolved = false;
	}

	@Override
	public boolean chromosomelib$isTraitsSolved() {
		return this.chromosomelib$isTraitsSolved;
	}
}
