package com.hexagram2021.chromosomelib.platform.services;

import com.google.common.collect.ImmutableCollection;
import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.trait.Trait;
import com.hexagram2021.chromosomelib.common.trait.TraitType;
import com.hexagram2021.chromosomelib.event.AfterAssigningTraitSolver;
import com.hexagram2021.chromosomelib.event.UnpairedChromosomesToBreedSolver;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

/**
 * REMEMBER: Only call these methods in mod initializer.
 */
public interface IPlatformHelper extends UnpairedChromosomesToBreedSolver, AfterAssigningTraitSolver {
	AbstractRegisterEntry<Chromosome> registerChromosome(class_2960 id, Supplier<Chromosome> chromosome);
	AbstractRegisterEntry<GeneLocus> registerGeneLocus(class_2960 id, Supplier<GeneLocus> geneLocus);
	AbstractRegisterEntry<Gene> registerGene(class_2960 id, Supplier<Gene> gene);
	AbstractRegisterEntry<Trait> registerTrait(class_2960 id, Supplier<Trait> trait);
	AbstractRegisterEntry<TraitType> registerTraitType(class_2960 id, Supplier<TraitType> traitType);

	@Override
	boolean solveUnpairedChromosomesToBreed(class_1299<?> entityType, Collection<ChromosomeInstance> chromosomeInstances, class_5819 random, ImmutableCollection.Builder<ChromosomeInstance> builder);

	@Override
	void solveAfterAssigningTrait(class_1309 livingEntity, Map<class_6880<TraitType>, class_6880<Trait>> map, Predicate<class_6880<Trait>> hasTrait);
}
