package com.hexagram2021.chromosomelib.registry;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.*;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7876;

/**
 * Abstract register entry.
 * @param <T>	the type of the entry
 */
@SuppressWarnings({"unused", "java:S3038"})
public abstract class AbstractRegisterEntry<T> implements class_6880<T>, Supplier<T> {
	/**
	 * resource key of the entry
	 */
	protected final class_5321<T> key;

	/**
	 * Constructor.
	 * @param key	resource key of the entry
	 */
	protected AbstractRegisterEntry(class_5321<T> key) {
		this.key = key;
	}

	/**
	 * @param id	id to check
	 * @return true if the entry matches the id.
	 */
	@Override
	public boolean method_40226(class_2960 id) {
		return id.equals(this.key.method_29177());
	}

	/**
	 * @param key	key to check
	 * @return true if the entry matches the key.
	 */
	@Override
	public boolean method_40225(class_5321<T> key) {
		return this.key.equals(key);
	}

	/**
	 * @param filter	filter to check
	 * @return true if the entry matches the filter.
	 */
	@Override
	public boolean method_40224(Predicate<class_5321<T>> filter) {
		return filter.test(this.key);
	}

	/**
	 * @param tag	tag to check
	 * @return true if the entry is in the tag.
	 */
	@Override
	public abstract boolean method_40220(class_6862<T> tag);

	/**
	 * @return tags of the entry.
	 */
	@Override
	public abstract Stream<class_6862<T>> method_40228();

	/**
	 * @return true if the entry is bound.
	 */
	@Override
	public abstract boolean method_40227();

	/**
	 * @see class_6880.class_6883#method_40229
	 * @return resource key of the entry.
	 */
	@Override
	public Either<class_5321<T>, T> method_40229() {
		return Either.left(this.key);
	}

	/**
	 * @see class_6880.class_6883#method_40230
	 * @return resource key of the entry.
	 */
	@Override
	public Optional<class_5321<T>> method_40230() {
		return Optional.of(this.key);
	}

	/**
	 * @see class_6880.class_6883#method_40231
	 * @return kind of the entry.
	 */
	@Override
	public class_6882 method_40231() {
		return class_6882.field_36446;
	}

	/**
	 * @see class_6880.class_6883#method_46745
	 * @param owner	owner of the entry
	 * @return true if the entry can be serialized in the owner.
	 */
	@Override
	public abstract boolean method_46745(class_7876<T> owner);

	/**
	 * @see class_6880#comp_349
	 * @return value of the entry.
	 */
	@Override
	public abstract T comp_349();

	/**
	 * @see AbstractRegisterEntry#comp_349
	 * @return value of the entry.
	 */
	@Override
	public T get() {
		return this.comp_349();
	}

	/**
	 * @param obj	another object
	 * @return true if the object is equal to this object.
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if(obj instanceof class_6880.class_6883<?> reference) {
			return reference.method_40237() == this.key;
		}
		return obj instanceof class_6880<?> h && this.key.equals(h.method_40230().orElse(null));
	}

	/**
	 * @return hash code of the entry.
	 */
	@Override
	public int hashCode() {
		return this.key.hashCode();
	}

	/**
	 * @return string representation of the entry.
	 */
	@Override
	public String toString() {
		return "RegisterEntry{" + this.key + "}";
	}

	/**
	 * Get the vanilla holder of the entry.
	 * @return vanilla holder of the entry.
	 */
	public abstract class_6880<T> asHolder();

	/**
	 * @return optional of the entry. null if the entry is not bound.
	 */
	public Optional<T> asOptional() {
		return this.method_40227() ? Optional.of(this.comp_349()) : Optional.empty();
	}

	/**
	 * Get the id of the entry.
	 * @return id of the entry.
	 */
	public class_2960 id() {
		return this.key.method_29177();
	}

	/**
	 * Get the key of the entry.
	 * @return key of the entry.
	 */
	public class_5321<T> key() {
		return this.key;
	}

	private static Comparator<class_5321<?>> resourceKeyComparator = (a, b) -> {
		int regDiff = a.method_41185().method_12833(b.method_41185());
		if(regDiff == 0) {
			return a.method_29177().method_12833(b.method_29177());
		}
		return regDiff;
	};

	/**
	 * Compare two holders.
	 * @param a	first holder
	 * @param b	second holder
	 * @return true if the holders are equal. false otherwise.
	 */
	public static boolean equals(class_6880<?> a, class_6880<?> b) {
		if (a == b) {
			return true;
		}
		if(a instanceof AbstractRegisterEntry<?> registerEntryA) {
			if(b instanceof AbstractRegisterEntry<?> registerEntryB) {
				return registerEntryA.key() == registerEntryB.key();
			}
			return registerEntryA.asHolder() == b;
		}
		if(b instanceof AbstractRegisterEntry<?> registerEntryB) {
			return registerEntryB.asHolder() == a;
		}
		return false;
	}

	/**
	 * Get the hash code of the holder.
	 * @param holder	to get the hash code
	 * @return hash code of the holder.
	 */
	public static int hashCode(class_6880<?> holder) {
		if(holder instanceof AbstractRegisterEntry<?> registerEntry) {
			return registerEntry.key().hashCode();
		}
		return holder.hashCode();
	}

	/**
	 * Compare two holders.
	 * @param a	first holder
	 * @param b	second holder
	 * @return the result of the comparison.
	 * @param <T>	the type of the entry
	 */
	public static <T> int compare(class_6880<T> a, class_6880<T> b) {
		if(a instanceof AbstractRegisterEntry<T> registerEntryA) {
			if(b instanceof AbstractRegisterEntry<T> registerEntryB) {
				return resourceKeyComparator.compare(registerEntryA.key(), registerEntryB.key());
			}
			if(b instanceof class_6880.class_6883<T> referenceB) {
				return resourceKeyComparator.compare(registerEntryA.key(), referenceB.method_40237());
			}
			return 1;
		}
		if(a instanceof class_6880.class_6883<T> referenceA) {
			if(b instanceof AbstractRegisterEntry<T> registerEntryB) {
				return resourceKeyComparator.compare(referenceA.method_40237(), registerEntryB.key());
			}
			if(b instanceof class_6880.class_6883<T> referenceB) {
				return resourceKeyComparator.compare(referenceA.method_40237(), referenceB.method_40237());
			}
			return 1;
		}
		if(b instanceof AbstractRegisterEntry<T> || b instanceof class_6880.class_6883<T>) {
			return -1;
		}
		return Integer.compare(a.hashCode(), b.hashCode());
	}

	/**
	 * Create a tree map with the comparator. Users should use this instead of {@link com.google.common.collect.Maps#newIdentityHashMap()}.
	 * @return a tree map with the comparator.
	 * @param <T>	the type of the entry
	 * @param <V>	the type of the value
	 */
	public static <T, V> Map<class_6880<T>, V> newHolderTreeMap() {
		return new TreeMap<>(AbstractRegisterEntry::compare);
	}

	/**
	 * Create a tree set with the comparator. Users should use this instead of {@link com.google.common.collect.Sets#newIdentityHashSet()}.
	 * @return a tree set with the comparator.
	 * @param <T>	the type of the entry
	 */
	public static <T> Set<class_6880<T>> newHolderTreeSet() {
		return new TreeSet<>(AbstractRegisterEntry::compare);
	}

	/**
	 * Create a tree map with the comparator. Users should use this instead of {@link com.google.common.collect.Maps#newIdentityHashMap()}.
	 * @return a tree map with the comparator.
	 * @param <T>	the type of the entry
	 */
	public static <T> Object2IntMap<class_6880<T>> newHolderObject2IntTreeMap() {
		return new Object2IntRBTreeMap<>(AbstractRegisterEntry::compare);
	}
}
