/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.chromosome;

import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.entity.type.IChromosomeLibEntityType;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

public class Chromosome {
    private static Map<class_6880<Chromosome>, ChromosomeType> necessaryChromosomeTypes = Map.of();
    private Int2ObjectMap<class_6880<GeneLocus>> leftGeneLoci = Int2ObjectMaps.emptyMap();
    private Int2ObjectMap<class_6880<GeneLocus>> rightGeneLoci = Int2ObjectMaps.emptyMap();
    private final int index;
    private int homoSegmentStartDiff = 0;
    private int homoCount = 0;

    public Chromosome(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public static int index(class_6880<Chromosome> chromosome, class_1299<?> entityType) {
        if (entityType instanceof IChromosomeLibEntityType) {
            IChromosomeLibEntityType chromosomeLibEntityType = (IChromosomeLibEntityType)entityType;
            return chromosomeLibEntityType.chromosomelib$getChromosomeIndex(chromosome);
        }
        return ((Chromosome)chromosome.comp_349()).index();
    }

    public Int2ObjectMap<class_6880<GeneLocus>> geneLoci(ChromosomeType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ChromosomeType.LEFT -> this.leftGeneLoci;
            case ChromosomeType.RIGHT -> this.rightGeneLoci;
        };
    }

    @ApiStatus.Internal
    public void maintain(Int2ObjectMap<class_6880<GeneLocus>> leftGeneLoci, Int2ObjectMap<class_6880<GeneLocus>> rightGeneLoci) {
        this.leftGeneLoci = leftGeneLoci;
        this.rightGeneLoci = rightGeneLoci;
        ObjectSet intersection = (ObjectSet)leftGeneLoci.values().stream().filter(locus -> locus.comp_349() instanceof GeneLocus.HomologousGeneLocus).collect(Collectors.toCollection(ObjectOpenHashSet::new));
        intersection.retainAll((Collection)rightGeneLoci.values());
        Int2IntOpenHashMap kMap = new Int2IntOpenHashMap();
        for (class_6880 locus2 : intersection) {
            Object object = locus2.comp_349();
            if (!(object instanceof GeneLocus.HomologousGeneLocus)) continue;
            GeneLocus.HomologousGeneLocus geneLocus = (GeneLocus.HomologousGeneLocus)object;
            kMap.compute(geneLocus.leftIndex() - geneLocus.rightIndex(), (k, v) -> v == null ? 1 : v + 1);
        }
        kMap.int2IntEntrySet().stream().max(Comparator.comparingInt(Int2IntMap.Entry::getIntValue)).ifPresent(entry -> {
            this.homoSegmentStartDiff = entry.getIntKey();
            this.homoCount = entry.getIntValue();
        });
    }

    @ApiStatus.Internal
    public int homoSegmentStartDiff() {
        return this.homoSegmentStartDiff;
    }

    @ApiStatus.Internal
    public static void setNecessaryChromosomeTypes(Map<class_6880<Chromosome>, ChromosomeType> necessaryChromosomeTypes) {
        Chromosome.necessaryChromosomeTypes = necessaryChromosomeTypes;
    }

    @Nullable
    public static ChromosomeType getNecessaryChromosomeType(class_6880<Chromosome> chromosome) {
        return necessaryChromosomeTypes.get(chromosome);
    }
}

