/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.chromosome;

import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocusInstance;
import com.hexagram2021.chromosomelib.common.util.exception.InvalidGeneFromGeneLocusException;
import com.hexagram2021.chromosomelib.registry.CLRegistries;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6899;

public class ChromosomeInstance {
    public static final Codec<ChromosomeInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6899.method_40400(CLRegistries.CHROMOSOMES).fieldOf("chromosome").forGetter(ChromosomeInstance::chromosome), (App)ChromosomeType.CODEC.fieldOf("type").forGetter(ChromosomeInstance::type), (App)GeneLocusInstance.LIST_CODEC.fieldOf("gene_locus_instances").forGetter(chromosomeInstance -> List.copyOf(chromosomeInstance.geneLocusInstances.values()))).apply((Applicative)instance, ChromosomeInstance::of));
    public static final Codec<List<ChromosomeInstance>> LIST_CODEC = CODEC.listOf();
    private static final class_5819 RANDOM = class_5819.method_43047();
    private final class_6880<Chromosome> chromosome;
    private final ChromosomeType type;
    private final Int2ObjectMap<GeneLocusInstance> geneLocusInstances;

    private ChromosomeInstance(class_6880<Chromosome> chromosome, ChromosomeType type, Int2ObjectMap<GeneLocusInstance> geneLocusInstances, IWeightedGeneList.Context context) {
        this.chromosome = chromosome;
        this.type = type;
        this.geneLocusInstances = geneLocusInstances;
        ((Chromosome)chromosome.comp_349()).geneLoci(type).forEach((index, geneLocus) -> this.geneLocusInstances.compute(index, (ignored, existing) -> {
            if (existing == null) {
                return new GeneLocusInstance(GeneLocus.getRandomGene((class_6880<GeneLocus>)geneLocus, context.withLocusAndType((class_6880<GeneLocus>)geneLocus, this.type)));
            }
            if (existing.geneLocus().comp_349() != geneLocus.comp_349()) {
                throw new InvalidGeneFromGeneLocusException(existing.gene(), (class_6880<GeneLocus>)geneLocus);
            }
            return existing;
        }));
    }

    public static ChromosomeInstance of(class_6880<Chromosome> chromosome, ChromosomeType type) {
        return ChromosomeInstance.of(chromosome, type, IWeightedGeneList.Context.of(RANDOM));
    }

    public static ChromosomeInstance of(class_6880<Chromosome> chromosome, ChromosomeType type, Collection<GeneLocusInstance> geneLocusInstances) {
        return ChromosomeInstance.of(chromosome, type, geneLocusInstances, IWeightedGeneList.Context.of(RANDOM));
    }

    public static ChromosomeInstance of(class_6880<Chromosome> chromosome, ChromosomeType type, IWeightedGeneList.Context context) {
        return new ChromosomeInstance(chromosome, type, (Int2ObjectMap<GeneLocusInstance>)new Int2ObjectOpenHashMap(), context);
    }

    public static ChromosomeInstance of(class_6880<Chromosome> chromosome, ChromosomeType type, Collection<GeneLocusInstance> geneLocusInstances, IWeightedGeneList.Context context) {
        Int2ObjectOpenHashMap geneLocusInstancesMap = new Int2ObjectOpenHashMap();
        geneLocusInstances.forEach(arg_0 -> ChromosomeInstance.lambda$of$4(type, chromosome, (Int2ObjectMap)geneLocusInstancesMap, arg_0));
        return new ChromosomeInstance(chromosome, type, (Int2ObjectMap<GeneLocusInstance>)geneLocusInstancesMap, context);
    }

    public class_6880<Chromosome> chromosome() {
        return this.chromosome;
    }

    public ChromosomeType type() {
        return this.type;
    }

    public Int2ObjectMap<GeneLocusInstance> geneLocusInstances() {
        return this.geneLocusInstances;
    }

    public ChromosomeInstance copy() {
        return ChromosomeInstance.of(this.chromosome, this.type, (Collection<GeneLocusInstance>)this.geneLocusInstances.values());
    }

    public void express(Object2IntMap<class_6880<Gene>> set) {
        this.geneLocusInstances.values().forEach(geneLocusInstance -> geneLocusInstance.express(set));
    }

    private static /* synthetic */ void lambda$of$4(ChromosomeType type, class_6880 chromosome, Int2ObjectMap geneLocusInstancesMap, GeneLocusInstance geneLocusInstance) {
        int index = geneLocusInstance.index(type);
        if (index < 0) {
            throw new IllegalArgumentException("%s may be a heterologous gene locus and cannot be applied to %s side of chromosome %s".formatted(geneLocusInstance.gene(), type.name().toLowerCase(Locale.ROOT), chromosome));
        }
        geneLocusInstancesMap.put(index, (Object)geneLocusInstance.copy());
    }
}

