/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.command;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.entity.IChromosomeCarrier;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocusInstance;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.CLRegistries;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ChromosomeLibCommand {
    private static final String ENTITY_ARGUMENT = "entity";
    private static final String CHROMOSOME_INDEX_ARGUMENT = "chromosome_index";
    private static final String GENE_LOCUS_INDEX_ARGUMENT = "gene_locus_index";
    private static final String GENE_1_ARGUMENT = "gene_1";
    private static final String GENE_2_ARGUMENT = "gene_2";
    private static final class_2378<Chromosome> chromosomeRegistry = Objects.requireNonNull((class_2378)class_7923.field_41167.method_10223(CLRegistries.CHROMOSOMES.method_29177()));
    private static final class_2378<Gene> geneRegistry = Objects.requireNonNull((class_2378)class_7923.field_41167.method_10223(CLRegistries.GENES.method_29177()));
    private static final SuggestionProvider<class_2168> GENE_SUGGESTIONS = class_2321.method_10022((class_2960)new class_2960("chromosomelib", "genes"), (context, builder) -> class_2172.method_9257(geneRegistry.method_40270().flatMap(holder -> holder.method_40230().stream().map(class_5321::method_29177)), (SuggestionsBuilder)builder));
    public static final Dynamic2CommandExceptionType GENE_LOCUS_INDEX_MISMATCHED = new Dynamic2CommandExceptionType((expected, found) -> class_2561.method_43470((String)"Gene Locus index mismatched. Expected %d, found %d.".formatted((int)((Integer)expected), (Integer)found)));

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chromosomelib").requires(stack -> stack.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"show").executes(ctx -> ChromosomeLibCommand.show(((class_2168)ctx.getSource()).method_44023(), ((class_2168)ctx.getSource()).method_9228()))).then(class_2170.method_9244((String)ENTITY_ARGUMENT, (ArgumentType)class_2186.method_9309()).executes(ctx -> ChromosomeLibCommand.show(((class_2168)ctx.getSource()).method_44023(), class_2186.method_9313((CommandContext)ctx, (String)ENTITY_ARGUMENT)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reassign").executes(ctx -> ChromosomeLibCommand.reassign(((class_2168)ctx.getSource()).method_9228()))).then(class_2170.method_9244((String)ENTITY_ARGUMENT, (ArgumentType)class_2186.method_9309()).executes(ctx -> ChromosomeLibCommand.reassign(class_2186.method_9313((CommandContext)ctx, (String)ENTITY_ARGUMENT)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)ENTITY_ARGUMENT, (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)CHROMOSOME_INDEX_ARGUMENT, (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)GENE_LOCUS_INDEX_ARGUMENT, (ArgumentType)IntegerArgumentType.integer((int)0)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)GENE_1_ARGUMENT, (ArgumentType)class_2232.method_9441()).suggests(GENE_SUGGESTIONS).executes(ctx -> ChromosomeLibCommand.set(class_2186.method_9313((CommandContext)ctx, (String)ENTITY_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CHROMOSOME_INDEX_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)GENE_LOCUS_INDEX_ARGUMENT), class_2232.method_9443((CommandContext)ctx, (String)GENE_1_ARGUMENT), class_2232.method_9443((CommandContext)ctx, (String)GENE_1_ARGUMENT)))).then(class_2170.method_9244((String)GENE_2_ARGUMENT, (ArgumentType)class_2232.method_9441()).suggests(GENE_SUGGESTIONS).executes(ctx -> ChromosomeLibCommand.set(class_2186.method_9313((CommandContext)ctx, (String)ENTITY_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CHROMOSOME_INDEX_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)ctx, (String)GENE_LOCUS_INDEX_ARGUMENT), class_2232.method_9443((CommandContext)ctx, (String)GENE_1_ARGUMENT), class_2232.method_9443((CommandContext)ctx, (String)GENE_2_ARGUMENT)))))))));
    }

    private static String chromosome2Loc(class_6880<Chromosome> holder) {
        return (String)holder.method_40229().map(key -> key.method_29177().toString(), value -> {
            class_2960 key = chromosomeRegistry.method_10221(value);
            if (key == null) {
                return "";
            }
            return key.toString();
        });
    }

    private static String gene2Loc(class_6880<Gene> holder) {
        return (String)holder.method_40229().map(key -> key.method_29177().toString(), value -> {
            class_2960 key = geneRegistry.method_10221(value);
            if (key == null) {
                return "";
            }
            return key.toString();
        });
    }

    private static int show(@Nullable class_3222 player, @Nullable class_1297 entity) {
        Map toShow = AbstractRegisterEntry.newHolderTreeMap();
        if (player != null && entity instanceof IChromosomeCarrier) {
            IChromosomeCarrier carrier = (IChromosomeCarrier)entity;
            ToIntFunction<class_6880<Gene>> activeGenes = carrier.chromosomelib$getActiveGenes();
            carrier.chromosomelib$getChromosomes().forEach(chromosomeInstance -> {
                Object2IntMap chromosomeGenes = toShow.computeIfAbsent(chromosomeInstance.chromosome(), ignored -> AbstractRegisterEntry.newHolderObject2IntTreeMap());
                chromosomeInstance.geneLocusInstances().forEach((index, geneLocusInstance) -> chromosomeGenes.put(geneLocusInstance.gene(), activeGenes.applyAsInt(geneLocusInstance.gene())));
            });
            StringBuilder builder = new StringBuilder();
            toShow.keySet().stream().sorted(Comparator.comparing(ChromosomeLibCommand::chromosome2Loc)).forEach(chromosome -> {
                Object2IntMap chromosomeGenes = (Object2IntMap)toShow.get(chromosome);
                if (!chromosomeGenes.isEmpty()) {
                    builder.append(ChromosomeLibCommand.chromosome2Loc((class_6880<Chromosome>)chromosome)).append(":\n");
                    chromosomeGenes.keySet().forEach(gene -> builder.append("  - ").append(ChromosomeLibCommand.gene2Loc((class_6880<Gene>)gene)).append(": ").append(activeGenes.applyAsInt((class_6880<Gene>)gene)).append('\n'));
                }
            });
            player.method_43496((class_2561)class_2561.method_43470((String)builder.toString()));
        }
        return 1;
    }

    private static int reassign(@Nullable class_1297 entity) {
        if (entity instanceof IChromosomeCarrier) {
            IChromosomeCarrier carrier = (IChromosomeCarrier)entity;
            carrier.chromosomelib$resetTraits();
            carrier.chromosomelib$assignTraits();
        }
        return 1;
    }

    private static int set(@Nullable class_1297 entity, int chromosomeIndex, int geneLocusIndex, class_2960 geneId1, class_2960 geneId2) throws CommandSyntaxException {
        class_6880.class_6883 gene1 = geneRegistry.method_40290(class_5321.method_29179(CLRegistries.GENES, (class_2960)geneId1));
        class_6880.class_6883 gene2 = geneRegistry.method_40290(class_5321.method_29179(CLRegistries.GENES, (class_2960)geneId2));
        if (entity instanceof IChromosomeCarrier) {
            IChromosomeCarrier carrier = (IChromosomeCarrier)entity;
            AtomicInteger cnt = new AtomicInteger(0);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ChromosomeInstance chromosomeInstance : carrier.chromosomelib$getChromosomes()) {
                int index = Chromosome.index(chromosomeInstance.chromosome(), entity.method_5864());
                if (index == chromosomeIndex) {
                    Set geneLocusInstances = Sets.newIdentityHashSet();
                    Int2ObjectMap<GeneLocusInstance> original = chromosomeInstance.geneLocusInstances();
                    IntIterator intIterator = original.keySet().iterator();
                    while (intIterator.hasNext()) {
                        int locusIndex = (Integer)intIterator.next();
                        if (locusIndex == geneLocusIndex) {
                            int currentCnt = cnt.get();
                            if ((currentCnt & 1) == 0) {
                                ChromosomeLibCommand.checkGeneLocusIndex((class_6880<Gene>)gene1, chromosomeInstance.type(), geneLocusIndex);
                                geneLocusInstances.add(new GeneLocusInstance((class_6880<Gene>)gene1));
                            } else {
                                ChromosomeLibCommand.checkGeneLocusIndex((class_6880<Gene>)gene2, chromosomeInstance.type(), geneLocusIndex);
                                geneLocusInstances.add(new GeneLocusInstance((class_6880<Gene>)gene2));
                            }
                            cnt.set(currentCnt + 1);
                            continue;
                        }
                        geneLocusInstances.add((GeneLocusInstance)original.get(locusIndex));
                    }
                    builder.add((Object)ChromosomeInstance.of(chromosomeInstance.chromosome(), chromosomeInstance.type(), geneLocusInstances));
                    continue;
                }
                builder.add((Object)chromosomeInstance);
            }
            carrier.chromosomelib$setChromosomes((Collection<ChromosomeInstance>)builder.build());
        }
        return 1;
    }

    private static void checkGeneLocusIndex(class_6880<Gene> gene, ChromosomeType type, int index) throws CommandSyntaxException {
        int found = ((GeneLocus)Objects.requireNonNull(((Gene)gene.comp_349()).geneLocus).comp_349()).index(type);
        if (found != index) {
            throw GENE_LOCUS_INDEX_MISMATCHED.create((Object)index, (Object)found);
        }
    }

    private ChromosomeLibCommand() {
    }
}

