/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.gene_locus;

import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.ApiStatus;

public abstract class GeneLocus {
    private static Map<class_6880<GeneLocus>, IWeightedGeneList> geneFrequency = Map.of();
    @Nullable
    @ApiStatus.Internal
    public class_6880<Chromosome> chromosome = null;
    @Nullable
    @ApiStatus.Internal
    public class_6885<Gene> genes = null;
    public final double possibilityOfMutation;
    public final double possibilityOfCrossingOver;

    protected GeneLocus(double possibilityOfMutation, double possibilityOfCrossingOver) {
        this.possibilityOfMutation = possibilityOfMutation;
        this.possibilityOfCrossingOver = possibilityOfCrossingOver;
    }

    public abstract int index(ChromosomeType var1);

    public static LeftGeneLocus left(int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
        return new LeftGeneLocus(index, possibilityOfMutation, possibilityOfCrossingOver);
    }

    public static RightGeneLocus right(int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
        return new RightGeneLocus(index, possibilityOfMutation, possibilityOfCrossingOver);
    }

    public static HomologousGeneLocus homologous(int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
        return new HomologousGeneLocus(index, possibilityOfMutation, possibilityOfCrossingOver);
    }

    public static HomologousGeneLocus homologous(int leftIndex, int rightIndex, double possibilityOfMutation, double possibilityOfCrossingOver) {
        return new HomologousGeneLocus(leftIndex, rightIndex, possibilityOfMutation, possibilityOfCrossingOver);
    }

    @ApiStatus.Internal
    public static void setGeneFrequency(Map<class_6880<GeneLocus>, IWeightedGeneList> geneFrequency) {
        GeneLocus.geneFrequency = geneFrequency;
    }

    public static class_6880<Gene> getRandomGene(class_6880<GeneLocus> geneLocus, IWeightedGeneList.Context context) {
        return geneFrequency.get(geneLocus).getRandomGene(context);
    }

    public static class LeftGeneLocus
    extends GeneLocus {
        private final int index;

        public LeftGeneLocus(int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
            super(possibilityOfMutation, possibilityOfCrossingOver);
            if (index <= 0 || index > 0xFFFFFF) {
                throw new IllegalArgumentException("Illegal index: " + index);
            }
            this.index = index;
        }

        @Override
        public int index(ChromosomeType chromosomeType) {
            return chromosomeType == ChromosomeType.LEFT ? this.index : -1;
        }
    }

    public static class RightGeneLocus
    extends GeneLocus {
        private final int index;

        public RightGeneLocus(int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
            super(possibilityOfMutation, possibilityOfCrossingOver);
            if (index <= 0 || index > 0xFFFFFF) {
                throw new IllegalArgumentException("Illegal index: " + index);
            }
            this.index = index;
        }

        @Override
        public int index(ChromosomeType chromosomeType) {
            return chromosomeType == ChromosomeType.RIGHT ? this.index : -1;
        }
    }

    public static class HomologousGeneLocus
    extends GeneLocus {
        private final int leftIndex;
        private final int rightIndex;

        public HomologousGeneLocus(int index, double possibilityOfMutation, double possibilityOfCrossingOver) {
            this(index, index, possibilityOfMutation, possibilityOfCrossingOver);
        }

        public HomologousGeneLocus(int leftIndex, int rightIndex, double possibilityOfMutation, double possibilityOfCrossingOver) {
            super(possibilityOfMutation, possibilityOfCrossingOver);
            if (leftIndex <= 0 || leftIndex > 0xFFFFFF) {
                throw new IllegalArgumentException("Illegal left index: " + leftIndex);
            }
            if (rightIndex <= 0 || rightIndex > 0xFFFFFF) {
                throw new IllegalArgumentException("Illegal right index: " + rightIndex);
            }
            this.leftIndex = leftIndex;
            this.rightIndex = rightIndex;
        }

        @Override
        public int index(ChromosomeType chromosomeType) {
            return switch (chromosomeType) {
                default -> throw new IncompatibleClassChangeError();
                case ChromosomeType.LEFT -> this.leftIndex;
                case ChromosomeType.RIGHT -> this.rightIndex;
            };
        }

        public int leftIndex() {
            return this.leftIndex;
        }

        public int rightIndex() {
            return this.rightIndex;
        }
    }
}

