/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.common.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocusInstance;
import com.hexagram2021.chromosomelib.common.util.exception.UnpairedChromosomeException;
import com.hexagram2021.chromosomelib.platform.Services;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public final class Breeders {
    public static void crossOver(Collection<ChromosomeInstance> chromosomes, class_5819 random) {
        IdentityHashMap temporary = Maps.newIdentityHashMap();
        chromosomes.forEach(chromosomeInstance -> {
            class_6880<Chromosome> chromosome = chromosomeInstance.chromosome();
            ChromosomeInstance oldInstance = temporary.put(chromosome, chromosomeInstance);
            boolean swap = false;
            if (oldInstance != null) {
                int offset = ((Chromosome)chromosome.comp_349()).homoSegmentStartDiff() * (chromosomeInstance.type().ordinal() - oldInstance.type().ordinal());
                for (Int2ObjectMap.Entry entry : chromosomeInstance.geneLocusInstances().int2ObjectEntrySet()) {
                    GeneLocusInstance current = (GeneLocusInstance)entry.getValue();
                    int otherIndex = entry.getIntKey() + offset;
                    GeneLocusInstance other = (GeneLocusInstance)oldInstance.geneLocusInstances().get(otherIndex);
                    class_6880<GeneLocus> geneLocus = current.geneLocus();
                    if (other != null && other.geneLocus() == geneLocus) {
                        if (random.method_43058() <= ((GeneLocus)geneLocus.comp_349()).possibilityOfCrossingOver) {
                            boolean bl = swap = !swap;
                        }
                        if (!swap) continue;
                        entry.setValue((Object)other);
                        oldInstance.geneLocusInstances().put(otherIndex, (Object)current);
                        continue;
                    }
                    swap = false;
                }
            }
        });
    }

    public static void mutate(Collection<ChromosomeInstance> chromosomes, class_5819 random) {
        chromosomes.forEach(chromosomeInstance -> {
            for (Int2ObjectMap.Entry entry : chromosomeInstance.geneLocusInstances().int2ObjectEntrySet()) {
                GeneLocusInstance geneLocusInstance = (GeneLocusInstance)entry.getValue();
                if (!(random.method_43058() <= ((GeneLocus)geneLocusInstance.geneLocus().comp_349()).possibilityOfMutation)) continue;
                entry.setValue((Object)geneLocusInstance.mutate(random));
            }
        });
    }

    public static Collection<ChromosomeInstance> breed(class_1299<?> parentAType, class_1299<?> parentBType, Collection<ChromosomeInstance> parentA, Collection<ChromosomeInstance> parentB, class_5819 random) {
        int i;
        ObjectArrayList shuffled;
        Collection chromosomeInstances;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        class_6880 failed = null;
        ListMultimap temporary = Multimaps.newListMultimap(AbstractRegisterEntry.newHolderTreeMap(), Lists::newArrayList);
        parentA.forEach(arg_0 -> Breeders.lambda$breed$2((Multimap)temporary, arg_0));
        for (class_6880 chromosome : temporary.keySet()) {
            chromosomeInstances = temporary.get((Object)chromosome);
            if (chromosomeInstances.size() % 2 == 1) {
                failed = chromosome;
                break;
            }
            shuffled = new ObjectArrayList(chromosomeInstances);
            class_156.method_43028((ObjectArrayList)shuffled, (class_5819)random);
            for (i = 0; i < shuffled.size(); i += 2) {
                builder.add((Object)((ChromosomeInstance)shuffled.get(i)).copy());
            }
        }
        if (failed != null) {
            if (!Services.PLATFORM.solveUnpairedChromosomesToBreed(parentAType, parentA, random, (ImmutableCollection.Builder<ChromosomeInstance>)builder)) {
                throw new UnpairedChromosomeException(parentAType, "breed", (class_6880<Chromosome>)failed, temporary.get((Object)failed));
            }
            failed = null;
        }
        temporary.clear();
        parentB.forEach(arg_0 -> Breeders.lambda$breed$3((Multimap)temporary, arg_0));
        for (class_6880 chromosome : temporary.keySet()) {
            chromosomeInstances = temporary.get((Object)chromosome);
            if (chromosomeInstances.size() % 2 == 1) {
                failed = chromosome;
                break;
            }
            shuffled = new ObjectArrayList(chromosomeInstances);
            class_156.method_43028((ObjectArrayList)shuffled, (class_5819)random);
            for (i = 0; i < shuffled.size(); i += 2) {
                builder.add((Object)((ChromosomeInstance)shuffled.get(i)).copy());
            }
        }
        if (failed != null && !Services.PLATFORM.solveUnpairedChromosomesToBreed(parentBType, parentB, random, (ImmutableCollection.Builder<ChromosomeInstance>)builder)) {
            throw new UnpairedChromosomeException(parentBType, "breed", (class_6880<Chromosome>)failed, temporary.get((Object)failed));
        }
        return builder.build();
    }

    private Breeders() {
    }

    private static /* synthetic */ void lambda$breed$3(Multimap temporary, ChromosomeInstance chromosomeInstance) {
        temporary.put(chromosomeInstance.chromosome(), (Object)chromosomeInstance);
    }

    private static /* synthetic */ void lambda$breed$2(Multimap temporary, ChromosomeInstance chromosomeInstance) {
        temporary.put(chromosomeInstance.chromosome(), (Object)chromosomeInstance);
    }
}

