/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import com.hexagram2021.chromosomelib.registry.SimpleWeightedGeneList;
import com.hexagram2021.chromosomelib.registry.StableWeightedGeneList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1959;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class BiomeSpecificWeightedGeneList
implements IWeightedGeneList {
    protected final IWeightedGeneList commonList;
    protected final Map<class_6880<class_1959>, IWeightedGeneList> biomeSpecificLists;

    protected BiomeSpecificWeightedGeneList(IWeightedGeneList commonList, Map<class_6880<class_1959>, IWeightedGeneList> biomeSpecificLists) {
        this.commonList = commonList;
        this.biomeSpecificLists = biomeSpecificLists;
    }

    @Override
    public class_6880<Gene> getRandomGene(IWeightedGeneList.Context context) {
        IWeightedGeneList biomeSpecificList = this.get(context.biome());
        int commonTotalWeight = this.commonList.totalWeight(context);
        int index = context.random().method_43048(commonTotalWeight + biomeSpecificList.totalWeight(context));
        if (index < commonTotalWeight) {
            return this.commonList.getRandomGene(context);
        }
        return biomeSpecificList.getRandomGene(context);
    }

    @Override
    public int totalWeight(IWeightedGeneList.Context context) {
        return this.commonList.totalWeight(context) + this.get(context.biome()).totalWeight(context);
    }

    @Override
    public Stream<class_6880<Gene>> allGenes() {
        return Stream.concat(this.commonList.allGenes(), this.biomeSpecificLists.values().stream().flatMap(IWeightedGeneList::allGenes)).distinct();
    }

    private IWeightedGeneList get(@Nullable class_6880<class_1959> biome) {
        return biome == null ? IWeightedGeneList.EMPTY : this.biomeSpecificLists.getOrDefault(biome, IWeightedGeneList.EMPTY);
    }

    public static Builder simpleBuilder() {
        return new Builder(SimpleWeightedGeneList::new);
    }

    public static Builder stableBuilder(double possibilityOfStable) {
        return new Builder(entries -> new StableWeightedGeneList(possibilityOfStable, (ImmutableList<IWeightedGeneList.Entry>)entries));
    }

    public static class Builder
    extends IWeightedGeneList.Builder {
        protected final Map<class_6880<class_1959>, ImmutableList.Builder<IWeightedGeneList.Entry>> biomeSpecificShadowed = new Object2ObjectOpenHashMap();
        private final IWeightedGeneList.WeightedGeneListFactory factory;

        public Builder(IWeightedGeneList.WeightedGeneListFactory factory) {
            this.factory = factory;
        }

        public Builder add(class_6880<class_1959> biome, class_6880<Gene> gene, int weight) {
            this.biomeSpecificShadowed.computeIfAbsent(biome, ignored -> ImmutableList.builder()).add((Object)IWeightedGeneList.Entry.of(gene, weight));
            return this;
        }

        public Builder add(class_6880<class_1959> biome, IWeightedGeneList.Entry ... elements) {
            this.biomeSpecificShadowed.computeIfAbsent(biome, ignored -> ImmutableList.builder()).add((Object[])elements);
            return this;
        }

        public Builder addAll(class_6880<class_1959> biome, Iterable<IWeightedGeneList.Entry> elements) {
            this.biomeSpecificShadowed.computeIfAbsent(biome, ignored -> ImmutableList.builder()).addAll(elements);
            return this;
        }

        public Builder addAll(class_6880<class_1959> biome, Iterator<IWeightedGeneList.Entry> elements) {
            this.biomeSpecificShadowed.computeIfAbsent(biome, ignored -> ImmutableList.builder()).addAll(elements);
            return this;
        }

        public Builder add(class_6885<class_1959> biomes, class_6880<Gene> gene, int weight) {
            biomes.forEach(biome -> this.biomeSpecificShadowed.computeIfAbsent((class_6880<class_1959>)biome, ignored -> ImmutableList.builder()).add((Object)IWeightedGeneList.Entry.of(gene, weight)));
            return this;
        }

        public Builder add(class_6885<class_1959> biomes, IWeightedGeneList.Entry ... elements) {
            biomes.forEach(biome -> this.biomeSpecificShadowed.computeIfAbsent((class_6880<class_1959>)biome, ignored -> ImmutableList.builder()).add((Object[])elements));
            return this;
        }

        public Builder addAll(class_6885<class_1959> biomes, Iterable<IWeightedGeneList.Entry> elements) {
            biomes.forEach(biome -> this.biomeSpecificShadowed.computeIfAbsent((class_6880<class_1959>)biome, ignored -> ImmutableList.builder()).addAll(elements));
            return this;
        }

        public Builder addAll(class_6885<class_1959> biomes, Iterator<IWeightedGeneList.Entry> elements) {
            biomes.forEach(biome -> this.biomeSpecificShadowed.computeIfAbsent((class_6880<class_1959>)biome, ignored -> ImmutableList.builder()).addAll(elements));
            return this;
        }

        @Override
        BiomeSpecificWeightedGeneList build() {
            ImmutableMap.Builder biomeSpecificShadowedBuilder = ImmutableMap.builder();
            this.biomeSpecificShadowed.forEach((biome, builder) -> biomeSpecificShadowedBuilder.put(biome, (Object)this.factory.create((ImmutableList<IWeightedGeneList.Entry>)builder.build())));
            return new BiomeSpecificWeightedGeneList(this.factory.create((ImmutableList<IWeightedGeneList.Entry>)this.shadowed.build()), (Map<class_6880<class_1959>, IWeightedGeneList>)biomeSpecificShadowedBuilder.build());
        }
    }
}

