/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.registry;

import com.google.common.collect.ImmutableList;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeInstance;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocusInstance;
import com.hexagram2021.chromosomelib.registry.SimpleWeightedGeneList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Contract;

public interface IWeightedGeneList {
    public static final SimpleWeightedGeneList EMPTY = new SimpleWeightedGeneList((ImmutableList<Entry>)ImmutableList.of());

    public class_6880<Gene> getRandomGene(Context var1);

    @Contract(pure=true)
    public int totalWeight(Context var1);

    public Stream<class_6880<Gene>> allGenes();

    public static int upperBound(IntList a, int value) {
        int l = 0;
        int r = a.size();
        while (l < r) {
            int mid = l + r >> 1;
            if (a.getInt(mid) <= value) {
                l = mid + 1;
                continue;
            }
            r = mid;
        }
        return l;
    }

    public static interface WeightedGeneListFactory {
        public IWeightedGeneList create(ImmutableList<Entry> var1);
    }

    public static abstract class Builder {
        protected final ImmutableList.Builder<Entry> shadowed = ImmutableList.builder();

        public Builder add(class_6880<Gene> gene, int weight) {
            this.shadowed.add((Object)Entry.of(gene, weight));
            return this;
        }

        public Builder add(Entry ... elements) {
            this.shadowed.add((Object[])elements);
            return this;
        }

        public Builder addAll(Iterable<Entry> elements) {
            this.shadowed.addAll(elements);
            return this;
        }

        public Builder addAll(Iterator<Entry> elements) {
            this.shadowed.addAll(elements);
            return this;
        }

        abstract IWeightedGeneList build();
    }

    public record Entry(class_6880<Gene> gene, int weight) {
        public static Entry of(class_6880<Gene> gene, int weight) {
            if (gene == null) {
                throw new IllegalArgumentException("Gene is null.");
            }
            if (weight <= 0) {
                throw new IllegalArgumentException("Weight must be greater than 0, found " + weight + ".");
            }
            return new Entry(gene, weight);
        }
    }

    public static class Context {
        @Nullable
        private final class_4538 level;
        private final class_2338 blockPos;
        private final class_5819 random;
        @Nullable
        private final class_6880<GeneLocus> locus;
        @Nullable
        private final ChromosomeType type;
        @Nullable
        private final ChromosomeInstance last;

        private Context(@Nullable class_4538 level, class_2338 blockPos, class_5819 random) {
            this.level = level;
            this.blockPos = blockPos;
            this.random = random;
            this.locus = null;
            this.type = null;
            this.last = null;
        }

        private Context(@Nullable class_4538 level, class_2338 blockPos, class_5819 random, @Nullable class_6880<GeneLocus> locus, @Nullable ChromosomeType type, @Nullable ChromosomeInstance last) {
            this.level = level;
            this.blockPos = blockPos;
            this.random = random;
            this.locus = locus;
            this.type = type;
            this.last = last;
        }

        public static Context of(class_5819 random) {
            return new Context(null, class_2338.field_10980, random);
        }

        public static Context of(class_5425 serverLevel, class_2338 blockPos) {
            return new Context((class_4538)serverLevel, blockPos, class_5819.method_43047());
        }

        public static Context of(class_5425 serverLevel, class_2338 blockPos, class_5819 random) {
            return new Context((class_4538)serverLevel, blockPos, random);
        }

        public class_5819 random() {
            return this.random;
        }

        @Nullable
        public class_6880<Gene> last() {
            if (this.locus == null || this.type == null || this.last == null) {
                return null;
            }
            GeneLocusInstance instance = (GeneLocusInstance)this.last.geneLocusInstances().get(((GeneLocus)this.locus.comp_349()).index(this.type));
            if (instance == null) {
                return null;
            }
            return instance.gene();
        }

        @Nullable
        public class_6880<class_1959> biome() {
            if (this.level == null) {
                return null;
            }
            return this.level.method_23753(this.blockPos);
        }

        @Nullable
        public class_2586 blockEntity() {
            if (this.level == null) {
                return null;
            }
            return this.level.method_8321(this.blockPos);
        }

        @Nullable
        public class_2680 blockState() {
            if (this.level == null) {
                return null;
            }
            return this.level.method_8320(this.blockPos);
        }

        @Nullable
        public class_2680 below() {
            if (this.level == null) {
                return null;
            }
            return this.level.method_8320(this.blockPos.method_10074());
        }

        @Nullable
        public class_3610 fluidState() {
            if (this.level == null) {
                return null;
            }
            return this.level.method_8316(this.blockPos);
        }

        public Context withLast(@Nullable ChromosomeInstance last) {
            return new Context(this.level, this.blockPos, this.random, this.locus, this.type, last);
        }

        public Context withLocusAndType(@Nullable class_6880<GeneLocus> locus, @Nullable ChromosomeType type) {
            return new Context(this.level, this.blockPos, this.random, locus, type, this.last);
        }
    }
}

