/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.hexagram2021.chromosomelib.common.chromosome.Chromosome;
import com.hexagram2021.chromosomelib.common.chromosome.ChromosomeType;
import com.hexagram2021.chromosomelib.common.entity.type.IChromosomeLibEntityType;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.common.gene_locus.GeneLocus;
import com.hexagram2021.chromosomelib.common.trait.Trait;
import com.hexagram2021.chromosomelib.common.trait.TraitType;
import com.hexagram2021.chromosomelib.common.util.CLLogger;
import com.hexagram2021.chromosomelib.common.util.exception.GeneFrequencyNotPresentException;
import com.hexagram2021.chromosomelib.common.util.exception.InvalidGeneFromGeneLocusException;
import com.hexagram2021.chromosomelib.common.util.exception.RegistryConcurrentModificationException;
import com.hexagram2021.chromosomelib.registry.AbstractRegisterEntry;
import com.hexagram2021.chromosomelib.registry.CLRegistries;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

public final class RegistryRelations {
    private static boolean isFrozen = false;
    private static final Map<class_1299<?>, ImmutableList.Builder<class_6880<Chromosome>>> entityType2ChromosomeMap = Maps.newIdentityHashMap();
    private static final Map<class_6880<Chromosome>, ImmutableList.Builder<class_6880<GeneLocus>>> chromosome2GeneLocusMap = Maps.newIdentityHashMap();
    private static final Map<class_6880<GeneLocus>, ImmutableList.Builder<class_6880<Gene>>> geneLocus2GeneMap = Maps.newIdentityHashMap();
    private static final Map<class_1299<?>, ImmutableList.Builder<class_6880<TraitType>>> entityType2TraitTypeMap = Maps.newIdentityHashMap();
    private static final Map<class_6862<class_1299<?>>, ImmutableList.Builder<class_6880<Chromosome>>> entityTypeTag2ChromosomeMap = Maps.newHashMap();
    private static final Map<class_6862<class_1299<?>>, ImmutableList.Builder<class_6880<TraitType>>> entityTypeTag2TraitTypeMap = Maps.newHashMap();
    private static final ImmutableGraph.Builder<class_6880<Gene>> disableRelations = GraphBuilder.directed().immutable();
    private static final ImmutableMap.Builder<class_6880<GeneLocus>, IWeightedGeneList> geneFrequency = ImmutableMap.builder();
    private static final Object2IntMap<RemapKey> chromosomeIndexRemapper = new Object2IntOpenHashMap();
    private static final Object2IntMap<RemapTagKey> taggedChromosomeIndexRemapper = new Object2IntOpenHashMap();
    private static final ImmutableMap.Builder<class_6880<Chromosome>, ChromosomeType> necessaryChromosomeTypes = ImmutableMap.builder();
    private static int countEntityType2Chromosome = 0;
    private static int countChromosome2GeneLocus = 0;
    private static int countGeneLocus2Gene = 0;
    private static int countEntityType2Trait = 0;

    private RegistryRelations() {
    }

    public static void registerEntityType2Chromosome(class_1299<?> entityType, class_6880<Chromosome> chromosome) {
        try {
            RegistryRelations.getBuilder(entityType2ChromosomeMap, entityType).add(chromosome);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityType2ChromosomeMap", "Map", e);
        }
        ++countEntityType2Chromosome;
    }

    public static void registerEntityType2Chromosome(class_1299<?> entityType, class_6880<Chromosome> chromosome, int remappedIndex) {
        try {
            RegistryRelations.getBuilder(entityType2ChromosomeMap, entityType).add(chromosome);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityType2ChromosomeMap", "Map", e);
        }
        try {
            chromosomeIndexRemapper.put((Object)new RemapKey(entityType, chromosome), remappedIndex);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "chromosomeIndexRemapper", "Object2IntMap", e);
        }
        ++countEntityType2Chromosome;
    }

    public static void registerChromosome2GeneLocus(class_6880<Chromosome> chromosome, class_6880<GeneLocus> geneLocus) {
        try {
            RegistryRelations.getBuilder(chromosome2GeneLocusMap, chromosome).add(geneLocus);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "chromosome2GeneLocusMap", "Map", e);
        }
        ++countChromosome2GeneLocus;
    }

    public static void registerGeneLocus2Gene(class_6880<GeneLocus> geneLocus, class_6880<Gene> gene) {
        try {
            RegistryRelations.getBuilder(geneLocus2GeneMap, geneLocus).add(gene);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "geneLocus2GeneMap", "Map", e);
        }
        ++countGeneLocus2Gene;
    }

    public static void registerEntityType2TraitType(class_1299<?> entityType, class_6880<TraitType> traitType) {
        try {
            RegistryRelations.getBuilder(entityType2TraitTypeMap, entityType).add(traitType);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityType2TraitMap", "Map", e);
        }
        ++countEntityType2Trait;
    }

    public static void registerEntityTypeTag2Chromosome(class_6862<class_1299<?>> entityTypeTag, class_6880<Chromosome> chromosome) {
        try {
            RegistryRelations.getBuilder(entityTypeTag2ChromosomeMap, entityTypeTag).add(chromosome);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityTypeTag2ChromosomeMap", "Map", e);
        }
    }

    public static void registerEntityTypeTag2Chromosome(class_6862<class_1299<?>> entityTypeTag, class_6880<Chromosome> chromosome, int remappedIndex) {
        try {
            RegistryRelations.getBuilder(entityTypeTag2ChromosomeMap, entityTypeTag).add(chromosome);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityTypeTag2ChromosomeMap", "Map", e);
        }
        try {
            taggedChromosomeIndexRemapper.put((Object)new RemapTagKey(entityTypeTag, chromosome), remappedIndex);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "taggedChromosomeIndexRemapper", "Object2IntMap", e);
        }
    }

    public static void registerEntityTypeTag2TraitType(class_6862<class_1299<?>> entityTypeTag, class_6880<TraitType> traitType) {
        try {
            RegistryRelations.getBuilder(entityTypeTag2TraitTypeMap, entityTypeTag).add(traitType);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "entityTypeTag2TraitMap", "Map", e);
        }
    }

    private static <T, R> ImmutableList.Builder<class_6880<R>> getBuilder(Map<T, ImmutableList.Builder<class_6880<R>>> map, T key) {
        if (isFrozen) {
            throw new IllegalStateException("Relations registry is already frozen!");
        }
        return map.computeIfAbsent(key, k -> new ImmutableList.Builder());
    }

    public static void registerDisableRelation(class_6880<Gene> dominant, class_6880<Gene> recessive) {
        AbstractRegisterEntry registerEntry;
        if (isFrozen) {
            throw new IllegalStateException("Relations registry is already frozen!");
        }
        if (dominant instanceof AbstractRegisterEntry) {
            registerEntry = (AbstractRegisterEntry)dominant;
            dominant = registerEntry.asHolder();
        }
        if (recessive instanceof AbstractRegisterEntry) {
            registerEntry = (AbstractRegisterEntry)recessive;
            recessive = registerEntry.asHolder();
        }
        disableRelations.putEdge(dominant, recessive);
    }

    public static void registerGeneFrequency(class_6880<GeneLocus> geneLocus, IWeightedGeneList.Builder entries) {
        if (isFrozen) {
            throw new IllegalStateException("Relations registry is already frozen!");
        }
        geneFrequency.put(geneLocus, (Object)entries.build());
    }

    public static void registerNecessaryChromosomeTypes(class_6880<Chromosome> chromosome, ChromosomeType chromosomeType) {
        if (isFrozen) {
            throw new IllegalStateException("Relations registry is already frozen!");
        }
        try {
            necessaryChromosomeTypes.put(chromosome, (Object)chromosomeType);
        }
        catch (IndexOutOfBoundsException | ConcurrentModificationException e) {
            throw new RegistryConcurrentModificationException(RegistryRelations.class.getName(), "necessaryChromosomeTypes", "Map", e);
        }
    }

    @ApiStatus.Internal
    public static void freezeAndBuild() {
        if (isFrozen) {
            return;
        }
        class_7922 entityTypeRegistry = class_7923.field_41177;
        class_2378 geneRegistry = Objects.requireNonNull((class_2378)class_7923.field_41167.method_10223(CLRegistries.GENES.method_29177()));
        class_2378 geneLocusRegistry = Objects.requireNonNull((class_2378)class_7923.field_41167.method_10223(CLRegistries.GENE_LOCI.method_29177()));
        class_2378 traitRegistry = Objects.requireNonNull((class_2378)class_7923.field_41167.method_10223(CLRegistries.TRAITS.method_29177()));
        RegistryRelations.buildEntityType2ChromosomeRelations(entityTypeRegistry);
        RegistryRelations.buildChromosome2GeneLocusRelations();
        RegistryRelations.buildGeneLocus2GeneRelations();
        RegistryRelations.buildEntityType2TraitRelations(entityTypeRegistry);
        RegistryRelations.checkGeneFrequencyLists((class_2378<GeneLocus>)geneLocusRegistry);
        Chromosome.setNecessaryChromosomeTypes((Map<class_6880<Chromosome>, ChromosomeType>)necessaryChromosomeTypes.build());
        RegistryRelations.buildTraitType2TraitsReversedRelations((class_2378<Trait>)traitRegistry);
        RegistryRelations.buildGeneTopologicalOrder((class_2378<Gene>)geneRegistry);
        isFrozen = true;
        CLLogger.info("Register successfully. Relations registry is frozen.");
    }

    private static void checkGeneFrequencyLists(class_2378<GeneLocus> geneLocusRegistry) {
        Set baseline = geneLocusRegistry.method_40270().collect(Collectors.toCollection(AbstractRegisterEntry::newHolderTreeSet));
        ImmutableMap geneFrequencyLists = geneFrequency.build();
        geneFrequencyLists.forEach((geneLocus, list) -> {
            Set set = Objects.requireNonNull(((GeneLocus)geneLocus.comp_349()).genes).method_40239().collect(Collectors.toCollection(AbstractRegisterEntry::newHolderTreeSet));
            list.allGenes().forEach(gene -> {
                if (!set.remove(gene)) {
                    throw new InvalidGeneFromGeneLocusException((class_6880<Gene>)gene, (class_6880<GeneLocus>)geneLocus);
                }
            });
            if (!set.isEmpty()) {
                throw new GeneFrequencyNotPresentException(set, (class_6880<GeneLocus>)geneLocus);
            }
            baseline.remove(geneLocus);
        });
        baseline.forEach(geneLocus -> {
            GeneLocus value = (GeneLocus)geneLocus.comp_349();
            if (value.genes != null && value.genes.method_40247() != 0) {
                throw new GeneFrequencyNotPresentException(value.genes.method_40239().collect(Collectors.toCollection(Sets::newIdentityHashSet)), (class_6880<GeneLocus>)geneLocus);
            }
        });
        GeneLocus.setGeneFrequency((Map<class_6880<GeneLocus>, IWeightedGeneList>)geneFrequencyLists);
    }

    private static void buildEntityType2TraitRelations(class_2378<class_1299<?>> entityTypeRegistry) {
        CLLogger.info("Extracting {} EntityType tags for EntityType to Trait Type relations...", entityTypeTag2TraitTypeMap.size());
        entityTypeTag2TraitTypeMap.forEach((tag, builder) -> {
            ImmutableList traitTypes = builder.build();
            class_7923.field_41177.method_40266(tag).ifPresent(entries -> entries.forEach(holder -> holder.method_40230().ifPresent(entityTypeKey -> {
                class_1299 entityType = (class_1299)entityTypeRegistry.method_29107(entityTypeKey);
                if (entityType != null) {
                    RegistryRelations.getBuilder(entityType2TraitTypeMap, entityType).addAll((Iterable)traitTypes);
                    countEntityType2Trait += traitTypes.size();
                }
            })));
        });
        entityTypeTag2TraitTypeMap.clear();
        entityType2TraitTypeMap.forEach((entityType, builder) -> {
            ImmutableList traitTypes = builder.build();
            if (entityType instanceof IChromosomeLibEntityType) {
                IChromosomeLibEntityType clEntityType = (IChromosomeLibEntityType)entityType;
                clEntityType.chromosomelib$setTraitTypes((class_6885<TraitType>)class_6885.method_40242((List)traitTypes));
            }
        });
        CLLogger.info("Registered {} EntityType to TraitType relations from {} EntityTypes.", countEntityType2Trait, entityType2TraitTypeMap.size());
    }

    private static void buildGeneLocus2GeneRelations() {
        geneLocus2GeneMap.forEach((geneLocusHolder, builder) -> {
            GeneLocus geneLocus = (GeneLocus)geneLocusHolder.comp_349();
            ImmutableList genes = builder.build();
            geneLocus.genes = class_6885.method_40242((List)genes);
            genes.forEach(geneHolder -> {
                ((Gene)geneHolder.comp_349()).geneLocus = class_6880.method_40223((Object)geneLocus);
            });
        });
        CLLogger.info("Registered {} GeneLocus to Gene relations from {} GeneLoci.", countGeneLocus2Gene, geneLocus2GeneMap.size());
    }

    private static void buildChromosome2GeneLocusRelations() {
        chromosome2GeneLocusMap.forEach((chromosomeHolder, builder) -> {
            Chromosome chromosome = (Chromosome)chromosomeHolder.comp_349();
            ImmutableList geneLoci = builder.build();
            Int2ObjectOpenHashMap leftGeneLocusMap = new Int2ObjectOpenHashMap();
            Int2ObjectOpenHashMap rightGeneLocusMap = new Int2ObjectOpenHashMap();
            for (class_6880 geneLocusHolder : geneLoci) {
                class_6880 old;
                GeneLocus geneLocus = (GeneLocus)geneLocusHolder.comp_349();
                int leftIndex = geneLocus.index(ChromosomeType.LEFT);
                int rightIndex = geneLocus.index(ChromosomeType.RIGHT);
                if (leftIndex >= 0 && (old = (class_6880)leftGeneLocusMap.put(leftIndex, (Object)geneLocusHolder)) != null) {
                    throw new IllegalStateException("GeneLocus conflict at left side, index " + leftIndex + "for chromosome " + String.valueOf(chromosomeHolder) + ". Registered " + String.valueOf(old.method_40230().orElse(null)) + " and " + String.valueOf(geneLocusHolder.method_40230().orElse(null)) + ".");
                }
                if (rightIndex < 0 || (old = (class_6880)rightGeneLocusMap.put(rightIndex, (Object)geneLocusHolder)) == null) continue;
                throw new IllegalStateException("GeneLocus conflict at right side, index " + rightIndex + "for chromosome " + String.valueOf(chromosomeHolder) + ". Registered " + String.valueOf(old.method_40230().orElse(null)) + " and " + String.valueOf(geneLocusHolder.method_40230().orElse(null)) + ".");
            }
            chromosome.maintain((Int2ObjectMap<class_6880<GeneLocus>>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)leftGeneLocusMap), (Int2ObjectMap<class_6880<GeneLocus>>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)rightGeneLocusMap));
        });
        CLLogger.info("Registered {} Chromosome to GeneLocus relations from {} Chromosomes.", countChromosome2GeneLocus, chromosome2GeneLocusMap.size());
    }

    private static void buildEntityType2ChromosomeRelations(class_2378<class_1299<?>> entityTypeRegistry) {
        CLLogger.info("Extracting {} EntityType tags for Chromosome index remapper...", taggedChromosomeIndexRemapper.size());
        taggedChromosomeIndexRemapper.forEach((remapTagKey, remappedIndex) -> class_7923.field_41177.method_40266(remapTagKey.entityTypeTag()).ifPresent(entries -> entries.forEach(holder -> holder.method_40230().ifPresent(entityTypeKey -> {
            class_1299 entityType = (class_1299)entityTypeRegistry.method_29107(entityTypeKey);
            if (entityType != null) {
                chromosomeIndexRemapper.put((Object)new RemapKey(entityType, remapTagKey.chromosome()), remappedIndex.intValue());
            }
        }))));
        taggedChromosomeIndexRemapper.clear();
        CLLogger.info("Extracting {} EntityType tags for EntityType to Chromosome relations...", entityTypeTag2ChromosomeMap.size());
        entityTypeTag2ChromosomeMap.forEach((tag, builder) -> {
            ImmutableList chromosomes = builder.build();
            class_7923.field_41177.method_40266(tag).ifPresent(entries -> entries.forEach(holder -> holder.method_40230().ifPresent(entityTypeKey -> {
                class_1299 entityType = (class_1299)entityTypeRegistry.method_29107(entityTypeKey);
                if (entityType != null) {
                    RegistryRelations.getBuilder(entityType2ChromosomeMap, entityType).addAll((Iterable)chromosomes);
                    countEntityType2Chromosome += chromosomes.size();
                }
            })));
        });
        entityTypeTag2ChromosomeMap.clear();
        entityType2ChromosomeMap.forEach((entityType, builder) -> {
            ImmutableList chromosomes = builder.build();
            Int2ObjectOpenHashMap chromosomeMap = new Int2ObjectOpenHashMap();
            for (class_6880 chromosomeHolder : chromosomes) {
                class_6880 old;
                Chromosome chromosome = (Chromosome)chromosomeHolder.comp_349();
                int index = chromosomeIndexRemapper.getInt((Object)new RemapKey((class_1299<?>)entityType, (class_6880<Chromosome>)chromosomeHolder));
                if (index < 0) {
                    index = chromosome.index();
                }
                if ((old = (class_6880)chromosomeMap.put(index, (Object)chromosomeHolder)) == null) continue;
                throw new IllegalStateException("Chromosome conflict at index " + chromosome.index() + " for entity type " + String.valueOf(entityType) + ". Registered " + String.valueOf(old.method_40230().orElse(null)) + " and " + String.valueOf(chromosomeHolder.method_40230().orElse(null)) + ".");
            }
            if (entityType instanceof IChromosomeLibEntityType) {
                IChromosomeLibEntityType clEntityType = (IChromosomeLibEntityType)entityType;
                clEntityType.chromosomelib$setChromosomes((Int2ObjectMap<class_6880<Chromosome>>)chromosomeMap);
            }
        });
        CLLogger.info("Registered {} EntityType to Chromosome relations from {} EntityTypes.", countEntityType2Chromosome, entityType2ChromosomeMap.size());
    }

    private static void buildTraitType2TraitsReversedRelations(class_2378<Trait> traitRegistry) {
        ListMultimap traitType2TraitsMap = Multimaps.newListMultimap((Map)Maps.newIdentityHashMap(), Lists::newArrayList);
        traitRegistry.method_40270().forEach(traitHolder -> traitType2TraitsMap.put(((Trait)traitHolder.comp_349()).getType(), traitHolder));
        for (class_6880 traitTypeHolder : traitType2TraitsMap.keySet()) {
            ((TraitType)traitTypeHolder.comp_349()).setValues((class_6885<Trait>)class_6885.method_40242((List)traitType2TraitsMap.get((Object)traitTypeHolder)));
        }
    }

    private static void buildGeneTopologicalOrder(class_2378<Gene> geneRegistry) {
        geneRegistry.method_40295().forEach(arg_0 -> disableRelations.addNode(arg_0));
        ImmutableGraph geneGraph = disableRelations.build();
        Object2IntRBTreeMap degrees = new Object2IntRBTreeMap(Comparator.comparingInt(Object::hashCode));
        ArrayDeque queue = Queues.newArrayDeque();
        for (class_6880 gene : geneGraph.nodes()) {
            int degree;
            if (gene instanceof AbstractRegisterEntry) {
                AbstractRegisterEntry registerEntry = (AbstractRegisterEntry)gene;
                gene = registerEntry.asHolder();
            }
            if ((degree = geneGraph.inDegree((Object)gene)) == 0) {
                queue.add(gene);
                ((Gene)gene.comp_349()).topologicalOrder = 0;
            }
            degrees.put(gene, degree);
        }
        while (!queue.isEmpty()) {
            class_6880 gene = (class_6880)queue.poll();
            for (class_6880 neighbor : geneGraph.successors((Object)gene)) {
                int degree = degrees.getInt((Object)neighbor) - 1;
                degrees.put((Object)neighbor, degree);
                if (degree != 0) continue;
                queue.add(neighbor);
                ((Gene)neighbor.comp_349()).topologicalOrder = ((Gene)gene.comp_349()).topologicalOrder + 1;
            }
        }
        ArrayList cyclicGenes = Lists.newArrayList();
        for (class_6880 gene : geneGraph.nodes()) {
            if (degrees.getInt((Object)gene) == 0) continue;
            cyclicGenes.add(gene);
        }
        if (!cyclicGenes.isEmpty()) {
            throw new IllegalStateException("Cyclic gene relations detected: " + String.valueOf(cyclicGenes));
        }
        Gene.setDisableRelationship((ImmutableGraph<class_6880<Gene>>)geneGraph);
    }

    static {
        chromosomeIndexRemapper.defaultReturnValue(-1);
    }

    private record RemapKey(class_1299<?> entityType, class_6880<Chromosome> chromosome) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RemapKey) {
                RemapKey other = (RemapKey)obj;
                return this.entityType == other.entityType && AbstractRegisterEntry.equals(this.chromosome, other.chromosome);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entityType.hashCode() + AbstractRegisterEntry.hashCode(this.chromosome);
        }
    }

    private record RemapTagKey(class_6862<class_1299<?>> entityTypeTag, class_6880<Chromosome> chromosome) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RemapTagKey) {
                RemapTagKey other = (RemapTagKey)obj;
                return this.entityTypeTag.equals(other.entityTypeTag) && AbstractRegisterEntry.equals(this.chromosome, other.chromosome);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entityTypeTag.hashCode() + AbstractRegisterEntry.hashCode(this.chromosome);
        }
    }
}

