/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.chromosomelib.registry;

import com.google.common.collect.ImmutableList;
import com.hexagram2021.chromosomelib.common.gene.Gene;
import com.hexagram2021.chromosomelib.registry.IWeightedGeneList;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.class_6880;

public class SimpleWeightedGeneList
implements IWeightedGeneList {
    protected final ImmutableList<IWeightedGeneList.Entry> entries;
    protected final IntList weightPrefixSums;
    protected final int totalWeight;

    protected SimpleWeightedGeneList(ImmutableList<IWeightedGeneList.Entry> entries) {
        this.entries = entries;
        ImmutableList.Builder wpsBuilder = ImmutableList.builder();
        int temp = 0;
        for (int i = 0; i < entries.size(); ++i) {
            wpsBuilder.add((Object)(temp += ((IWeightedGeneList.Entry)entries.get(i)).weight()));
        }
        this.weightPrefixSums = new IntImmutableList((Collection)wpsBuilder.build());
        this.totalWeight = temp;
    }

    @Override
    public class_6880<Gene> getRandomGene(IWeightedGeneList.Context context) {
        return ((IWeightedGeneList.Entry)this.entries.get(IWeightedGeneList.upperBound(this.weightPrefixSums, context.random().method_43048(this.totalWeight)))).gene();
    }

    @Override
    public int totalWeight(IWeightedGeneList.Context context) {
        return this.totalWeight;
    }

    @Override
    public Stream<class_6880<Gene>> allGenes() {
        return this.entries.stream().map(IWeightedGeneList.Entry::gene).distinct();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void unusedMain(String[] args) {
        int[] a = new int[]{1, 6, 8, 12, 15, 17, 20};
        int u = IWeightedGeneList.upperBound(IntList.of((int[])a), 5);
        System.out.printf("a[%d] = %d%n", u, a[u]);
        u = IWeightedGeneList.upperBound(IntList.of((int[])a), 16);
        System.out.printf("a[%d] = %d%n", u, a[u]);
        u = IWeightedGeneList.upperBound(IntList.of((int[])a), 25);
        try {
            System.out.printf("a[%d] = %d%n", u, a[u]);
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            System.out.printf("Out of bounds %d%n", u);
        }
        u = IWeightedGeneList.upperBound(IntList.of((int[])a), 12);
        System.out.printf("a[%d] = %d%n", u, a[u]);
        int[] b = new int[]{1, 3, 3, 3, 3, 3, 20};
        u = IWeightedGeneList.upperBound(IntList.of((int[])b), 3);
        System.out.printf("b[%d] = %d%n", u, b[u]);
        u = IWeightedGeneList.upperBound(IntList.of((int[])b), 2);
        System.out.printf("b[%d] = %d%n", u, b[u]);
    }

    public static class Builder
    extends IWeightedGeneList.Builder {
        @Override
        SimpleWeightedGeneList build() {
            return new SimpleWeightedGeneList((ImmutableList<IWeightedGeneList.Entry>)this.shadowed.build());
        }
    }
}

