/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.GolemFarmingManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class GolemConstructionListener
implements Listener {
    private final JavaPlugin plugin;
    private final GolemFarmingManager farmingManager;

    public GolemConstructionListener(JavaPlugin plugin, GolemFarmingManager farmingManager) {
        this.plugin = plugin;
        this.farmingManager = farmingManager;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block placedBlock = event.getBlock();
        Player player = event.getPlayer();
        if (placedBlock.getType() == Material.CARVED_PUMPKIN && this.isValidFarmerGolemStructure(placedBlock)) {
            this.spawnFarmerGolem(placedBlock, player);
        }
    }

    private boolean isValidFarmerGolemStructure(Block pumpkinBlock) {
        Location pumpkinLoc = pumpkinBlock.getLocation();
        Block middleBlock = pumpkinLoc.subtract(0.0, 1.0, 0.0).getBlock();
        if (middleBlock.getType() != Material.HAY_BLOCK) {
            return false;
        }
        Block bottomBlock = middleBlock.getLocation().subtract(0.0, 1.0, 0.0).getBlock();
        return bottomBlock.getType() == Material.HAY_BLOCK;
    }

    private void spawnFarmerGolem(Block pumpkinBlock, Player player) {
        Location pumpkinLoc = pumpkinBlock.getLocation();
        Location middleLoc = pumpkinLoc.clone().subtract(0.0, 1.0, 0.0);
        Location bottomLoc = pumpkinLoc.clone().subtract(0.0, 2.0, 0.0);
        pumpkinBlock.setType(Material.AIR);
        middleLoc.getBlock().setType(Material.AIR);
        bottomLoc.getBlock().setType(Material.AIR);
        Location spawnLoc = bottomLoc.add(0.5, 0.0, 0.5);
        IronGolem golem = (IronGolem)pumpkinLoc.getWorld().spawn(spawnLoc, IronGolem.class);
        golem.setCustomName("\u00a76Crop Golem");
        golem.setCustomNameVisible(true);
        golem.setPlayerCreated(true);
        golem.setPersistent(true);
        this.farmingManager.registerFarmerGolem(golem);
        this.playSpawnEffects(spawnLoc);
        player.sendMessage("\u00a76\u2728 You have created a Crop Golem! It will help tend to your crops.");
        this.plugin.getLogger().info("Player " + player.getName() + " created a Farmer Golem at " + spawnLoc.getBlockX() + ", " + spawnLoc.getBlockY() + ", " + spawnLoc.getBlockZ());
    }

    private void playSpawnEffects(Location location) {
        location.getWorld().playSound(location, Sound.BLOCK_ANVIL_USE, 1.0f, 1.2f);
        location.getWorld().playSound(location, Sound.ENTITY_IRON_GOLEM_HURT, 0.8f, 0.8f);
        location.getWorld().spawnParticle(Particle.FIREWORK, location.add(0.0, 1.0, 0.0), 20, 0.5, 1.0, 0.5, 0.1);
        location.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, location, 15, 1.0, 1.0, 1.0, 0.0);
        location.getWorld().spawnParticle(Particle.END_ROD, location, 10, 0.3, 0.5, 0.3, 0.05);
    }
}

