/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.IronGolem;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class GolemFarmingManager {
    private final JavaPlugin plugin;
    private BukkitTask farmingTask;
    private final Map<UUID, FarmerGolemData> farmerGolems = new HashMap<UUID, FarmerGolemData>();
    private static final int DETECTION_RADIUS = 15;
    private static final int FARMING_COOLDOWN_SECONDS = 30;
    private static final int CHEST_SEARCH_RADIUS = 15;
    private static final long TASK_INTERVAL = 20L;
    private static final Map<Material, Material> CROP_TO_SEED = Map.of(Material.WHEAT, Material.WHEAT_SEEDS, Material.CARROTS, Material.CARROT, Material.POTATOES, Material.POTATO, Material.BEETROOTS, Material.BEETROOT_SEEDS, Material.NETHER_WART, Material.NETHER_WART);
    private static final Map<Material, ItemStack[]> CROP_YIELDS = Map.of(Material.WHEAT, new ItemStack[]{new ItemStack(Material.WHEAT, 1), new ItemStack(Material.WHEAT_SEEDS, 1)}, Material.CARROTS, new ItemStack[]{new ItemStack(Material.CARROT, ThreadLocalRandom.current().nextInt(1, 4))}, Material.POTATOES, new ItemStack[]{new ItemStack(Material.POTATO, ThreadLocalRandom.current().nextInt(1, 4))}, Material.BEETROOTS, new ItemStack[]{new ItemStack(Material.BEETROOT, 1), new ItemStack(Material.BEETROOT_SEEDS, 1)}, Material.NETHER_WART, new ItemStack[]{new ItemStack(Material.NETHER_WART, ThreadLocalRandom.current().nextInt(2, 5))});

    public GolemFarmingManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerFarmerGolem(IronGolem golem) {
        FarmerGolemData data = new FarmerGolemData(golem);
        data.farmCenter = golem.getLocation().clone();
        golem.setAI(true);
        this.farmerGolems.put(golem.getUniqueId(), data);
        this.plugin.getLogger().info("Registered farmer golem: " + String.valueOf(golem.getUniqueId()) + " at farm center: " + data.farmCenter.getBlockX() + ", " + data.farmCenter.getBlockZ());
    }

    public void startFarmingTask() {
        this.farmingTask = new BukkitRunnable(){

            public void run() {
                GolemFarmingManager.this.processFarmerGolems();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void stopFarmingTask() {
        if (this.farmingTask != null) {
            this.farmingTask.cancel();
        }
        this.farmerGolems.clear();
    }

    private void processFarmerGolems() {
        this.cleanupInvalidGolems();
        for (FarmerGolemData golemData : this.farmerGolems.values()) {
            this.processGolem(golemData);
        }
    }

    private void processGolem(FarmerGolemData golemData) {
        IronGolem golem = golemData.golem;
        if (!golem.isValid() || golem.isDead()) {
            return;
        }
        this.checkActivityAndForceWork(golemData);
        this.enforceAreaBounds(golemData);
        this.manageAIState(golemData);
        this.showConstantParticles(golem);
        switch (golemData.currentState.ordinal()) {
            case 0: {
                this.handleIdleState(golemData);
                break;
            }
            case 1: {
                this.handleFarmingState(golemData);
                break;
            }
            case 2: {
                this.handleDepositingState(golemData);
                break;
            }
            case 3: {
                this.handleCooldownState(golemData);
            }
        }
    }

    private Location findSafeLocationNear(Location center, int radius) {
        World world = center.getWorld();
        if (world == null) {
            return null;
        }
        for (int attempts = 0; attempts < 10; ++attempts) {
            Location candidate = center.clone().add((double)ThreadLocalRandom.current().nextInt(-radius, radius + 1), 0.0, (double)ThreadLocalRandom.current().nextInt(-radius, radius + 1));
            candidate.setY((double)(world.getHighestBlockYAt(candidate) + 1));
            Block groundBlock = candidate.getBlock().getRelative(0, -1, 0);
            Block airBlock = candidate.getBlock();
            Block airAbove = candidate.getBlock().getRelative(0, 1, 0);
            if (!groundBlock.getType().isSolid() || airBlock.getType() != Material.AIR || airAbove.getType() != Material.AIR) continue;
            return candidate;
        }
        return center.clone();
    }

    private void manageAIState(FarmerGolemData golemData) {
        IronGolem golem = golemData.golem;
        switch (golemData.currentState.ordinal()) {
            case 0: {
                if (golem.hasAI()) break;
                golem.setAI(true);
                break;
            }
            case 1: {
                if (golem.hasAI()) break;
                golem.setAI(true);
                break;
            }
            case 2: {
                if (golem.hasAI()) break;
                golem.setAI(true);
                break;
            }
            case 3: {
                if (!golem.hasAI()) break;
                golem.setAI(false);
            }
        }
    }

    private void checkActivityAndForceWork(FarmerGolemData golemData) {
        long currentTime = System.currentTimeMillis();
        long timeSinceActivity = currentTime - golemData.lastActivityTime;
        if (timeSinceActivity > 60000L) {
            IronGolem golem = golemData.golem;
            this.plugin.getLogger().info("Golem " + String.valueOf(golem.getUniqueId()) + " has been inactive for " + timeSinceActivity / 1000L + " seconds. Forcing work.");
            golemData.currentState = GolemState.IDLE;
            golemData.targetCrop = null;
            golemData.targetLocation = null;
            golemData.cooldownEndTime = 0L;
            if (!golem.hasAI()) {
                golem.setAI(true);
            }
            this.forceGolemToWork(golemData);
            golemData.lastActivityTime = currentTime;
        }
    }

    private void forceGolemToWork(FarmerGolemData golemData) {
        Location safeLocation;
        Block nearestChest;
        IronGolem golem = golemData.golem;
        if (!golemData.inventory.isEmpty() && (nearestChest = this.findNearestChest(golem.getLocation())) != null) {
            golemData.currentState = GolemState.DEPOSITING;
            golemData.targetLocation = nearestChest.getLocation().add(0.5, 0.0, 0.5);
            this.navigateGolemToLocation(golem, golemData.targetLocation);
            this.showStateParticles(golem, GolemState.DEPOSITING);
            this.plugin.getLogger().info("Forced golem " + String.valueOf(golem.getUniqueId()) + " to deposit items");
            return;
        }
        Block targetCrop = this.findNearbyMatureCrop(golem.getLocation());
        if (targetCrop != null) {
            golemData.currentState = GolemState.FARMING;
            golemData.targetLocation = targetCrop.getLocation().add(0.5, 0.0, 0.5);
            golemData.targetCrop = targetCrop;
            this.navigateGolemToLocation(golem, golemData.targetLocation);
            this.showStateParticles(golem, GolemState.FARMING);
            this.plugin.getLogger().info("Forced golem " + String.valueOf(golem.getUniqueId()) + " to farm crops");
            return;
        }
        if (golemData.farmCenter != null && (safeLocation = this.findSafeLocationNear(golemData.farmCenter, 3)) != null) {
            golem.teleport(safeLocation);
            this.plugin.getLogger().info("Teleported inactive golem " + String.valueOf(golem.getUniqueId()) + " to farm center to look for work");
        }
    }

    private void enforceAreaBounds(FarmerGolemData golemData) {
        Location safeLocation;
        IronGolem golem = golemData.golem;
        Location farmCenter = golemData.farmCenter;
        if (farmCenter == null) {
            golemData.farmCenter = golem.getLocation().clone();
            return;
        }
        double distance = golem.getLocation().distance(farmCenter);
        if (distance > 12.0 && (safeLocation = this.findSafeLocationNear(farmCenter, 8)) != null) {
            golem.teleport(safeLocation);
            safeLocation.getWorld().spawnParticle(Particle.PORTAL, safeLocation.add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.0);
            safeLocation.getWorld().playSound(safeLocation, Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f, 1.2f);
            this.plugin.getLogger().info("Teleported golem " + String.valueOf(golem.getUniqueId()) + " back to farm area (was " + String.format("%.1f", distance) + " blocks away)");
        }
    }

    private void handleIdleState(FarmerGolemData golemData) {
        Block nearestChest;
        IronGolem golem = golemData.golem;
        if (!golemData.inventory.isEmpty() && (nearestChest = this.findNearestChest(golem.getLocation())) != null) {
            golemData.currentState = GolemState.DEPOSITING;
            golemData.targetLocation = nearestChest.getLocation().add(0.5, 0.0, 0.5);
            this.navigateGolemToLocation(golem, golemData.targetLocation);
            this.showStateParticles(golem, GolemState.DEPOSITING);
            return;
        }
        Block targetCrop = this.findNearbyMatureCrop(golem.getLocation());
        if (targetCrop != null) {
            golemData.currentState = GolemState.FARMING;
            golemData.targetLocation = targetCrop.getLocation().add(0.5, 0.0, 0.5);
            golemData.targetCrop = targetCrop;
            this.navigateGolemToLocation(golem, golemData.targetLocation);
            this.showStateParticles(golem, GolemState.FARMING);
            golem.getWorld().playSound(golem.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.7f, 1.2f);
        } else {
            this.wanderNearCrops(golem);
        }
    }

    private void handleFarmingState(FarmerGolemData golemData) {
        IronGolem golem = golemData.golem;
        if (golemData.targetCrop == null || !this.isMatureCrop(golemData.targetCrop)) {
            golemData.currentState = GolemState.IDLE;
            golemData.targetCrop = null;
            golemData.targetLocation = null;
            return;
        }
        if (golem.getLocation().distance(golemData.targetLocation) <= 2.0) {
            this.harvestCrop(golemData);
        }
    }

    private void handleDepositingState(FarmerGolemData golemData) {
        IronGolem golem = golemData.golem;
        if (golemData.targetLocation == null) {
            golemData.currentState = GolemState.IDLE;
            return;
        }
        double distance = golem.getLocation().distance(golemData.targetLocation);
        if (distance <= 5.0) {
            this.depositItems(golemData);
        } else if (distance <= 2.0) {
            this.depositItems(golemData);
        }
    }

    private void handleCooldownState(FarmerGolemData golemData) {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= golemData.cooldownEndTime) {
            golemData.currentState = GolemState.IDLE;
            golemData.cooldownEndTime = 0L;
            IronGolem golem = golemData.golem;
            if (!golem.hasAI()) {
                golem.setAI(true);
            }
            golem.getWorld().playSound(golem.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        } else {
            this.showCooldownParticles(golemData.golem);
        }
    }

    private void harvestCrop(FarmerGolemData golemData) {
        ItemStack[] yield;
        Block cropBlock = golemData.targetCrop;
        Material cropType = cropBlock.getType();
        for (ItemStack item : yield = this.getCropYield(cropType)) {
            golemData.inventory.add(item);
        }
        this.replantCrop(cropBlock, cropType);
        this.playHarvestEffects(cropBlock.getLocation());
        golemData.lastActivityTime = System.currentTimeMillis();
        IronGolem golem = golemData.golem;
        Block nearestChest = this.findNearestChest(golem.getLocation());
        if (nearestChest != null) {
            golemData.currentState = GolemState.DEPOSITING;
            golemData.targetLocation = nearestChest.getLocation().add(0.5, 0.0, 0.5);
            this.navigateGolemToLocation(golem, golemData.targetLocation);
            this.showStateParticles(golem, GolemState.DEPOSITING);
        } else {
            golemData.currentState = GolemState.COOLDOWN;
            golemData.cooldownEndTime = System.currentTimeMillis() + 30000L;
        }
        golemData.targetCrop = null;
        golemData.targetLocation = null;
        this.plugin.getLogger().info("Golem " + String.valueOf(golemData.golem.getUniqueId()) + " harvested " + cropType.name());
    }

    private void depositItems(FarmerGolemData golemData) {
        IronGolem golem = golemData.golem;
        Block chestBlock = golemData.targetLocation.getBlock();
        BlockState blockState = chestBlock.getState();
        if (!(blockState instanceof Chest)) {
            golemData.currentState = GolemState.IDLE;
            golemData.targetLocation = null;
            return;
        }
        Chest chest = (Chest)blockState;
        Inventory chestInventory = chest.getInventory();
        ArrayList remainingItems = new ArrayList();
        for (ItemStack item : golemData.inventory) {
            HashMap leftover = chestInventory.addItem(new ItemStack[]{item});
            if (leftover.isEmpty()) continue;
            remainingItems.addAll(leftover.values());
        }
        golemData.inventory.clear();
        golemData.inventory.addAll(remainingItems);
        golemData.lastActivityTime = System.currentTimeMillis();
        this.showRemoteDepositEffects(golem.getLocation(), golemData.targetLocation);
        golemData.currentState = GolemState.COOLDOWN;
        golemData.cooldownEndTime = System.currentTimeMillis() + 30000L;
        golemData.targetLocation = null;
        this.plugin.getLogger().info("Golem " + String.valueOf(golem.getUniqueId()) + " deposited items remotely");
    }

    private Block findNearbyMatureCrop(Location golemLocation) {
        World world = golemLocation.getWorld();
        if (world == null) {
            return null;
        }
        ArrayList<Block> candidates = new ArrayList<Block>();
        int x = golemLocation.getBlockX();
        int y = golemLocation.getBlockY();
        int z = golemLocation.getBlockZ();
        for (int dx = -15; dx <= 15; ++dx) {
            for (int dy = -15; dy <= 15; ++dy) {
                for (int dz = -15; dz <= 15; ++dz) {
                    Block block = world.getBlockAt(x + dx, y + dy, z + dz);
                    if (!this.isMatureCrop(block)) continue;
                    candidates.add(block);
                }
            }
        }
        if (!candidates.isEmpty()) {
            candidates.sort((a, b) -> Double.compare(a.getLocation().distance(golemLocation), b.getLocation().distance(golemLocation)));
            return (Block)candidates.get(0);
        }
        return null;
    }

    private Block findNearestChest(Location golemLocation) {
        World world = golemLocation.getWorld();
        if (world == null) {
            return null;
        }
        Block nearestChest = null;
        double nearestDistance = Double.MAX_VALUE;
        int x = golemLocation.getBlockX();
        int y = golemLocation.getBlockY();
        int z = golemLocation.getBlockZ();
        for (int dx = -15; dx <= 15; ++dx) {
            for (int dy = -15; dy <= 15; ++dy) {
                for (int dz = -15; dz <= 15; ++dz) {
                    double distance;
                    Block block = world.getBlockAt(x + dx, y + dy, z + dz);
                    if (block.getType() != Material.CHEST && block.getType() != Material.BARREL || !((distance = block.getLocation().distance(golemLocation)) < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearestChest = block;
                }
            }
        }
        return nearestChest;
    }

    private boolean isMatureCrop(Block block) {
        Material material = block.getType();
        if (!CROP_TO_SEED.containsKey(material)) {
            return false;
        }
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return false;
    }

    private ItemStack[] getCropYield(Material cropType) {
        ItemStack[] baseYield = CROP_YIELDS.get(cropType);
        if (baseYield == null) {
            return new ItemStack[]{new ItemStack(cropType, 1)};
        }
        ItemStack[] yield = new ItemStack[baseYield.length];
        for (int i = 0; i < baseYield.length; ++i) {
            ItemStack original = baseYield[i];
            yield[i] = original.getType() == Material.CARROT || original.getType() == Material.POTATO || original.getType() == Material.NETHER_WART ? new ItemStack(original.getType(), ThreadLocalRandom.current().nextInt(1, 4)) : original.clone();
        }
        return yield;
    }

    private void replantCrop(Block cropBlock, Material cropType) {
        BlockData blockData = cropBlock.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            ageable.setAge(0);
            cropBlock.setBlockData((BlockData)ageable);
        }
    }

    private void navigateGolemToLocation(IronGolem golem, Location target) {
        golem.getPathfinder().moveTo(target, 0.8);
    }

    private void wanderNearCrops(IronGolem golem) {
        FarmerGolemData golemData = this.farmerGolems.get(golem.getUniqueId());
        if (golemData == null || golemData.farmCenter == null) {
            return;
        }
        if (ThreadLocalRandom.current().nextInt(0, 120) == 0) {
            Location farmCenter = golemData.farmCenter;
            Block nearbyCrop = this.findNearbyCropInBounds(farmCenter);
            if (nearbyCrop != null) {
                Location cropLoc = nearbyCrop.getLocation();
                Location wanderTarget = cropLoc.clone().add((double)ThreadLocalRandom.current().nextInt(-4, 5), 0.0, (double)ThreadLocalRandom.current().nextInt(-4, 5));
                if (farmCenter.distance(wanderTarget) <= 8.0) {
                    wanderTarget.setY((double)(wanderTarget.getWorld().getHighestBlockYAt(wanderTarget) + 1));
                    Block targetBlock = wanderTarget.getBlock();
                    if (targetBlock.getType() == Material.AIR && targetBlock.getRelative(0, -1, 0).getType().isSolid()) {
                        this.navigateGolemToLocation(golem, wanderTarget);
                    }
                }
            } else {
                Location wanderTarget = farmCenter.clone().add((double)ThreadLocalRandom.current().nextInt(-3, 4), 0.0, (double)ThreadLocalRandom.current().nextInt(-3, 4));
                wanderTarget.setY((double)(wanderTarget.getWorld().getHighestBlockYAt(wanderTarget) + 1));
                Block targetBlock = wanderTarget.getBlock();
                if (targetBlock.getType() == Material.AIR && targetBlock.getRelative(0, -1, 0).getType().isSolid()) {
                    this.navigateGolemToLocation(golem, wanderTarget);
                }
            }
        }
    }

    private Block findNearbyCropInBounds(Location farmCenter) {
        World world = farmCenter.getWorld();
        if (world == null) {
            return null;
        }
        ArrayList<Block> candidates = new ArrayList<Block>();
        int x = farmCenter.getBlockX();
        int y = farmCenter.getBlockY();
        int z = farmCenter.getBlockZ();
        for (int dx = -10; dx <= 10; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                for (int dz = -10; dz <= 10; ++dz) {
                    Block block = world.getBlockAt(x + dx, y + dy, z + dz);
                    if (!this.isAnyCrop(block)) continue;
                    candidates.add(block);
                }
            }
        }
        if (!candidates.isEmpty()) {
            candidates.sort((a, b) -> Double.compare(a.getLocation().distance(farmCenter), b.getLocation().distance(farmCenter)));
            return (Block)candidates.get(0);
        }
        return null;
    }

    private Block findNearbyCrop(Location golemLocation) {
        FarmerGolemData golemData = this.farmerGolems.values().stream().filter(data -> data.golem.getLocation().equals((Object)golemLocation)).findFirst().orElse(null);
        if (golemData != null && golemData.farmCenter != null) {
            return this.findNearbyCropInBounds(golemData.farmCenter);
        }
        World world = golemLocation.getWorld();
        if (world == null) {
            return null;
        }
        ArrayList<Block> candidates = new ArrayList<Block>();
        int x = golemLocation.getBlockX();
        int y = golemLocation.getBlockY();
        int z = golemLocation.getBlockZ();
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -8; dz <= 8; ++dz) {
                    Block block = world.getBlockAt(x + dx, y + dy, z + dz);
                    if (!this.isAnyCrop(block)) continue;
                    candidates.add(block);
                }
            }
        }
        if (!candidates.isEmpty()) {
            candidates.sort((a, b) -> Double.compare(a.getLocation().distance(golemLocation), b.getLocation().distance(golemLocation)));
            return (Block)candidates.get(0);
        }
        return null;
    }

    private boolean isAnyCrop(Block block) {
        Material material = block.getType();
        return CROP_TO_SEED.containsKey(material);
    }

    private void showConstantParticles(IronGolem golem) {
        if (ThreadLocalRandom.current().nextInt(0, 10) == 0) {
            Location loc = golem.getLocation().add(0.0, 1.5, 0.0);
            golem.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, loc, 1, 0.3, 0.3, 0.3, 0.0);
        }
    }

    private void showStateParticles(IronGolem golem, GolemState state) {
        Location loc = golem.getLocation().add(0.0, 2.0, 0.0);
        switch (state.ordinal()) {
            case 1: {
                golem.getWorld().spawnParticle(Particle.COMPOSTER, loc, 5, 0.5, 0.5, 0.5, 0.0);
                break;
            }
            case 2: {
                golem.getWorld().spawnParticle(Particle.END_ROD, loc, 3, 0.3, 0.3, 0.3, 0.02);
            }
        }
    }

    private void showCooldownParticles(IronGolem golem) {
        if (ThreadLocalRandom.current().nextInt(0, 5) == 0) {
            Location loc = golem.getLocation().add(0.0, 1.0, 0.0);
            golem.getWorld().spawnParticle(Particle.SMOKE, loc, 2, 0.3, 0.3, 0.3, 0.01);
        }
    }

    private void playHarvestEffects(Location location) {
        World world = location.getWorld();
        Location effectLoc = location.add(0.5, 0.5, 0.5);
        world.spawnParticle(Particle.HAPPY_VILLAGER, effectLoc, 8, 0.5, 0.5, 0.5, 0.0);
        world.spawnParticle(Particle.COMPOSTER, effectLoc, 5, 0.3, 0.3, 0.3, 0.0);
        world.playSound(effectLoc, Sound.BLOCK_CROP_BREAK, 1.0f, 1.2f);
        world.playSound(effectLoc, Sound.ENTITY_IRON_GOLEM_ATTACK, 0.3f, 1.5f);
    }

    private void playDepositEffects(Location location) {
        World world = location.getWorld();
        Location effectLoc = location.add(0.5, 0.5, 0.5);
        world.spawnParticle(Particle.FIREWORK, effectLoc, 5, 0.3, 0.3, 0.3, 0.05);
        world.spawnParticle(Particle.END_ROD, effectLoc, 8, 0.5, 0.5, 0.5, 0.02);
        world.playSound(effectLoc, Sound.ENTITY_ITEM_PICKUP, 1.0f, 0.8f);
        world.playSound(effectLoc, Sound.BLOCK_CHEST_CLOSE, 0.8f, 1.2f);
    }

    private void showRemoteDepositEffects(Location golemLocation, Location chestLocation) {
        World world = golemLocation.getWorld();
        if (world == null) {
            return;
        }
        Location golemLoc = golemLocation.clone().add(0.0, 1.5, 0.0);
        Location chestLoc = chestLocation.clone().add(0.5, 0.5, 0.5);
        Vector direction = chestLoc.toVector().subtract(golemLoc.toVector());
        double distance = direction.length();
        direction.normalize();
        for (double d = 0.0; d < distance; d += 0.3) {
            Location particleLocation = golemLoc.clone().add(direction.clone().multiply(d));
            world.spawnParticle(Particle.END_ROD, particleLocation, 1, 0.0, 0.0, 0.0, 0.01);
        }
        world.spawnParticle(Particle.FIREWORK, golemLoc, 3, 0.2, 0.2, 0.2, 0.05);
        world.spawnParticle(Particle.FIREWORK, chestLoc, 5, 0.3, 0.3, 0.3, 0.05);
        world.playSound(golemLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 0.3f, 1.5f);
        world.playSound(chestLoc, Sound.ENTITY_ITEM_PICKUP, 1.0f, 0.8f);
        world.playSound(chestLoc, Sound.BLOCK_CHEST_CLOSE, 0.8f, 1.2f);
    }

    private void cleanupInvalidGolems() {
        this.farmerGolems.entrySet().removeIf(entry -> {
            IronGolem golem = ((FarmerGolemData)entry.getValue()).golem;
            return !golem.isValid() || golem.isDead();
        });
    }

    private static class FarmerGolemData {
        final IronGolem golem;
        GolemState currentState;
        Block targetCrop;
        Location targetLocation;
        Location farmCenter;
        long cooldownEndTime;
        long lastActivityTime;
        final List<ItemStack> inventory;

        FarmerGolemData(IronGolem golem) {
            this.golem = golem;
            this.currentState = GolemState.IDLE;
            this.targetCrop = null;
            this.targetLocation = null;
            this.farmCenter = null;
            this.cooldownEndTime = 0L;
            this.lastActivityTime = System.currentTimeMillis();
            this.inventory = new ArrayList<ItemStack>();
        }
    }

    public static enum GolemState {
        IDLE,
        FARMING,
        DEPOSITING,
        COOLDOWN;

    }
}

