/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.protpa;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.List;
import me.bloodred.protpa.commands.CommandHandler;
import me.bloodred.protpa.config.ConfigManager;
import me.bloodred.protpa.listeners.PlayerListener;
import me.bloodred.protpa.managers.CombatManager;
import me.bloodred.protpa.managers.RequestManager;
import me.bloodred.protpa.managers.UserDataManager;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ProTPA
extends JavaPlugin {
    private ConfigManager configManager;
    private RequestManager requestManager;
    private UserDataManager userDataManager;
    private CombatManager combatManager;
    private CommandHandler commandHandler;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.userDataManager = new UserDataManager(this);
        this.combatManager = new CombatManager(this);
        this.requestManager = new RequestManager(this);
        this.commandHandler = new CommandHandler(this);
        this.configManager.loadConfig();
        this.registerPermissions();
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getLogger().info("ProTPA v" + this.getDescription().getVersion() + " has been enabled!");
    }

    public void onDisable() {
        if (this.requestManager != null) {
            this.requestManager.shutdown();
        }
        this.getLogger().info("ProTPA has been disabled!");
    }

    private void registerPermissions() {
        this.registerPermission("protpa.tpa", "Allows access to the /tpa command", PermissionDefault.TRUE);
        this.registerPermission("protpa.tpahere", "Allows access to the /tpahere command", PermissionDefault.TRUE);
        this.registerPermission("protpa.accept", "Allows access to the /tpaccept command", PermissionDefault.TRUE);
        this.registerPermission("protpa.deny", "Allows access to the /tpdeny command", PermissionDefault.TRUE);
        this.registerPermission("protpa.cancel", "Allows access to the /tpcancel command", PermissionDefault.TRUE);
        this.registerPermission("protpa.block", "Allows access to the /tpblock command", PermissionDefault.TRUE);
        this.registerPermission("protpa.autoaccept", "Allows access to the /tpautoaccept command", PermissionDefault.TRUE);
        this.registerPermission("protpa.bypass.cooldown", "Bypass teleport request cooldowns", PermissionDefault.OP);
        this.registerPermission("protpa.bypass.warmup", "Bypass teleport warmup time", PermissionDefault.OP);
        this.registerPermission("protpa.bypass.timeout", "Teleport requests never timeout", PermissionDefault.OP);
        this.registerPermission("protpa.bypass.blocked", "Can send requests to players who are blocking", PermissionDefault.OP);
        this.registerPermission("protpa.admin", "Gives access to use /protpa command", PermissionDefault.OP);
        this.registerPermission("protpa.admin.reload", "Reload the plugin configuration", PermissionDefault.OP);
        Permission parentPerm = new Permission("protpa.*", "Gives access to all ProTPA commands", PermissionDefault.OP);
        parentPerm.getChildren().put("protpa.tpa", true);
        parentPerm.getChildren().put("protpa.tpahere", true);
        parentPerm.getChildren().put("protpa.accept", true);
        parentPerm.getChildren().put("protpa.deny", true);
        parentPerm.getChildren().put("protpa.cancel", true);
        parentPerm.getChildren().put("protpa.block", true);
        parentPerm.getChildren().put("protpa.autoaccept", true);
        parentPerm.getChildren().put("protpa.bypass.cooldown", true);
        parentPerm.getChildren().put("protpa.bypass.warmup", true);
        parentPerm.getChildren().put("protpa.bypass.timeout", true);
        parentPerm.getChildren().put("protpa.bypass.blocked", true);
        parentPerm.getChildren().put("protpa.admin", true);
        parentPerm.getChildren().put("protpa.admin.reload", true);
        this.getServer().getPluginManager().addPermission(parentPerm);
    }

    private void registerPermission(String name, String description, PermissionDefault defaultValue) {
        Permission permission = new Permission(name, description, defaultValue);
        this.getServer().getPluginManager().addPermission(permission);
    }

    private void registerCommands() {
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpa").requires(source -> source.getSender().hasPermission("protpa.tpa"))).executes(ctx -> {
                this.commandHandler.executeTPANoArgs(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            })).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
                try {
                    Player targetPlayer = (Player)((List)((PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)ctx.getSource())).getFirst();
                    this.commandHandler.executeTPA(((CommandSourceStack)ctx.getSource()).getSender(), targetPlayer);
                }
                catch (Exception e) {
                    ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(this.getConfigManager().getMessage("playerNotFound", new String[0]));
                }
                return 1;
            }))).build(), "Request to teleport to a player");
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpahere").requires(source -> source.getSender().hasPermission("protpa.tpahere"))).executes(ctx -> {
                this.commandHandler.executeTPAHereNoArgs(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            })).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
                try {
                    Player targetPlayer = (Player)((List)((PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)ctx.getSource())).getFirst();
                    this.commandHandler.executeTPAHere(((CommandSourceStack)ctx.getSource()).getSender(), targetPlayer);
                }
                catch (Exception e) {
                    ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(this.getConfigManager().getMessage("playerNotFound", new String[0]));
                }
                return 1;
            }))).build(), "Request a player to teleport to you");
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpaccept").requires(source -> source.getSender().hasPermission("protpa.accept"))).executes(ctx -> {
                this.commandHandler.executeTPAccept(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            })).build(), "Accept a teleport request");
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpdeny").requires(source -> source.getSender().hasPermission("protpa.deny"))).executes(ctx -> {
                this.commandHandler.executeTPDeny(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            })).build(), "Deny a teleport request");
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpcancel").requires(source -> source.getSender().hasPermission("protpa.cancel"))).executes(ctx -> {
                this.commandHandler.executeTPCancel(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            })).build(), "Cancel your teleport request");
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpblock").requires(source -> source.getSender().hasPermission("protpa.block"))).executes(ctx -> {
                this.commandHandler.executeTPBlock(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            })).build(), "Toggle blocking teleport requests");
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpautoaccept").requires(source -> source.getSender().hasPermission("protpa.autoaccept"))).executes(ctx -> {
                this.commandHandler.executeTPAutoAccept(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            })).build(), "Toggle auto-accepting teleport requests");
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"protpa").executes(ctx -> {
                this.commandHandler.executeTPAhelp(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            })).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.getSender().hasPermission("protpa.admin.reload"))).executes(ctx -> {
                this.commandHandler.executeTPAreload(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            }))).then(((LiteralArgumentBuilder)Commands.literal((String)"help").requires(source -> source.getSender().hasPermission("protpa.admin"))).executes(ctx -> {
                this.commandHandler.executeTPAhelp(((CommandSourceStack)ctx.getSource()).getSender());
                return 1;
            }))).build(), "ProTPA plugin's main command");
        });
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public UserDataManager getUserDataManager() {
        return this.userDataManager;
    }

    public CombatManager getCombatManager() {
        return this.combatManager;
    }
}

