/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.protpa.commands;

import me.bloodred.protpa.ProTPA;
import me.bloodred.protpa.models.TeleportType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler {
    private final ProTPA plugin;

    public CommandHandler(ProTPA plugin) {
        this.plugin = plugin;
    }

    public void executeTPA(CommandSender sender, Player target) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("playersOnly", new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (target == null) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("playerNotFound", new String[0]));
            return;
        }
        if (player.equals((Object)target)) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("cannotTeleportSelf", new String[0]));
            return;
        }
        this.plugin.getRequestManager().sendRequest(player, target, TeleportType.TPA);
    }

    public void executeTPAHere(CommandSender sender, Player target) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("playersOnly", new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (target == null) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("playerNotFound", new String[0]));
            return;
        }
        if (player.equals((Object)target)) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("cannotTeleportSelf", new String[0]));
            return;
        }
        this.plugin.getRequestManager().sendRequest(player, target, TeleportType.TPAHERE);
    }

    public void executeTPANoArgs(CommandSender sender) {
        sender.sendMessage(this.plugin.getConfigManager().getMessage("tpaUsage", new String[0]));
    }

    public void executeTPAHereNoArgs(CommandSender sender) {
        sender.sendMessage(this.plugin.getConfigManager().getMessage("tpahereUsage", new String[0]));
    }

    public void executeTPAccept(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("playersOnly", new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getRequestManager().acceptRequest(player);
    }

    public void executeTPDeny(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("playersOnly", new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getRequestManager().denyRequest(player);
    }

    public void executeTPCancel(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("playersOnly", new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getRequestManager().cancelRequest(player);
    }

    public void executeTPBlock(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("playersOnly", new String[0]));
            return;
        }
        Player player = (Player)sender;
        boolean isBlocking = this.plugin.getUserDataManager().toggleBlocking(player);
        String messageKey = isBlocking ? "blockingEnabled" : "blockingDisabled";
        player.sendMessage(this.plugin.getConfigManager().getMessage(messageKey, new String[0]));
    }

    public void executeTPAutoAccept(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("playersOnly", new String[0]));
            return;
        }
        Player player = (Player)sender;
        boolean isAutoAccepting = this.plugin.getUserDataManager().toggleAutoAccept(player);
        String messageKey = isAutoAccepting ? "autoAcceptEnabled" : "autoAcceptDisabled";
        player.sendMessage(this.plugin.getConfigManager().getMessage(messageKey, new String[0]));
    }

    public void executeTPAreload(CommandSender sender) {
        this.plugin.getConfigManager().reloadConfig();
        sender.sendMessage(this.plugin.getConfigManager().getMessage("configReloaded", new String[0]));
    }

    public void executeTPAhelp(CommandSender sender) {
        sender.sendRichMessage("<#8000FF><bold>ProTPA</bold> <gray>v" + this.plugin.getDescription().getVersion());
        sender.sendRichMessage("");
        sender.sendRichMessage("<yellow><bold>Available Commands:</bold>");
        sender.sendRichMessage("<aqua>/tpa <player></aqua> <gray>- Request to teleport to a player");
        sender.sendRichMessage("<aqua>/tpahere <player></aqua> <gray>- Request a player to teleport to you");
        sender.sendRichMessage("<aqua>/tpaccept</aqua> <gray>- Accept a teleport request");
        sender.sendRichMessage("<aqua>/tpdeny</aqua> <gray>- Deny a teleport request");
        sender.sendRichMessage("<aqua>/tpcancel</aqua> <gray>- Cancel your teleport request");
        sender.sendRichMessage("<aqua>/tpblock</aqua> <gray>- Toggle blocking teleport requests");
        sender.sendRichMessage("<aqua>/tpautoaccept</aqua> <gray>- Toggle auto-accepting teleport requests");
        if (sender.hasPermission("protpa.admin")) {
            sender.sendRichMessage("");
            sender.sendRichMessage("<red><bold>Admin Commands:</bold>");
            sender.sendRichMessage("<light_purple>/protpa help <gray>- Show this help message");
            if (sender.hasPermission("protpa.admin.reload")) {
                sender.sendRichMessage("<light_purple>/protpa reload <gray>- Reload plugin configuration");
            }
        }
        sender.sendRichMessage("");
        sender.sendRichMessage("<green>Plugin by <bold>BloodRed</bold> | Use <yellow>/protpa</yellow> for help");
    }
}

