/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.protpa.config;

import java.util.List;
import me.bloodred.protpa.ProTPA;
import me.bloodred.protpa.config.ConfigUpdater;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ProTPA plugin;
    private FileConfiguration config;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private ConfigUpdater configUpdater;

    public ConfigManager(ProTPA plugin) {
        this.plugin = plugin;
        this.configUpdater = new ConfigUpdater(plugin, "config.yml");
    }

    public void loadConfig() {
        if (this.configUpdater.update()) {
            this.plugin.getLogger().info("Config updated successfully!");
        }
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        if (this.configUpdater.update()) {
            this.plugin.getLogger().info("Config updated successfully!");
        }
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public int getRequestTimeout() {
        return this.config.getInt("tpa.requestTimeout", 60);
    }

    public int getCooldown() {
        return this.config.getInt("tpa.cooldown", 30);
    }

    public int getWarmup() {
        return this.config.getInt("tpa.warmup", 5);
    }

    public boolean isSoundEnabled() {
        return this.config.getBoolean("notifications.sounds.enabled", true);
    }

    public Sound getSendRequestSound() {
        try {
            return Sound.valueOf((String)this.config.getString("notifications.sounds.sendRequest", "ENTITY_EXPERIENCE_ORB_PICKUP"));
        }
        catch (IllegalArgumentException e) {
            return Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
        }
    }

    public Sound getAcceptRequestSound() {
        try {
            return Sound.valueOf((String)this.config.getString("notifications.sounds.acceptRequest", "ENTITY_PLAYER_LEVELUP"));
        }
        catch (IllegalArgumentException e) {
            return Sound.ENTITY_PLAYER_LEVELUP;
        }
    }

    public boolean isParticlesEnabled() {
        return this.config.getBoolean("notifications.particles.enabled", true);
    }

    public boolean isCancelOnMove() {
        return this.config.getBoolean("safety.cancelOnMove", true);
    }

    public boolean isCancelOnDamage() {
        return this.config.getBoolean("safety.cancelOnDamage", true);
    }

    public boolean isBlockTeleportInCombat() {
        return this.config.getBoolean("safety.blockTeleportInCombat", true);
    }

    public List<String> getBlacklistWorlds() {
        return this.config.getStringList("safety.blacklistWorlds");
    }

    public Component getMessage(String key, String ... placeholders) {
        String message = this.config.getString("messages." + key, "&cMessage not found: " + key);
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace("%" + placeholders[i] + "%", placeholders[i + 1]);
        }
        return this.miniMessage.deserialize((Object)("<dark_gray>[<#8000FF><bold>ProTPA</bold><dark_gray>] " + message));
    }

    public boolean isDebug() {
        return this.config.getBoolean("debug", false);
    }
}

