/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.protpa.listeners;

import me.bloodred.protpa.ProTPA;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final ProTPA plugin;

    public PlayerListener(ProTPA plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.plugin.getConfigManager().isCancelOnMove()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getFrom().distance(event.getTo()) > 1.0) {
            this.plugin.getRequestManager().cancelWarmup(player);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!this.plugin.getConfigManager().isCancelOnDamage()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.plugin.getRequestManager().cancelWarmup(player);
    }

    @EventHandler
    public void onPlayerDamageByEntity(EntityDamageByEntityEvent event) {
        if (!this.plugin.getConfigManager().isBlockTeleportInCombat()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player victim = (Player)entity;
            this.plugin.getCombatManager().tagPlayer(victim);
        }
        if ((entity = event.getDamager()) instanceof Player) {
            Player attacker = (Player)entity;
            this.plugin.getCombatManager().tagPlayer(attacker);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getRequestManager().cancelWarmup(player);
        this.plugin.getRequestManager().cancelRequest(player);
        this.plugin.getCombatManager().removeTag(player);
    }
}

