/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.protpa.managers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.bloodred.protpa.ProTPA;
import org.bukkit.entity.Player;

public class CombatManager {
    private final ProTPA plugin;
    private final Map<UUID, Long> combatTags = new ConcurrentHashMap<UUID, Long>();
    private static final long COMBAT_DURATION = 10000L;

    public CombatManager(ProTPA plugin) {
        this.plugin = plugin;
    }

    public void tagPlayer(Player player) {
        this.combatTags.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public boolean isInCombat(Player player) {
        Long tagTime = this.combatTags.get(player.getUniqueId());
        if (tagTime == null) {
            return false;
        }
        return System.currentTimeMillis() - tagTime < 10000L;
    }

    public void removeTag(Player player) {
        this.combatTags.remove(player.getUniqueId());
    }

    public long getRemainingCombatTime(Player player) {
        Long tagTime = this.combatTags.get(player.getUniqueId());
        if (tagTime == null) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - tagTime;
        return Math.max(0L, 10000L - elapsed) / 1000L;
    }
}

