/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.protpa.managers;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.bloodred.protpa.ProTPA;
import me.bloodred.protpa.models.TeleportRequest;
import me.bloodred.protpa.models.TeleportType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RequestManager {
    private final ProTPA plugin;
    private final Map<UUID, TeleportRequest> pendingRequests = new ConcurrentHashMap<UUID, TeleportRequest>();
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, ScheduledTask> warmupTasks = new ConcurrentHashMap<UUID, ScheduledTask>();

    public RequestManager(ProTPA plugin) {
        this.plugin = plugin;
    }

    public boolean sendRequest(Player sender, Player target, TeleportType type) {
        if (!sender.hasPermission("protpa.bypass.cooldown") && this.isOnCooldown(sender)) {
            long remaining = this.getRemainingCooldown(sender);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("cooldown", "time", String.valueOf(remaining)));
            return false;
        }
        if (!sender.hasPermission("protpa.bypass.blocked") && this.plugin.getUserDataManager().isBlocking(target)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("playerBlocking", new String[0]));
            return false;
        }
        if (this.plugin.getConfigManager().getBlacklistWorlds().contains(target.getWorld().getName())) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("worldBlacklisted", new String[0]));
            return false;
        }
        this.cancelRequest(sender);
        TeleportRequest request = new TeleportRequest(sender.getUniqueId(), target.getUniqueId(), type);
        this.pendingRequests.put(target.getUniqueId(), request);
        this.cooldowns.put(sender.getUniqueId(), System.currentTimeMillis());
        sender.sendMessage(this.plugin.getConfigManager().getMessage("requestSent", "target", target.getName()));
        String messageKey = type == TeleportType.TPA ? "requestReceived" : "requestReceivedHere";
        target.sendMessage(this.plugin.getConfigManager().getMessage(messageKey, "sender", sender.getName()));
        if (this.plugin.getConfigManager().isSoundEnabled()) {
            sender.playSound(sender.getLocation(), this.plugin.getConfigManager().getSendRequestSound(), 1.0f, 1.0f);
            target.playSound(target.getLocation(), this.plugin.getConfigManager().getSendRequestSound(), 1.0f, 1.0f);
        }
        if (this.plugin.getConfigManager().isParticlesEnabled()) {
            target.spawnParticle(Particle.HAPPY_VILLAGER, target.getLocation().add(0.0, 2.0, 0.0), 10);
        }
        if (!sender.hasPermission("protpa.bypass.timeout")) {
            this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, task -> {
                if (this.pendingRequests.containsKey(target.getUniqueId()) && this.pendingRequests.get(target.getUniqueId()).equals(request)) {
                    this.expireRequest(target);
                }
            }, (long)this.plugin.getConfigManager().getRequestTimeout(), TimeUnit.SECONDS);
        }
        if (this.plugin.getUserDataManager().isAutoAccepting(target)) {
            this.acceptRequest(target);
        }
        return true;
    }

    public boolean acceptRequest(Player target) {
        Player teleportingPlayer;
        Location toLoc;
        TeleportRequest request = this.pendingRequests.remove(target.getUniqueId());
        if (request == null) {
            target.sendMessage(this.plugin.getConfigManager().getMessage("noRequest", new String[0]));
            return false;
        }
        Player sender = Bukkit.getPlayer((UUID)request.getSenderId());
        if (sender == null) {
            target.sendMessage(this.plugin.getConfigManager().getMessage("senderOffline", new String[0]));
            return false;
        }
        if (request.getType() == TeleportType.TPA) {
            Location fromLoc = sender.getLocation();
            toLoc = target.getLocation();
            teleportingPlayer = sender;
        } else {
            Location fromLoc = target.getLocation();
            toLoc = sender.getLocation();
            teleportingPlayer = target;
        }
        sender.sendMessage(this.plugin.getConfigManager().getMessage("accepted", new String[0]));
        target.sendMessage(this.plugin.getConfigManager().getMessage("accepted", new String[0]));
        if (this.plugin.getConfigManager().isSoundEnabled()) {
            sender.playSound(sender.getLocation(), this.plugin.getConfigManager().getAcceptRequestSound(), 1.0f, 1.0f);
            target.playSound(target.getLocation(), this.plugin.getConfigManager().getAcceptRequestSound(), 1.0f, 1.0f);
        }
        if (teleportingPlayer.hasPermission("protpa.bypass.warmup") || this.plugin.getConfigManager().getWarmup() <= 0) {
            this.performTeleport(teleportingPlayer, toLoc);
        } else {
            this.startWarmup(teleportingPlayer, toLoc);
        }
        return true;
    }

    public boolean denyRequest(Player target) {
        TeleportRequest request = this.pendingRequests.remove(target.getUniqueId());
        if (request == null) {
            target.sendMessage(this.plugin.getConfigManager().getMessage("noRequest", new String[0]));
            return false;
        }
        Player sender = Bukkit.getPlayer((UUID)request.getSenderId());
        if (sender != null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("denied", new String[0]));
        }
        target.sendMessage(this.plugin.getConfigManager().getMessage("deniedSender", new String[0]));
        return true;
    }

    public boolean cancelRequest(Player sender) {
        UUID senderId = sender.getUniqueId();
        TeleportRequest toRemove = null;
        UUID targetId = null;
        for (Map.Entry<UUID, TeleportRequest> entry : this.pendingRequests.entrySet()) {
            if (!entry.getValue().getSenderId().equals(senderId)) continue;
            toRemove = entry.getValue();
            targetId = entry.getKey();
            break;
        }
        if (toRemove == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("noRequestToCancel", new String[0]));
            return false;
        }
        this.pendingRequests.remove(targetId);
        sender.sendMessage(this.plugin.getConfigManager().getMessage("requestCancelled", new String[0]));
        Player target = Bukkit.getPlayer(targetId);
        if (target != null) {
            target.sendMessage(this.plugin.getConfigManager().getMessage("requestCancelledTarget", "sender", sender.getName()));
        }
        return true;
    }

    private void startWarmup(final Player player, final Location destination) {
        final Location startLocation = player.getLocation().clone();
        final int warmupTime = this.plugin.getConfigManager().getWarmup();
        ScheduledTask existingTask = this.warmupTasks.remove(player.getUniqueId());
        if (existingTask != null) {
            existingTask.cancel();
        }
        player.sendMessage(this.plugin.getConfigManager().getMessage("warmup", "time", String.valueOf(warmupTime)));
        ScheduledTask warmupTask = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)new Consumer<ScheduledTask>(){
            int timeLeft;
            {
                this.timeLeft = warmupTime;
            }

            @Override
            public void accept(ScheduledTask task) {
                if (!player.isOnline()) {
                    RequestManager.this.warmupTasks.remove(player.getUniqueId());
                    task.cancel();
                    return;
                }
                if (RequestManager.this.plugin.getConfigManager().isCancelOnMove() && startLocation.distance(player.getLocation()) > 1.0) {
                    player.sendMessage(RequestManager.this.plugin.getConfigManager().getMessage("warmupCancelledMove", new String[0]));
                    RequestManager.this.warmupTasks.remove(player.getUniqueId());
                    task.cancel();
                    return;
                }
                --this.timeLeft;
                if (this.timeLeft <= 0) {
                    RequestManager.this.performTeleport(player, destination);
                    RequestManager.this.warmupTasks.remove(player.getUniqueId());
                    task.cancel();
                } else if (this.timeLeft <= 3) {
                    player.sendMessage(RequestManager.this.plugin.getConfigManager().getMessage("warmupCountdown", "time", String.valueOf(this.timeLeft)));
                }
            }
        }, 1L, 1000L, TimeUnit.MILLISECONDS);
        this.warmupTasks.put(player.getUniqueId(), warmupTask);
    }

    private void performTeleport(Player player, Location destination) {
        this.plugin.getServer().getGlobalRegionScheduler().run((Plugin)this.plugin, task -> {
            player.teleport(destination);
            player.sendMessage(this.plugin.getConfigManager().getMessage("teleported", new String[0]));
            if (this.plugin.getConfigManager().isParticlesEnabled()) {
                player.spawnParticle(Particle.PORTAL, destination, 20);
            }
        });
    }

    public void cancelWarmup(Player player) {
        ScheduledTask task = this.warmupTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
            player.sendMessage(this.plugin.getConfigManager().getMessage("warmupCancelled", new String[0]));
        }
    }

    private void expireRequest(Player target) {
        TeleportRequest request = this.pendingRequests.remove(target.getUniqueId());
        if (request != null) {
            Player sender = Bukkit.getPlayer((UUID)request.getSenderId());
            if (sender != null) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("expired", new String[0]));
            }
            target.sendMessage(this.plugin.getConfigManager().getMessage("expiredTarget", new String[0]));
        }
    }

    private boolean isOnCooldown(Player player) {
        Long lastRequest = this.cooldowns.get(player.getUniqueId());
        if (lastRequest == null) {
            return false;
        }
        long elapsed = (System.currentTimeMillis() - lastRequest) / 1000L;
        return elapsed < (long)this.plugin.getConfigManager().getCooldown();
    }

    private long getRemainingCooldown(Player player) {
        Long lastRequest = this.cooldowns.get(player.getUniqueId());
        if (lastRequest == null) {
            return 0L;
        }
        long elapsed = (System.currentTimeMillis() - lastRequest) / 1000L;
        return Math.max(0L, (long)this.plugin.getConfigManager().getCooldown() - elapsed);
    }

    public boolean hasPendingRequest(Player player) {
        return this.pendingRequests.containsKey(player.getUniqueId());
    }

    public void shutdown() {
        this.warmupTasks.values().forEach(ScheduledTask::cancel);
        this.warmupTasks.clear();
        this.pendingRequests.clear();
        this.cooldowns.clear();
    }
}

